/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.params;

import edu.ucsd.msjava.params.NumberParameter;
import edu.ucsd.msjava.params.ParamManager;

public class IntParameter
extends NumberParameter<Integer> {
    public IntParameter(ParamManager.ParamNameEnum paramInfo) {
        super(paramInfo.getKey(), paramInfo.getName(), paramInfo.getDescription());
        this.setAdditionalDescription(paramInfo.getAdditionalDescription());
    }

    public IntParameter(String key, String name, String description) {
        super(key, name, description);
        this.minValue = 0;
        this.maxValue = Integer.MAX_VALUE;
    }

    @Override
    public String parse(String value) {
        try {
            this.value = Integer.valueOf(this.trimTrailingChars(value, "!"));
            if (this.value == null) {
                return "Value cannot be null";
            }
            if (this.minValue == null && this.maxValue == null) {
                return null;
            }
            if (this.minValue == null) {
                this.minValue = Integer.MIN_VALUE;
            }
            if (this.maxValue == null) {
                this.maxValue = Integer.MAX_VALUE;
            }
            String range = this.getValidRange();
            if ((Integer)this.value < (Integer)this.minValue || (Integer)this.value > (Integer)this.maxValue || !this.isMinInclusive && ((Integer)this.value).equals(this.minValue) || !this.isMaxInclusive && ((Integer)this.value).equals(this.maxValue)) {
                if (this.isMinInclusive && this.isMaxInclusive) {
                    return "must be in the range " + this.minValue + " to " + this.maxValue;
                }
                if (this.isMinInclusive) {
                    return "must be in the range " + this.minValue + " to " + ((Integer)this.maxValue - 1);
                }
                if (!this.isMinInclusive && this.isMaxInclusive) {
                    return "must be in the range " + ((Integer)this.minValue + 1) + " to " + this.maxValue;
                }
                return "must be in the range " + range;
            }
        }
        catch (NumberFormatException e) {
            return "must be an integer";
        }
        return null;
    }
}

