/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.params;

import edu.ucsd.msjava.msutil.ActivationMethod;
import edu.ucsd.msjava.msutil.DBFileFormat;
import edu.ucsd.msjava.msutil.Enzyme;
import edu.ucsd.msjava.msutil.FileFormat;
import edu.ucsd.msjava.msutil.InstrumentType;
import edu.ucsd.msjava.msutil.Protocol;
import edu.ucsd.msjava.msutil.SpecFileFormat;
import edu.ucsd.msjava.params.CaseInsensitiveLinkedHashMapParam;
import edu.ucsd.msjava.params.DoubleParameter;
import edu.ucsd.msjava.params.EnumParameter;
import edu.ucsd.msjava.params.FileListParameter;
import edu.ucsd.msjava.params.FileParameter;
import edu.ucsd.msjava.params.FloatParameter;
import edu.ucsd.msjava.params.IntParameter;
import edu.ucsd.msjava.params.IntRangeParameter;
import edu.ucsd.msjava.params.ObjectEnumParameter;
import edu.ucsd.msjava.params.Parameter;
import edu.ucsd.msjava.params.StringParameter;
import edu.ucsd.msjava.params.ToleranceParameter;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;

public class ParamManager {
    private CaseInsensitiveLinkedHashMapParam params;
    private String toolName;
    private String version;
    private String date;
    private String command;
    private ArrayList<String> examples = new ArrayList();

    public ParamManager(String toolName, String version, String date, String command) {
        this.toolName = toolName;
        this.version = version;
        this.date = date;
        this.command = command;
        this.params = new CaseInsensitiveLinkedHashMapParam();
    }

    public boolean addParameter(Parameter param) {
        if (this.params.containsKey(param.getKey())) {
            System.err.println("ParamManager: duplicate key (" + param.getKey() + ")");
            System.exit(-1);
        }
        this.params.put(param.getKey(), param);
        return true;
    }

    private void addExample(String example) {
        this.examples.add(example);
    }

    public Parameter getParameter(String key) {
        return this.params.get(key);
    }

    public String isValid() {
        for (Map.Entry entry : this.params.entrySet()) {
            Parameter param = (Parameter)entry.getValue();
            if (param.isValid()) continue;
            return "Parameter -" + param.getKey() + " (" + param.getName() + ") is missing";
        }
        return null;
    }

    public void printToolInfo() {
        System.out.println(this.toolName + " " + this.version + " (" + this.date + ")");
    }

    public void printJVMInfo() {
        System.out.println("Java " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")");
        System.out.println(System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ", version " + System.getProperty("os.version") + ")");
    }

    public void printUsageInfo() {
        System.out.println();
        System.out.println(this.toolName + " " + this.version + " (" + this.date + ")");
        System.out.println();
        System.out.println("Usage: " + this.command);
        ArrayList<Parameter> optParams = new ArrayList<Parameter>();
        for (Map.Entry entry : this.params.entrySet()) {
            Parameter param = (Parameter)entry.getValue();
            if (param.isHidden()) continue;
            if (!param.isOptional()) {
                System.out.println("\t" + param);
                if (param.getAdditionalDescription() == null) continue;
                System.out.println("\t   " + param.getAdditionalDescription());
                continue;
            }
            optParams.add(param);
        }
        for (Parameter param : optParams) {
            System.out.println("\t" + param);
            if (param.getAdditionalDescription() == null) continue;
            System.out.println("\t   " + param.getAdditionalDescription());
        }
        System.out.println();
        for (String example : this.examples) {
            System.out.println(example);
        }
        System.out.println();
        System.out.println("For Thermo .raw files, obtain a centroided .mzML file using MSConvert, which is part of ProteoWizard (http://proteowizard.sourceforge.net/)");
        System.out.println("  MSConvert.exe DatasetName.raw --filter \"peakPicking true 1-\" --mzML --32");
        System.out.println();
        System.out.println("To add or override the enzyme definitions, create a file named enzymes.txt in a directory named params below the working directory.");
        System.out.println("For example, create file C:\\Work\\params\\enzymes.txt when the working directory is C:\\Work");
        System.out.println("Example enzymes.txt file: https://github.com/MSGFPlus/msgfplus/blob/master/docs/examples/enzymes.txt");
        System.out.println();
        System.out.println("Documentation: https://msgfplus.github.io/msgfplus/");
        System.out.println("Releases:      https://github.com/MSGFPlus/msgfplus/releases");
    }

    public void printValues() {
        for (Map.Entry entry : this.params.entrySet()) {
            Parameter param = (Parameter)entry.getValue();
            System.out.println(param.getKey() + "\t" + param.getValueAsString());
        }
    }

    public String parseParams(String[] argv) {
        if (argv.length == 0) {
            return "No parameter specified.";
        }
        if (argv.length < 2 || argv.length % 2 != 0) {
            return "The number of parameters must be even. If a file path has a space, surround it with double quotes.";
        }
        for (int i = 0; i < argv.length; i += 2) {
            if (!argv[i].startsWith("-") || i + 1 >= argv.length || argv[i].length() <= 1) {
                return "Syntax error; parameter names must start with a dash: " + argv[i];
            }
            String key = argv[i].substring(1);
            Parameter param = this.params.get(key);
            if (param == null) {
                return "Invalid parameter: " + argv[i] + ".";
            }
            String error = param.parse(argv[i + 1]);
            if (error != null) {
                String err = "Invalid value for parameter " + argv[i] + ": " + argv[i + 1];
                err = err + "\n        (" + error + ")";
                return err;
            }
            param.setValueAssigned();
        }
        String error = this.isValid();
        if (error != null) {
            return error;
        }
        return null;
    }

    public void addSpecFileParam(boolean isOptional) {
        FileParameter specFileParam = new FileParameter(ParamNameEnum.SPECTRUM_FILE);
        if (isOptional) {
            specFileParam.setAsOptional();
        }
        specFileParam.addFileFormat(SpecFileFormat.MZML);
        specFileParam.addFileFormat(SpecFileFormat.MZXML);
        specFileParam.addFileFormat(SpecFileFormat.MGF);
        specFileParam.addFileFormat(SpecFileFormat.MS2);
        specFileParam.addFileFormat(SpecFileFormat.PKL);
        specFileParam.addFileFormat(SpecFileFormat.DTA_TXT);
        specFileParam.addFileFormat(FileFormat.DIRECTORY);
        specFileParam.fileMustExist();
        specFileParam.setAdditionalDescription(ParamNameEnum.SPECTRUM_FILE.additionalDescription);
        this.addParameter(specFileParam);
    }

    private void addDBFileParam(boolean isOptional) {
        this.addDBFileParam(ParamNameEnum.DB_FILE, isOptional);
    }

    private void addDBFileParam(ParamNameEnum paramInfo, boolean isOptional) {
        FileParameter dbFileParam = new FileParameter(paramInfo);
        if (isOptional) {
            dbFileParam.setAsOptional();
        }
        dbFileParam.addFileFormat(DBFileFormat.FASTA);
        dbFileParam.fileMustExist();
        dbFileParam.mustBeAFile();
        this.addParameter(dbFileParam);
    }

    private void addDBFileParam(String key, String description, boolean isOptional) {
        FileParameter dbFileParam = new FileParameter(key, ParamNameEnum.DB_FILE.name, description);
        if (isOptional) {
            dbFileParam.setAsOptional();
        }
        dbFileParam.addFileFormat(DBFileFormat.FASTA);
        dbFileParam.fileMustExist();
        dbFileParam.mustBeAFile();
        this.addParameter(dbFileParam);
    }

    private void addDecoyPrefixParam() {
        this.addDecoyPrefixParam("XXX");
    }

    private void addDecoyPrefixParam(String defaultDecoyPrefix) {
        StringParameter decoyPrefixParam = new StringParameter(ParamNameEnum.DECOY_PREFIX);
        decoyPrefixParam.defaultValue(defaultDecoyPrefix);
        this.addParameter(decoyPrefixParam);
    }

    private void addPrecursorMassToleranceParam() {
        ToleranceParameter pmTolParam = new ToleranceParameter(ParamNameEnum.PRECURSOR_MASS_TOLERANCE);
        pmTolParam.defaultValue("20ppm");
        this.addParameter(pmTolParam);
    }

    private void addMzIdOutputFileParam() {
        FileParameter outputParam = new FileParameter(ParamNameEnum.MZID_OUTPUT_FILE);
        outputParam.addFileFormat(new FileFormat(".mzid").setCaseSensitive());
        outputParam.setAsOptional();
        this.addParameter(outputParam);
    }

    private void addOutputFileParam() {
        FileParameter outputParam = new FileParameter(ParamNameEnum.OUTPUT_FILE);
        outputParam.setAsOptional();
        outputParam.fileMustNotExist();
        this.addParameter(outputParam);
    }

    private void addFragMethodParam(ActivationMethod defaultMethod, boolean doNotAddMergeMode) {
        ActivationMethod[] methods;
        ObjectEnumParameter<ActivationMethod> fragParam = new ObjectEnumParameter<ActivationMethod>(ParamNameEnum.FRAG_METHOD);
        for (ActivationMethod m : methods = ActivationMethod.getAllRegisteredActivationMethods()) {
            if (doNotAddMergeMode && m == ActivationMethod.FUSION) continue;
            fragParam.registerObject(m);
            if (m != defaultMethod) continue;
            fragParam.setDefault();
        }
        this.addParameter(fragParam);
    }

    private void addInstTypeParam() {
        this.addInstTypeParam(InstrumentType.LOW_RESOLUTION_LTQ);
    }

    private void addInstTypeParam(InstrumentType defaultInst) {
        InstrumentType[] allInstTypes;
        ObjectEnumParameter<InstrumentType> instParam = new ObjectEnumParameter<InstrumentType>(ParamNameEnum.INSTRUMENT_TYPE);
        for (InstrumentType inst : allInstTypes = InstrumentType.getAllRegisteredInstrumentTypes()) {
            instParam.registerObject(inst);
            if (inst != defaultInst) continue;
            instParam.setDefault();
        }
        this.addParameter(instParam);
    }

    private void addEnzymeParam() {
        this.addEnzymeParam(Enzyme.TRYPSIN);
    }

    private void addEnzymeParam(Enzyme enzymeId) {
        Enzyme[] allEnzymes;
        ObjectEnumParameter<Enzyme> enzParam = new ObjectEnumParameter<Enzyme>(ParamNameEnum.ENZYME_ID);
        for (Enzyme e : allEnzymes = Enzyme.getAllRegisteredEnzymes()) {
            enzParam.registerObject(e);
            if (e != enzymeId) continue;
            enzParam.setDefault();
        }
        this.addParameter(enzParam);
    }

    private void addProtocolParam() {
        this.addProtocolParam(Protocol.AUTOMATIC);
    }

    private void addProtocolParam(Protocol defaultProtocol) {
        Protocol[] protocols;
        ObjectEnumParameter<Protocol> protocolParam = new ObjectEnumParameter<Protocol>(ParamNameEnum.PROTOCOL_ID);
        for (Protocol protocol : protocols = Protocol.getAllRegisteredProtocols()) {
            protocolParam.registerObject(protocol);
            if (protocol != defaultProtocol) continue;
            protocolParam.setDefault();
        }
        this.addParameter(protocolParam);
    }

    private void addEnzymeSpecificityParam() {
        EnumParameter nttParam = new EnumParameter(ParamNameEnum.ENZYME_SPECIFICITY);
        nttParam.registerEntry("");
        nttParam.registerEntry("");
        nttParam.registerEntry("").setDefault();
        this.addParameter(nttParam);
    }

    private void addModFileParam() {
        FileParameter modParam = new FileParameter(ParamNameEnum.MOD_FILE);
        modParam.setAsOptional();
        modParam.fileMustExist();
        this.addParameter(modParam);
    }

    private void addConfigFileParam() {
        FileParameter configFile = new FileParameter(ParamNameEnum.CONFIGURATION_FILE);
        configFile.setAsOptional();
        configFile.fileMustExist();
        this.addParameter(configFile);
    }

    private void addIsotopeRangeParam() {
        IntRangeParameter isotopeRange = new IntRangeParameter(ParamNameEnum.ISOTOPE_ERROR);
        isotopeRange.setMaxInclusive();
        isotopeRange.defaultValue("0,1");
        this.addParameter(isotopeRange);
    }

    private IntParameter addNumThreadsParam() {
        IntParameter numThreadsParam = new IntParameter(ParamNameEnum.NUM_THREADS);
        numThreadsParam.defaultValue(Runtime.getRuntime().availableProcessors());
        numThreadsParam.minValue(1);
        this.addParameter(numThreadsParam);
        return numThreadsParam;
    }

    private void addVerboseModeParam() {
        EnumParameter verboseOutputParam = new EnumParameter(ParamNameEnum.VERBOSE);
        verboseOutputParam.registerEntry("Report total progress only").setDefault();
        verboseOutputParam.registerEntry("Report total and per-thread progress/status");
        this.addParameter(verboseOutputParam);
    }

    private void addNumTasksParam() {
        IntParameter numTasksParam = new IntParameter(ParamNameEnum.NUM_TASKS);
        numTasksParam.defaultValue(0);
        numTasksParam.minValue(-10);
        this.addParameter(numTasksParam);
    }

    private void addTdaParam() {
        EnumParameter tdaParam = new EnumParameter(ParamNameEnum.TDA_STRATEGY);
        tdaParam.registerEntry("Don't search decoy database").setDefault();
        tdaParam.registerEntry("Search decoy database");
        this.addParameter(tdaParam);
    }

    private void addMinPeptideLengthParam() {
        IntParameter minLenParam = new IntParameter(ParamNameEnum.MIN_PEPTIDE_LENGTH);
        minLenParam.minValue(1);
        minLenParam.defaultValue(6);
        this.addParameter(minLenParam);
    }

    private void addMaxPeptideLengthParam() {
        IntParameter maxLenParam = new IntParameter(ParamNameEnum.MAX_PEPTIDE_LENGTH);
        maxLenParam.minValue(1);
        maxLenParam.defaultValue(40);
        this.addParameter(maxLenParam);
    }

    private void addMinChargeParam() {
        IntParameter minCharge = new IntParameter(ParamNameEnum.MIN_CHARGE);
        minCharge.minValue(1);
        minCharge.defaultValue(2);
        this.addParameter(minCharge);
    }

    private void addMaxChargeParam() {
        IntParameter maxCharge = new IntParameter(ParamNameEnum.MAX_CHARGE);
        maxCharge.minValue(1);
        maxCharge.defaultValue(3);
        this.addParameter(maxCharge);
    }

    private void addNumMatchesPerSpecParam() {
        IntParameter numMatchesParam = new IntParameter(ParamNameEnum.NUM_MATCHES_SPEC);
        numMatchesParam.minValue(1);
        numMatchesParam.defaultValue(1);
        this.addParameter(numMatchesParam);
    }

    private void addAddFeaturesParam() {
        EnumParameter addFeatureParam = new EnumParameter(ParamNameEnum.ADD_FEATURES);
        addFeatureParam.registerEntry("Output basic scores only").setDefault();
        addFeatureParam.registerEntry("Output additional features");
        this.addParameter(addFeatureParam);
    }

    private void addChargeCarrierMassParam() {
        DoubleParameter chargeCarrierMassParam = new DoubleParameter(ParamNameEnum.CHARGE_CARRIER_MASSES);
        chargeCarrierMassParam.minValue(0.1);
        chargeCarrierMassParam.setMaxInclusive();
        chargeCarrierMassParam.defaultValue(1.00727649);
        this.addParameter(chargeCarrierMassParam);
    }

    private void addMaxMissedCleavagesParam() {
        IntParameter maxMissedCleavages = new IntParameter(ParamNameEnum.MAX_MISSED_CLEAVAGES);
        maxMissedCleavages.minValue(-1);
        maxMissedCleavages.defaultValue(-1);
        this.addParameter(maxMissedCleavages);
    }

    private void addMaxNumModsParam() {
        IntParameter maxNumMods = new IntParameter(ParamNameEnum.MAX_NUM_MODS);
        maxNumMods.minValue(0);
        maxNumMods.defaultValue(3);
        this.addParameter(maxNumMods);
    }

    private void addAllowDenseCentroidedPeaksParam() {
        EnumParameter allowDenseCentroidedPeaksParam = new EnumParameter(ParamNameEnum.ALLOW_DENSE_CENTROIDED_PEAKS);
        allowDenseCentroidedPeaksParam.registerEntry("Skip all spectra that fail a peak density check").setDefault();
        allowDenseCentroidedPeaksParam.registerEntry("Allow mzML/mzXML centroided spectra that fail a peak density check");
        this.addParameter(allowDenseCentroidedPeaksParam);
    }

    private void addDbIndexDirParam(boolean isHidden) {
        FileParameter dbIndexDirParam = new FileParameter(ParamNameEnum.DD_DIRECTORY);
        dbIndexDirParam.fileMustExist();
        dbIndexDirParam.mustBeADirectory();
        dbIndexDirParam.setAsOptional();
        if (isHidden) {
            dbIndexDirParam.setHidden();
        }
        this.addParameter(dbIndexDirParam);
    }

    private void addPrecursorMassToleranceUnitsParam(boolean isHidden) {
        EnumParameter unitParam = new EnumParameter(ParamNameEnum.PRECURSOR_MASS_TOLERANCE_UNITS);
        unitParam.registerEntry("Da");
        unitParam.registerEntry("ppm");
        unitParam.registerEntry("Don't care").setDefault();
        if (isHidden) {
            unitParam.setHidden();
        }
        this.addParameter(unitParam);
    }

    private void addSpecIndexRangeParam(boolean isHidden) {
        IntRangeParameter specIndexParam = new IntRangeParameter(ParamNameEnum.SPEC_INDEX);
        specIndexParam.minValue(1);
        specIndexParam.setMaxInclusive();
        specIndexParam.defaultValue("1,2147483646");
        if (isHidden) {
            specIndexParam.setHidden();
        }
        this.addParameter(specIndexParam);
    }

    private void addEdgeScoreParam(boolean isHidden) {
        EnumParameter edgeScoreParam = new EnumParameter(ParamNameEnum.EDGE_SCORE.key);
        edgeScoreParam.registerEntry("Use edge scoring").setDefault();
        edgeScoreParam.registerEntry("Do not use edge scoring");
        if (isHidden) {
            edgeScoreParam.setHidden();
        }
        this.addParameter(edgeScoreParam);
    }

    private void addMinNumPeaksParam(boolean isHidden) {
        IntParameter minNumPeaksParam = new IntParameter(ParamNameEnum.MIN_NUM_PEAKS);
        minNumPeaksParam.defaultValue(10);
        if (isHidden) {
            minNumPeaksParam.setHidden();
        }
        this.addParameter(minNumPeaksParam);
    }

    private void addNumIsoformsParam(boolean isHidden) {
        IntParameter isoParam = new IntParameter(ParamNameEnum.NUM_ISOFORMS);
        isoParam.defaultValue(128);
        if (isHidden) {
            isoParam.setHidden();
        }
        this.addParameter(isoParam);
    }

    private void addMetCleavageParamParam(boolean isHidden) {
        EnumParameter metCleavageParam = new EnumParameter(ParamNameEnum.IGNORE_MET_CLEAVAGE);
        metCleavageParam.registerEntry("Consider protein N-term Met cleavage").setDefault();
        metCleavageParam.registerEntry("Ignore protein N-term Met cleavage");
        if (isHidden) {
            metCleavageParam.setHidden();
        }
        this.addParameter(metCleavageParam);
    }

    private void addMinDeNovoScoreParam(boolean isHidden) {
        IntParameter minDeNovoScoreParam = new IntParameter(ParamNameEnum.MIN_DE_NOVO_SCORE);
        minDeNovoScoreParam.minValue(Integer.MIN_VALUE);
        minDeNovoScoreParam.defaultValue(0);
        if (isHidden) {
            minDeNovoScoreParam.setHidden();
        }
        this.addParameter(minDeNovoScoreParam);
    }

    public void addMSGFPlusParams() {
        this.addConfigFileParam();
        this.addSpecFileParam(true);
        this.addDBFileParam(true);
        this.addDecoyPrefixParam();
        this.addMzIdOutputFileParam();
        this.addPrecursorMassToleranceParam();
        this.addPrecursorMassToleranceUnitsParam(true);
        this.addIsotopeRangeParam();
        this.addNumThreadsParam();
        this.addNumTasksParam();
        this.addVerboseModeParam();
        this.addTdaParam();
        this.addFragMethodParam(ActivationMethod.ASWRITTEN, true);
        this.addInstTypeParam();
        this.addEnzymeParam();
        this.addProtocolParam();
        this.addEnzymeSpecificityParam();
        this.addModFileParam();
        this.addMinPeptideLengthParam();
        this.addMaxPeptideLengthParam();
        this.addMinChargeParam();
        this.addMaxChargeParam();
        this.addNumMatchesPerSpecParam();
        this.addAddFeaturesParam();
        this.addChargeCarrierMassParam();
        this.addMaxMissedCleavagesParam();
        this.addMaxNumModsParam();
        this.addAllowDenseCentroidedPeaksParam();
        this.addExample("Example (high-precision): java -Xmx3500M -jar MSGFPlus.jar -s test.mzML -d IPI_human_3.79.fasta -inst 1 -t 20ppm -ti -1,2 -ntt 2 -tda 1 -o testMSGFPlus.mzid -mod Mods.txt");
        this.addExample("Example (low-precision):  java -Xmx3500M -jar MSGFPlus.jar -s test.mzML -d IPI_human_3.79.fasta -inst 0 -t 0.5Da,2.5Da    -ntt 2 -tda 1 -o testMSGFPlus.mzid -mod Mods.txt");
        this.addDbIndexDirParam(true);
        this.addSpecIndexRangeParam(true);
        this.addEdgeScoreParam(true);
        this.addMinNumPeaksParam(true);
        this.addNumIsoformsParam(true);
        this.addMetCleavageParamParam(true);
        this.addMinDeNovoScoreParam(true);
    }

    public void addScoringParamGenParams() {
        FileListParameter resFileParam = new FileListParameter("i", "ResultPath", "MSGFDBResultFile (*.mzid) or MSGFDBResultDir");
        resFileParam.addFileFormat(new FileFormat(".mzid"));
        resFileParam.addFileFormat(new FileFormat(".tsv"));
        resFileParam.setAdditionalDescription("mzid files are converted to tsv using default settings before use.\n\t   If you are going to run ScoringParamGen multiple times on the same data (with different parameters),\n\t   convert any mzid files to tsv prior to running ScoringParamGen.");
        this.addParameter(resFileParam);
        FileParameter specDirParam = new FileParameter("d", "SpecDir", "Path to directory containing spectrum files");
        specDirParam.mustBeADirectory();
        specDirParam.fileMustExist();
        this.addParameter(specDirParam);
        ObjectEnumParameter<ActivationMethod> fragParam = new ObjectEnumParameter<ActivationMethod>(ParamNameEnum.FRAG_METHOD);
        ActivationMethod[] methods = ActivationMethod.getAllRegisteredActivationMethods();
        for (int i = 1; i < methods.length; ++i) {
            ActivationMethod m = methods[i];
            if (m == ActivationMethod.FUSION) continue;
            fragParam.registerObject(m);
        }
        this.addParameter(fragParam);
        this.addInstTypeParam(null);
        this.addEnzymeParam();
        this.addProtocolParam();
        IntParameter numThreadsParam = this.addNumThreadsParam();
        numThreadsParam.defaultValue(Runtime.getRuntime().availableProcessors() / 2);
        EnumParameter dropErrors = new EnumParameter("dropErrors");
        dropErrors.setAdditionalDescription("If 0, stop processing if an error occurs; if 1, discard results from datasets with errors.");
        dropErrors.registerEntry("Fail on first dataset with errors").setDefault();
        dropErrors.registerEntry("Drop results from datasets with errors");
        this.addParameter(dropErrors);
        this.addExample("Example (high-precision): java -Xmx4G -cp MSGFPlus.jar edu.ucsd.msjava.ui.ScoringParamGen -i resultsFolder -d spectraFolder -m 2 -e 1 -protocol 5 -thread 4 -dropErrors 1");
        EnumParameter mgfParam = new EnumParameter("mgf");
        mgfParam.registerEntry("Do not create annotated mgf").setDefault();
        mgfParam.registerEntry("Create annotated mgf");
        mgfParam.setHidden();
        this.addParameter(mgfParam);
    }

    @Deprecated
    public void addMSGFDBParams() {
        this.addSpecFileParam(false);
        this.addDBFileParam(false);
        this.addPrecursorMassToleranceParam();
        this.addPrecursorMassToleranceUnitsParam(true);
        this.addOutputFileParam();
        this.addNumThreadsParam();
        this.addTdaParam();
        this.addFragMethodParam(ActivationMethod.ASWRITTEN, false);
        this.addInstTypeParam();
        this.addEnzymeParam();
        this.addProtocolParam();
        EnumParameter c13Param = new EnumParameter(ParamNameEnum.C13);
        c13Param.registerEntry("Consider only peptides matching precursor mass");
        c13Param.registerEntry("Consider peptides having one 13C").setDefault();
        c13Param.registerEntry("Consider peptides having up to two 13C");
        this.addParameter(c13Param);
        EnumParameter nnetParam = new EnumParameter(ParamNameEnum.NNET);
        nnetParam.registerEntry("");
        nnetParam.registerEntry("").setDefault();
        nnetParam.registerEntry("");
        this.addParameter(nnetParam);
        this.addModFileParam();
        this.addMinPeptideLengthParam();
        this.addMaxPeptideLengthParam();
        this.addMinChargeParam();
        this.addMaxChargeParam();
        this.addNumMatchesPerSpecParam();
        EnumParameter uniformAAProb = new EnumParameter(ParamNameEnum.UNIFORM_AA_PROBABILITY);
        uniformAAProb.registerEntry("Use amino acid probabilities computed from the input database").setDefault();
        uniformAAProb.registerEntry("Use probability 0.05 for all amino acids");
        this.addParameter(uniformAAProb);
        this.addAllowDenseCentroidedPeaksParam();
        this.addExample("Example (high-precision): java -Xmx2000M -jar MSGFDB.jar -s test.mzXML -d IPI_human_3.79.fasta -t 30ppm -c13 1 -nnet 0 -tda 1 -o testMSGFDB.tsv");
        this.addExample("Example (low-precision):  java -Xmx2000M -jar MSGFDB.jar -s test.mzXML -d IPI_human_3.79.fasta -t 0.5Da,2.5Da  -nnet 0 -tda 1 -o testMSGFDB.tsv");
        this.addDbIndexDirParam(true);
        this.addSpecIndexRangeParam(true);
        EnumParameter showFDRParam = new EnumParameter("showFDR");
        showFDRParam.registerEntry("Do not show FDRs");
        showFDRParam.registerEntry("Show FDRs").setDefault();
        showFDRParam.setHidden();
        this.addParameter(showFDRParam);
        EnumParameter showDecoyParam = new EnumParameter("showDecoy");
        showDecoyParam.registerEntry("Do not show decoy PSMs").setDefault();
        showDecoyParam.registerEntry("Show decoy PSMs");
        showDecoyParam.setHidden();
        this.addParameter(showDecoyParam);
        EnumParameter replicateMergedResParam = new EnumParameter("replicate");
        replicateMergedResParam.registerEntry("Show merged spectra").setDefault();
        replicateMergedResParam.registerEntry("Show individual spectra");
        replicateMergedResParam.setHidden();
        this.addParameter(replicateMergedResParam);
        this.addEdgeScoreParam(true);
    }

    public void addMSGFParams() {
        FileParameter resFileParam = new FileParameter("i", "ResultFile", "ResultFile");
        resFileParam.fileMustExist();
        this.addParameter(resFileParam);
        FileParameter specDirParam = new FileParameter("d", "SpecDir", "Path to directory containing spectrum files");
        specDirParam.mustBeADirectory();
        specDirParam.fileMustExist();
        this.addParameter(specDirParam);
        this.addOutputFileParam();
        this.addDBFileParam("db", "To get AA frequencies, if not specified, 1/20 is used for all AAs", true);
        this.addFragMethodParam(ActivationMethod.ASWRITTEN, true);
        this.addInstTypeParam();
        this.addEnzymeParam();
        EnumParameter fixModParam = new EnumParameter("fixMod");
        fixModParam.registerEntry("NoCysteineProtection");
        fixModParam.registerEntry("Carbamidomethyl-C").setDefault();
        fixModParam.registerEntry("Carboxymethyl-C");
        this.addParameter(fixModParam);
        EnumParameter numSpecParam = new EnumParameter("x");
        numSpecParam.registerEntry("All").setDefault();
        numSpecParam.registerEntry("OnePerSpec");
        this.addParameter(numSpecParam);
        FloatParameter spThParam = new FloatParameter("p", "SpecProbThreshold", "Spectral probability threshold (Default: 1)");
        spThParam.minValue(Float.valueOf(0.0f)).setMinExclusive();
        spThParam.maxValue(Float.valueOf(1.0f)).setMaxInclusive();
        spThParam.defaultValue(Float.valueOf(1.0f));
        this.addParameter(spThParam);
        EnumParameter addScoreParam = new EnumParameter("addScore");
        addScoreParam.registerEntry("Don't add MSGFScore").setDefault();
        addScoreParam.registerEntry("Add MSGFScore");
        this.addParameter(addScoreParam);
    }

    public void addMSGFLibParams() {
        this.addSpecFileParam(false);
        FileParameter libFileParam = new FileParameter("d", "LibraryFile", "*.sptxt");
        libFileParam.addFileFormat(new FileFormat(".sptxt"));
        libFileParam.fileMustExist();
        libFileParam.mustBeAFile();
        this.addParameter(libFileParam);
        this.addPrecursorMassToleranceParam();
        this.addOutputFileParam();
        this.addNumThreadsParam();
        this.addFragMethodParam(ActivationMethod.ASWRITTEN, false);
        this.addInstTypeParam();
        this.addEnzymeParam();
        this.addProtocolParam();
        EnumParameter c13Param = new EnumParameter(ParamNameEnum.C13);
        c13Param.registerEntry("Consider only peptides matching precursor mass");
        c13Param.registerEntry("Consider peptides having one 13C").setDefault();
        c13Param.registerEntry("Consider peptides having up to two 13C");
        this.addParameter(c13Param);
        IntParameter numMatchesParam = new IntParameter("n", "NumMatchesPerSpec", "Number of matches per spectrum to be reported, Default: 1");
        numMatchesParam.minValue(1);
        numMatchesParam.defaultValue(1);
        this.addParameter(numMatchesParam);
        this.addExample("Example: java -Xmx2000M -jar MSGFLib.jar -s test.mzXML -d IPI_human_3.79.fasta -t 30ppm -c13 1 -nnet 0 -o testMSGFDB.tsv");
    }

    public FileParameter getSpecFileParam() {
        return (FileParameter)this.getParameter(ParamNameEnum.SPECTRUM_FILE.key);
    }

    public FileParameter getDBFileParam() {
        return (FileParameter)this.getParameter(ParamNameEnum.DB_FILE.key);
    }

    public String getDecoyProteinPrefix() {
        StringParameter decoyProteinPrefixParam = (StringParameter)this.getParameter(ParamNameEnum.DECOY_PREFIX.key);
        return decoyProteinPrefixParam.value;
    }

    public double getChargeCarrierMass() {
        return this.getDoubleValue(ParamNameEnum.CHARGE_CARRIER_MASSES.key);
    }

    public ToleranceParameter getPrecursorMassToleranceParam() {
        return (ToleranceParameter)this.getParameter(ParamNameEnum.PRECURSOR_MASS_TOLERANCE.key);
    }

    public int getToleranceUnit() {
        return this.getIntValue(ParamNameEnum.PRECURSOR_MASS_TOLERANCE_UNITS.key);
    }

    public IntRangeParameter getIsotopeRangeParameter() {
        return (IntRangeParameter)this.getParameter(ParamNameEnum.ISOTOPE_ERROR.key);
    }

    public FileParameter getOutputFileParam() {
        return (FileParameter)this.getParameter(ParamNameEnum.OUTPUT_FILE.key);
    }

    public ActivationMethod getActivationMethod() {
        return (ActivationMethod)((ObjectEnumParameter)this.getParameter(ParamNameEnum.FRAG_METHOD.key)).getObject();
    }

    public InstrumentType getInstType() {
        return (InstrumentType)((ObjectEnumParameter)this.getParameter(ParamNameEnum.INSTRUMENT_TYPE.key)).getObject();
    }

    public Enzyme getEnzyme() {
        return (Enzyme)((ObjectEnumParameter)this.getParameter(ParamNameEnum.ENZYME_ID.key)).getObject();
    }

    public int getNumTolerableTermini() {
        return this.getIntValue(ParamNameEnum.ENZYME_SPECIFICITY.key);
    }

    public int getNumMatchesPerSpectrum() {
        return this.getIntValue(ParamNameEnum.NUM_MATCHES_SPEC.key);
    }

    public IntRangeParameter getSpecIndexParameter() {
        return (IntRangeParameter)this.getParameter(ParamNameEnum.SPEC_INDEX.key);
    }

    public int getTDA() {
        return this.getIntValue(ParamNameEnum.TDA_STRATEGY.key);
    }

    public int getIgnoreMetCleavage() {
        return this.getIntValue(ParamNameEnum.IGNORE_MET_CLEAVAGE.key);
    }

    public int getOutputAdditionalFeatures() {
        return this.getIntValue(ParamNameEnum.ADD_FEATURES.key);
    }

    public int getMinPeptideLength() {
        return this.getIntValue(ParamNameEnum.MIN_PEPTIDE_LENGTH.key);
    }

    public int getMaxPeptideLength() {
        return this.getIntValue(ParamNameEnum.MAX_PEPTIDE_LENGTH.key);
    }

    public int getMaxNumVariantsPerPeptide() {
        return this.getIntValue(ParamNameEnum.NUM_ISOFORMS.key);
    }

    public int getMinCharge() {
        return this.getIntValue(ParamNameEnum.MIN_CHARGE.key);
    }

    public int getMaxCharge() {
        return this.getIntValue(ParamNameEnum.MAX_CHARGE.key);
    }

    public int getNumThreads() {
        return this.getIntValue(ParamNameEnum.NUM_THREADS.key);
    }

    public int getNumTasks() {
        return this.getIntValue(ParamNameEnum.NUM_TASKS.key);
    }

    public int getVerboseFlag() {
        return this.getIntValue(ParamNameEnum.VERBOSE.key);
    }

    public int getEdgeScoreFlag() {
        return this.getIntValue(ParamNameEnum.EDGE_SCORE.key);
    }

    public File getDatabaseIndexDir() {
        return this.getFile("dd");
    }

    public int getMinNumPeaksPerSpectrum() {
        return this.getIntValue(ParamNameEnum.MIN_NUM_PEAKS.key);
    }

    public int getMinDeNovoScore() {
        return this.getIntValue(ParamNameEnum.MIN_DE_NOVO_SCORE.key);
    }

    public int getMaxMissedCleavages() {
        return this.getIntValue(ParamNameEnum.MAX_MISSED_CLEAVAGES.key);
    }

    public int getMaxNumModsPerPeptide() {
        Parameter param = this.getParameter(ParamNameEnum.MAX_NUM_MODS.key);
        if (param == null) {
            this.addMaxNumModsParam();
        }
        return this.getIntValue(ParamNameEnum.MAX_NUM_MODS.key);
    }

    public Protocol getProtocol() {
        return (Protocol)((ObjectEnumParameter)this.getParameter(ParamNameEnum.PROTOCOL_ID.key)).getObject();
    }

    public FileParameter getModFileParam() {
        return (FileParameter)this.getParameter(ParamNameEnum.MOD_FILE.key);
    }

    public FileParameter getConfigFileParam() {
        return (FileParameter)this.getParameter(ParamNameEnum.CONFIGURATION_FILE.key);
    }

    public int getAllowDenseCentroidedPeaks() {
        return this.getIntValue(ParamNameEnum.ALLOW_DENSE_CENTROIDED_PEAKS.key);
    }

    public int getIntValue(String key) {
        Parameter param = this.getParameter(key);
        if (param instanceof IntParameter) {
            return (Integer)((IntParameter)param).getValue();
        }
        System.err.println("[Error] in ParamManager.getIntValue: " + key + " is not an instance of IntParameter.");
        System.exit(-1);
        return -1;
    }

    public float getFloatValue(String key) {
        Parameter param = this.getParameter(key);
        if (param instanceof FloatParameter) {
            return ((Float)((FloatParameter)param).getValue()).floatValue();
        }
        System.err.println("[Error] in ParamManager.getFloatValue: " + key + " is not an instance of FloatParameter.");
        System.exit(-1);
        return -1.0f;
    }

    public double getDoubleValue(String key) {
        Parameter param = this.getParameter(key);
        if (param instanceof DoubleParameter) {
            return (Double)((DoubleParameter)param).getValue();
        }
        System.err.println("[Error] in ParamManager.getDoubleValue: " + key + " is not an instance of DoubleParameter.");
        System.exit(-1);
        return -1.0;
    }

    public File getFile(String key) {
        Parameter param = this.getParameter(key);
        if (param instanceof FileParameter) {
            return ((FileParameter)param).getFile();
        }
        System.err.println("[Error] in ParamManager.getFile: " + key + " is not an instance of FileParameter.");
        System.exit(-1);
        return null;
    }

    public File[] getFiles(String key) {
        Parameter param = this.getParameter(key);
        if (param instanceof FileListParameter) {
            return ((FileListParameter)param).getFiles();
        }
        System.err.println("[Error] in ParamManager.getFile: " + key + " is not an instance of FileListParameter.");
        System.exit(-1);
        return null;
    }

    public void setMaxNumMods(int numMods) {
        Parameter numModsParam = this.getParameter(ParamNameEnum.MAX_NUM_MODS.getKey());
        numModsParam.parse(String.valueOf(numMods));
    }

    @Deprecated
    public static void main(String[] argv) {
        ParamManager paramManager = new ParamManager("MSGF", "7097", "12/29/2011", "java -Xmx2000M -jar MSGFDB.jar");
        paramManager.addMSGFDBParams();
        String errMessage = paramManager.parseParams(argv);
        if (errMessage == null) {
            paramManager.printValues();
        } else {
            System.out.println();
            System.err.println("[Error] " + errMessage);
            System.out.println();
            paramManager.printUsageInfo();
        }
    }

    public static enum ParamNameEnum {
        CONFIGURATION_FILE("conf", "ConfigurationFile", "Configuration file path; options specified at the command line will override settings in the config file", "Example parameter file is at https://github.com/MSGFPlus/msgfplus/blob/master/docs/examples/MSGFPlus_Params.txt"),
        SPECTRUM_FILE("s", "SpectrumFile", "*.mzML, *.mzXML, *.mgf, *.ms2, *.pkl or *_dta.txt", "Spectra should be centroided (see below for MSConvert example). Profile spectra will be ignored."),
        DB_FILE("d", "DatabaseFile", "*.fasta or *.fa or *.faa", null),
        DECOY_PREFIX("decoy", "DecoyPrefix", "Prefix for decoy protein names; Default: XXX", null),
        MZID_OUTPUT_FILE("o", "OutputFile (*.mzid)", "Default: [SpectrumFileName].mzid", null),
        OUTPUT_FILE("o", "OutputFile", "Default: stdout", null),
        PRECURSOR_MASS_TOLERANCE("t", "PrecursorMassTolerance", "e.g. 2.5Da, 20ppm or 0.5Da,2.5Da; Default: 20ppm", "Use a comma to define asymmetric values. E.g. \"-t 0.5Da,2.5Da\" will set 0.5Da to the left (ObsMass < TheoMass) and 2.5Da to the right (ObsMass > TheoMass)"),
        PRECURSOR_MASS_TOLERANCE_UNITS("u", "PrecursorMassToleranceUnits", "Units for the precursor mass tolerance; only useful if you do not include units in the PrecursorMassTolerance specification", "0 means Ds\n\t   1 means ppm\n\t   2 means use units specified by the PrecursorMassTolerance (Default)"),
        FRAG_METHOD("m", "FragmentationMethodID", "Fragmentation Method", "0 means as written in the spectrum or CID if no info (Default)\n\t   1 means CID\n\t   2 means ETD\n\t   3 means HCD"),
        INSTRUMENT_TYPE("inst", "InstrumentID", null, null),
        ENZYME_ID("e", "EnzymeID", null, null),
        PROTOCOL_ID("protocol", "ProtocolID", null, null),
        MOD_FILE("mod", "ModificationFileName", "Modification file; Default: standard amino acids with fixed C+57; only if -mod is not specified", null),
        NUM_THREADS("thread", "NumThreads", "Number of concurrent threads to be executed; Default: Number of available cores", "This is best set to the number of physical cores in a single NUMA node.\n\t   Generally a single NUMA node is 1 physical processor.\n\t   The default will try to use hyperthreading cores, which can increase the amount of time this process will take.\n\t   This is because the part of Scoring param generation that is multithreaded is also I/O intensive."),
        NUM_TASKS("tasks", "NumTasks", "Override the number of tasks to use on the threads; Default: (internally calculated based on inputs)", "More tasks than threads will reduce the memory requirements of the search, but will be slower (how much depends on the inputs).\n\t   1 <= tasks <= numThreads: will create one task per thread, which is the original behavior.\n\t   tasks = 0: use default calculation - minimum of: (threads*3) and (numSpectra/250).\n\t   tasks < 0: multiply number of threads by abs(tasks) to determine number of tasks (i.e., -2 means \"2 * numThreads\" tasks).\n\t   One task per thread will use the most memory, but will usually finish the fastest.\n\t   2-3 tasks per thread will use comparably less memory, but may cause the search to take 1.5 to 2 times as long."),
        ISOTOPE_ERROR("ti", "IsotopeErrorRange", "Range of allowed isotope peak errors; Default: 0,1", "Takes into account the error introduced by choosing a non-monoisotopic peak for fragmentation.\n\t   The combination of -t and -ti determines the precursor mass tolerance.\n\t   E.g. \"-t 20ppm -ti -1,2\" tests abs(ObservedPepMass - TheoreticalPepMass - n * 1.00335Da) < 20ppm for n = -1, 0, 1, 2."),
        ENZYME_SPECIFICITY("ntt", "NTT", "Number of Tolerable Termini", "E.g. For trypsin, 0: non-tryptic, 1: semi-tryptic, 2: fully-tryptic peptides only."),
        C13("c13", null, "Precursor isotope peak error", "0 means consider only peptides matching precursor mass\n\t   1 means Consider peptides having one 13C (Default)\n\t   2 means Consider peptides having up to two 13C"),
        NNET("nnet", null, "Number of allowed non-enzymatic termini", null),
        MIN_PEPTIDE_LENGTH("minLength", "MinPepLength", "Minimum peptide length to consider; Default: 6", null),
        MAX_PEPTIDE_LENGTH("maxLength", "MaxPepLength", "Maximum peptide length to consider; Default: 40", null),
        MIN_CHARGE("minCharge", "MinCharge", "Minimum precursor charge to consider if charges are not specified in the spectrum file; Default: 2", null),
        MAX_CHARGE("maxCharge", "MaxCharge", "Maximum precursor charge to consider if charges are not specified in the spectrum file; Default: 3", null),
        NUM_MATCHES_SPEC("n", "NumMatchesPerSpec", "Number of matches per spectrum to be reported; Default: 1", null),
        CHARGE_CARRIER_MASSES("ccm", "ChargeCarrierMass", "Mass of charge carrier; Default: mass of proton (1.00727649)", null),
        MIN_NUM_PEAKS("minNumPeaks", "MinNumPeaksPerSpectrum", "Minimum number of peaks per spectrum; Default: 10", null),
        NUM_ISOFORMS("iso", "NumIsoforms", "Number of isoforms to consider per peptide; Default: 128128", null),
        IGNORE_MET_CLEAVAGE("ignoreMetCleavage", "IgnoreMetCleavage", "When 1, ignore N-terminal methionine cleavage", "0 means to consider protein N-term Met cleavage (Default)\n\t   1 means to ignore protein N-term Met cleavage"),
        MIN_DE_NOVO_SCORE("minDeNovoScore", "MinDeNovoScore", "Minimum de Novo score; Default: 0", null),
        SPEC_INDEX("index", "SpecIndex", "Range of spectrum indices to be considered", "For example, to analyze the first 1000 spectra use -index 1,1000"),
        MAX_MISSED_CLEAVAGES("maxMissedCleavages", "MaxMissedCleavages", "Exclude peptides with more than this number of missed cleavages from the search; Default: -1 (no limit)", null),
        TDA_STRATEGY("tda", "TDA", "Target decoy strategy", "0 means Don't search decoy database (Default)\n\t   1 means search the decoy database (forward + reverse proteins)"),
        ADD_FEATURES("addFeatures", "AddFeatures", "Include additional features in the output (enable this to post-process results with Percolator)", "0 means Output basic scores only (Default)\n\t   1 means Output additional features"),
        ALLOW_DENSE_CENTROIDED_PEAKS("allowDenseCentroidedPeaks", "AllowDenseCentroidedPeaks", "Allow centroid scans with dense peaks (Default: 0)\n\t   (for mzML or mzXML files, the console output will tell you if you might want to use this)", null),
        DD_DIRECTORY("dd", "DBIndexDir", "Path to the directory containing database index files", null),
        EDGE_SCORE("edgeScore", "EdgeScore", "Toggle edge scoring", "0 means Use Edge Scoring (Default)\n\t   1 means Do not use edge scoring"),
        UNIFORM_AA_PROBABILITY("uniformAAProb", "UniformAAProb", null, null),
        MAX_NUM_MODS("numMods", "NumMods", "Maximum number of dynamic (variable) modifications per peptide; Default: 3", null),
        STATIC_MODIFICATION("staticMod", "StaticMod", "Static/Fixed modification", null),
        DYNAMIC_MODIFICATION("dynamicMod", "DynamicMod", "Dynamic/Variable modification", null),
        CUSTOM_AA("customAA", "CustomAA", "Custom amino acid", null),
        VERBOSE("verbose", null, "Console output message verbosity", "0 means Report total progress only\n\t   1 means Report total and per-thread progress/status");

        private String key;
        private String name;
        private String description;
        private String additionalDescription;

        private ParamNameEnum(String key, String name, String description, String additionalDescription) {
            this.key = key;
            this.name = name;
            this.description = description;
            this.additionalDescription = additionalDescription;
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getAdditionalDescription() {
            return this.additionalDescription;
        }

        public boolean isThisParam(String paramName) {
            return this.getName() != null && paramName.equalsIgnoreCase(this.getName());
        }

        public static String getParamNameFromLine(String lineSetting) {
            String[] lineParts = lineSetting.split("=");
            if (lineParts.length < 2) {
                return "";
            }
            String paramName = lineParts[0].trim();
            if (paramName.equalsIgnoreCase("IsotopeError")) {
                paramName = "IsotopeErrorRange";
            } else if (paramName.equalsIgnoreCase("TargetDecoyAnalysis")) {
                paramName = "TDA";
            } else if (paramName.equalsIgnoreCase("FragmentationMethod")) {
                paramName = "FragmentationMethodID";
            } else if (paramName.equalsIgnoreCase("Instrument")) {
                paramName = "InstrumentID";
            } else if (paramName.equalsIgnoreCase("Enzyme")) {
                paramName = "EnzymeID";
            } else if (paramName.equalsIgnoreCase("Protocol")) {
                paramName = "ProtocolID";
            } else if (paramName.equalsIgnoreCase("NumTolerableTermini")) {
                paramName = "NTT";
            } else if (paramName.equalsIgnoreCase("MinNumPeaks")) {
                paramName = "MinNumPeaksPerSpectrum";
            } else if (paramName.equalsIgnoreCase("MaxNumMods") || paramName.equalsIgnoreCase("MaxNumModsPerPeptide")) {
                paramName = "NumMods";
            } else if (paramName.equalsIgnoreCase("minLength") || paramName.equalsIgnoreCase("MinPeptideLength")) {
                paramName = "MinPepLength";
            } else if (paramName.equalsIgnoreCase("maxLength") || paramName.equalsIgnoreCase("MaxPeptideLength")) {
                paramName = "MaxPepLength";
            } else if (paramName.equalsIgnoreCase("PMTolerance") || paramName.equalsIgnoreCase("ParentMassTolerance")) {
                paramName = "PrecursorMassTolerance";
            }
            return paramName;
        }
    }
}

