/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.params;

import edu.ucsd.msjava.params.Parameter;

public abstract class RangeParameter<T extends Comparable<T>>
extends Parameter {
    protected T min = null;
    protected T max = null;
    protected T minValue;
    protected T maxValue;
    protected boolean isMinInclusive = true;
    protected boolean isMaxInclusive = false;

    public RangeParameter(String key, String name, String description) {
        super(key, name, description);
    }

    public RangeParameter<T> minValue(T minValue) {
        this.minValue = minValue;
        return this;
    }

    public RangeParameter<T> maxValue(T maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    public RangeParameter<T> setMinExclusive() {
        this.isMinInclusive = false;
        return this;
    }

    public RangeParameter<T> setMaxInclusive() {
        this.isMaxInclusive = true;
        return this;
    }

    public boolean isValueValid(T value) {
        return !(value.compareTo(this.minValue) < 0 || value.compareTo(this.maxValue) > 0 || !this.isMinInclusive && value.equals(this.minValue) || !this.isMaxInclusive && value.equals(this.maxValue));
    }

    public RangeParameter<T> defaultValue(String value) {
        super.setOptional();
        String error = this.parse(value);
        if (error != null) {
            System.err.println("(RangeParameter) Error while parsing the default value: " + error);
            System.exit(-1);
        }
        return this;
    }

    @Override
    public abstract String parse(String var1);

    @Override
    public String getValueAsString() {
        return this.min + "," + this.max;
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }
}

