/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.parser;

import edu.ucsd.msjava.msutil.Composition;
import edu.ucsd.msjava.msutil.Peak;
import edu.ucsd.msjava.msutil.SpectraIterator;
import edu.ucsd.msjava.msutil.SpectraMap;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.msutil.SpectrumMetaInfo;
import edu.ucsd.msjava.parser.BufferedRandomAccessLineReader;
import edu.ucsd.msjava.parser.LineReader;
import edu.ucsd.msjava.parser.SpectrumParser;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class MS2SpectrumParser
implements SpectrumParser {
    private Spectrum spec = null;
    private Boolean isSpecSorted = null;

    @Override
    public long getScanMissingWarningCount() {
        return 0L;
    }

    @Override
    public Spectrum readSpectrum(LineReader lineReader) {
        String buf;
        float prevMass = 0.0f;
        while ((buf = lineReader.readLine()) != null && buf.startsWith("H")) {
        }
        if (buf == null) {
            return null;
        }
        if (buf.startsWith("S")) {
            String[] token = buf.split("\\s+");
            this.spec = new Spectrum();
            int startScanNum = Integer.parseInt(token[1]);
            int endScanNum = Integer.parseInt(token[2]);
            float precursorMz = Float.parseFloat(token[3]);
            this.spec = new Spectrum(precursorMz, 0, 0.0f);
            this.spec.setStartScanNum(startScanNum);
            this.spec.setEndScanNum(endScanNum);
            this.isSpecSorted = true;
        } else if (this.spec == null) {
            return null;
        }
        boolean zParsed = false;
        while ((buf = lineReader.readLine()) != null) {
            String[] token = buf.split("\\s+");
            if (buf.startsWith("H")) continue;
            if (buf.startsWith("S")) {
                Spectrum specCopy = this.spec;
                Boolean isSpecSortedCopy = this.isSpecSorted;
                this.spec = new Spectrum();
                int startScanNum = Integer.parseInt(token[1]);
                int endScanNum = Integer.parseInt(token[2]);
                float precursorMz = Float.parseFloat(token[3]);
                this.spec = new Spectrum(precursorMz, 0, 0.0f);
                this.spec.setStartScanNum(startScanNum);
                this.spec.setEndScanNum(endScanNum);
                this.isSpecSorted = true;
                if (!isSpecSortedCopy.booleanValue()) {
                    Collections.sort(specCopy);
                }
                return specCopy;
            }
            if (buf.startsWith("Z")) {
                if (!zParsed) {
                    int charge = Integer.parseInt(token[1]);
                    float precursorMH = Float.parseFloat(token[2]);
                    float precursorMz = (precursorMH - (float)Composition.ChargeCarrierMass() + (float)charge * (float)Composition.ChargeCarrierMass()) / (float)charge;
                    this.spec.setPrecursor(new Peak(precursorMz, 0.0f, charge));
                    zParsed = true;
                    continue;
                }
                this.spec.setPrecursorCharge(0);
                continue;
            }
            if (token.length != 2) continue;
            assert (this.spec != null);
            float mass = Float.parseFloat(token[0]);
            if (this.isSpecSorted.booleanValue() && mass < prevMass) {
                this.isSpecSorted = false;
            } else {
                prevMass = mass;
            }
            float intensity = Float.parseFloat(token[1]);
            this.spec.add(new Peak(mass, intensity, 1));
        }
        if (this.spec != null) {
            if (!this.isSpecSorted.booleanValue()) {
                Collections.sort(this.spec);
            }
            Spectrum specCopy = this.spec;
            this.spec = null;
            return specCopy;
        }
        return this.spec;
    }

    @Override
    public Map<Integer, SpectrumMetaInfo> getSpecMetaInfoMap(BufferedRandomAccessLineReader lineReader) {
        String buf;
        Hashtable<Integer, SpectrumMetaInfo> specIndexMap = new Hashtable<Integer, SpectrumMetaInfo>();
        long offset = 0L;
        int specIndex = 0;
        SpectrumMetaInfo metaInfo = null;
        while ((buf = lineReader.readLine()) != null) {
            if (buf.startsWith("S")) {
                metaInfo = new SpectrumMetaInfo();
                metaInfo.setPosition(offset);
                metaInfo.setID("index=" + (++specIndex - 1));
                String[] token = buf.split("\\s+");
                if (token.length < 4) {
                    System.err.println("Invalid ms2 file format!");
                    System.exit(-1);
                }
                float precursorMz = Float.parseFloat(token[3]);
                metaInfo.setPrecursorMz(precursorMz);
                specIndexMap.put(specIndex, metaInfo);
            }
            offset = lineReader.getPosition();
        }
        return specIndexMap;
    }

    public static void test() throws Exception {
        String fileName = System.getProperty("user.home") + "/Research/Data/QCShew/QC_Shew_12_02_2_1Aug12_Cougar_12-06-11.ms2";
        HashMap<Integer, Float> specIndexPrecursorMzMap = new HashMap<Integer, Float>();
        int numSpecs = 0;
        SpectraMap map = new SpectraMap(fileName, new MS2SpectrumParser());
        for (int specIndex : map.getSpecIndexList()) {
            Spectrum spec = map.getSpectrumBySpecIndex(specIndex);
            ++numSpecs;
            specIndexPrecursorMzMap.put(spec.getSpecIndex(), Float.valueOf(spec.getPrecursorPeak().getMz()));
        }
        System.out.println("NumSpectra: " + numSpecs);
        numSpecs = 0;
        SpectraIterator iterator = new SpectraIterator(fileName, (SpectrumParser)new MS2SpectrumParser());
        while (iterator.hasNext()) {
            Spectrum spec = iterator.next();
            ++numSpecs;
            Float precursorMz = (Float)specIndexPrecursorMzMap.get(spec.getSpecIndex());
            if (precursorMz != null && precursorMz.floatValue() == spec.getPrecursorPeak().getMz()) continue;
            System.out.println(precursorMz + " != " + spec.getPrecursorPeak().getMz());
            System.exit(0);
        }
        System.out.println("NumSpectra: " + numSpecs);
    }

    public static void main(String[] argv) throws Exception {
        MS2SpectrumParser.test();
    }
}

