/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.parser;

import edu.ucsd.msjava.msutil.AminoAcid;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.parser.PSM;
import java.util.ArrayList;

public class MSGappedDictionaryPSM
extends PSM {
    private AminoAcid precedingAA;
    private AminoAcid succeedingAA;
    private AminoAcidSet aaSet;
    private float parentMassError;

    public MSGappedDictionaryPSM aaSet(AminoAcidSet aaSet) {
        this.aaSet = aaSet;
        return this;
    }

    public MSGappedDictionaryPSM peptide(String peptideStr) {
        ArrayList<AminoAcid> aaList = new ArrayList<AminoAcid>();
        for (int i = 0; i < peptideStr.length(); ++i) {
            aaList.add(this.aaSet.getAminoAcid(peptideStr.charAt(i)));
        }
        this.peptide(new Peptide(aaList));
        return this;
    }

    public boolean isPeptideModified() {
        for (int i = 0; i < this.getPeptideStr().length(); ++i) {
            if (!Character.isLowerCase(this.getPeptideStr().charAt(i))) continue;
            return true;
        }
        return false;
    }

    public AminoAcid getPrecedingAA() {
        return this.precedingAA;
    }

    public AminoAcid getSucceedingAA() {
        return this.succeedingAA;
    }

    public AminoAcidSet getAASet() {
        return this.aaSet;
    }

    public float getParentMassError() {
        return this.parentMassError;
    }

    public void setPrecedingAA(AminoAcid precedingAA) {
        this.precedingAA = precedingAA;
    }

    public void setSucceedingAA(AminoAcid succeedingAA) {
        this.succeedingAA = succeedingAA;
    }

    public void setParentMassError(float error) {
        this.parentMassError = error;
    }
}

