/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.parser;

import edu.ucsd.msjava.misc.TextParsingUtils;
import edu.ucsd.msjava.msutil.ActivationMethod;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Peak;
import edu.ucsd.msjava.msutil.Peptide;
import edu.ucsd.msjava.msutil.SpectraIterator;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.msutil.SpectrumMetaInfo;
import edu.ucsd.msjava.parser.BufferedRandomAccessLineReader;
import edu.ucsd.msjava.parser.LineReader;
import edu.ucsd.msjava.parser.SpectrumParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;

public class MgfSpectrumParser
implements SpectrumParser {
    private long linesRead;
    private long negativePolarityWarningCount;
    private long scanMissingWarningCount;
    private AminoAcidSet aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();

    @Override
    public long getScanMissingWarningCount() {
        return this.scanMissingWarningCount;
    }

    public MgfSpectrumParser aaSet(AminoAcidSet aaSet) {
        this.aaSet = aaSet;
        this.linesRead = 0L;
        this.negativePolarityWarningCount = 0L;
        this.scanMissingWarningCount = 0L;
        return this;
    }

    @Override
    public Spectrum readSpectrum(LineReader lineReader) {
        String buf;
        String dataLine;
        Spectrum spec = null;
        String title = null;
        float precursorMz = 0.0f;
        float precursorIntensity = 0.0f;
        int precursorCharge = 0;
        ActivationMethod activation = null;
        float elutionTimeSeconds = 0.0f;
        boolean parse = false;
        boolean sorted = true;
        float prevMass = 0.0f;
        while ((dataLine = (buf = lineReader.readLine())) != null) {
            String[] token;
            if (this.linesRead == 0L) {
                buf = BufferedRandomAccessLineReader.stripBOM(buf);
            }
            ++this.linesRead;
            if (buf.length() == 0) continue;
            if (buf.startsWith("BEGIN IONS")) {
                parse = true;
                spec = new Spectrum();
                continue;
            }
            if (!parse) continue;
            if (Character.isDigit(buf.charAt(0))) {
                assert (spec != null);
                token = buf.split("\\s+");
                if (token.length < 2) continue;
                float mass = Float.parseFloat(token[0]);
                if (sorted && mass < prevMass) {
                    sorted = false;
                } else {
                    prevMass = mass;
                }
                float intensity = Float.parseFloat(token[1]);
                spec.add(new Peak(mass, intensity, 1));
                continue;
            }
            if (buf.startsWith("TITLE")) {
                title = buf.substring(buf.indexOf(61) + 1);
                spec.setTitle(title);
                continue;
            }
            if (buf.startsWith("CHARGE")) {
                String chargeStr = buf.substring(buf.indexOf("=") + 1).trim();
                String[] chargeStrToken = chargeStr.split("\\s+");
                if (chargeStrToken.length != 1) continue;
                String[] multipleChargeToken = chargeStr.split(",");
                if (chargeStr.length() <= 0 || multipleChargeToken.length != 1) continue;
                if (chargeStr.startsWith("+")) {
                    chargeStr = chargeStr.substring(1);
                } else if (chargeStr.charAt(chargeStr.length() - 1) == '+') {
                    chargeStr = chargeStr.substring(0, chargeStr.length() - 1);
                } else if (chargeStr.startsWith("-")) {
                    this.warnNegativePolarity(buf);
                    chargeStr = chargeStr.substring(1);
                    spec.setScanPolarity(Spectrum.Polarity.NEGATIVE);
                } else if (chargeStr.charAt(chargeStr.length() - 1) == '-') {
                    this.warnNegativePolarity(buf);
                    chargeStr = chargeStr.substring(0, chargeStr.length() - 1);
                    spec.setScanPolarity(Spectrum.Polarity.NEGATIVE);
                }
                precursorCharge = Integer.valueOf(chargeStr);
                continue;
            }
            if (buf.startsWith("SEQ")) {
                String annotationStr = buf.substring(buf.lastIndexOf(61) + 1);
                if (spec.getAnnotation() == null) {
                    spec.setAnnotation(new Peptide(annotationStr, this.aaSet));
                }
                spec.addSEQ(annotationStr);
                continue;
            }
            if (buf.startsWith("PEPMASS")) {
                token = buf.substring(buf.indexOf("=") + 1).split("\\s+");
                precursorMz = Float.valueOf(token[0]).floatValue();
                continue;
            }
            if (buf.startsWith("SCANS")) {
                if (buf.matches(".+=\\d+-\\d+")) {
                    int startScanNum = Integer.parseInt(buf.substring(buf.indexOf(61) + 1, buf.lastIndexOf(45)));
                    int endScanNum = Integer.parseInt(buf.substring(buf.lastIndexOf(45) + 1));
                    spec.setStartScanNum(startScanNum);
                    spec.setEndScanNum(endScanNum);
                    continue;
                }
                try {
                    int scanNum = Integer.valueOf(buf.substring(buf.indexOf("=") + 1));
                    spec.setScanNum(scanNum);
                }
                catch (NumberFormatException scanNum) {}
                continue;
            }
            if (buf.startsWith("ACTIVATION")) {
                String activationName = buf.substring(buf.indexOf("=") + 1);
                activation = ActivationMethod.get(activationName);
                spec.setActivationMethod(activation);
                continue;
            }
            if (buf.startsWith("RTINSECONDS")) {
                token = buf.substring(buf.indexOf("=") + 1).split("\\s+");
                int dashIndex = token[0].indexOf("-");
                if (dashIndex > 0) {
                    elutionTimeSeconds = Float.valueOf(token[0].substring(0, dashIndex)).floatValue();
                    continue;
                }
                elutionTimeSeconds = Float.valueOf(token[0]).floatValue();
                continue;
            }
            if (!buf.startsWith("END IONS")) continue;
            assert (spec != null);
            if (spec.getScanNum() < 0 && title != null) {
                if (title.matches("Scan:\\d+\\s.+")) {
                    token = title.split("\\s++");
                    int scanNum = Integer.parseInt(token[0].substring("Scan:".length()));
                    spec.setScanNum(scanNum);
                } else if (title.matches(".+\\.\\d+\\.\\d+\\.\\d+$") || title.matches(".+\\.\\d+\\.\\d+\\.$")) {
                    this.extractScanRangeFromTitle(spec, title);
                } else if (title.contains(".") && title.contains(" ")) {
                    String titleStart = title.substring(0, title.indexOf(32));
                    this.extractScanRangeFromTitle(spec, titleStart);
                } else {
                    this.warnScanNotFoundInTitle(title);
                }
            }
            spec.setPrecursor(new Peak(precursorMz, precursorIntensity, precursorCharge));
            if (elutionTimeSeconds > 0.0f) {
                spec.setRt(elutionTimeSeconds);
                spec.setRtIsSeconds(true);
            }
            if (!sorted) {
                Collections.sort(spec);
            }
            return spec;
        }
        return null;
    }

    private void extractScanRangeFromTitle(Spectrum spec, String title) {
        String candidateEndScan;
        String candidateStartScan;
        String[] token = title.split("\\.");
        if (token.length > 3) {
            candidateStartScan = token[token.length - 3];
            candidateEndScan = token[token.length - 2];
        } else if (token.length == 3 && title.endsWith(".")) {
            candidateStartScan = token[token.length - 2];
            candidateEndScan = token[token.length - 1];
        } else {
            this.warnScanNotFoundInTitle(title);
            return;
        }
        boolean success = false;
        if (TextParsingUtils.isInteger(candidateStartScan)) {
            int startScanNum = Integer.parseInt(candidateStartScan);
            spec.setStartScanNum(startScanNum);
            success = true;
        }
        if (TextParsingUtils.isInteger(candidateEndScan)) {
            int endScanNum = Integer.parseInt(candidateEndScan);
            spec.setEndScanNum(endScanNum);
        }
        if (!success) {
            this.warnScanNotFoundInTitle(title);
        }
    }

    @Override
    public Map<Integer, SpectrumMetaInfo> getSpecMetaInfoMap(BufferedRandomAccessLineReader lineReader) {
        String buf;
        String dataLine;
        Hashtable<Integer, SpectrumMetaInfo> specIndexMap = new Hashtable<Integer, SpectrumMetaInfo>();
        long offset = 0L;
        int specIndex = 0;
        SpectrumMetaInfo metaInfo = null;
        while ((dataLine = (buf = lineReader.readLine())) != null) {
            if (offset == 0L && lineReader.getBOMLength() > 0) {
                offset += (long)lineReader.getBOMLength();
            }
            if (buf.startsWith("BEGIN IONS")) {
                metaInfo = new SpectrumMetaInfo();
                metaInfo.setPosition(offset);
                metaInfo.setID("index=" + String.valueOf(++specIndex - 1));
                specIndexMap.put(specIndex, metaInfo);
            } else if (buf.startsWith("TITLE")) {
                String title = buf.substring(buf.indexOf(61) + 1);
                metaInfo.setAdditionalInfo("title", title);
            } else if (buf.startsWith("PEPMASS")) {
                String[] token = buf.substring(buf.indexOf("=") + 1).split("\\s+");
                float precursorMz = Float.valueOf(token[0]).floatValue();
                metaInfo.setPrecursorMz(precursorMz);
            }
            offset = lineReader.getPosition();
        }
        return specIndexMap;
    }

    private void warnNegativePolarity(String currentLine) {
        ++this.negativePolarityWarningCount;
        if (this.negativePolarityWarningCount > 10L) {
            return;
        }
        if (this.negativePolarityWarningCount == 1L) {
            System.out.println("Warning: negative precursor charge found, indicating a negative polarity spectrum; you likely need to use a negative charge carrier");
        }
        System.out.println("Negative charge found on line " + Long.toString(this.linesRead) + ": " + currentLine);
        if (this.negativePolarityWarningCount == 10L) {
            System.out.println("Additional warnings regarding negative polarity will not be shown");
        }
    }

    void warnScanNotFoundInTitle(String title) {
        ++this.scanMissingWarningCount;
        if (this.scanMissingWarningCount <= 10L) {
            System.out.println("Unable to extract the scan number from the title: " + title);
            if (this.scanMissingWarningCount == 1L) {
                System.out.println("Expected format is DatasetName.ScanStart.ScanEnd.Charge");
            }
        }
    }

    public static void main(String[] argv) throws Exception {
        long time = System.currentTimeMillis();
        String mgfFile = "/Users/sangtaekim/Research/Data/PNNL/IPYS_TD_Scere010_Orbitrap_001a.mgf";
        ArrayList<Spectrum> specContainer = new ArrayList<Spectrum>();
        SpectraIterator iterator = new SpectraIterator(mgfFile, (SpectrumParser)new MgfSpectrumParser());
        while (iterator.hasNext()) {
            specContainer.add(iterator.next());
        }
        System.out.println("Time: " + (System.currentTimeMillis() - time));
    }
}

