/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.parser;

import edu.ucsd.msjava.msutil.ActivationMethod;
import edu.ucsd.msjava.msutil.Peak;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.msutil.SpectrumAccessorBySpecIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.systemsbiology.jrap.stax.MSXMLParser;
import org.systemsbiology.jrap.stax.Scan;
import org.systemsbiology.jrap.stax.ScanHeader;

public class MzXMLSpectraMap
implements SpectrumAccessorBySpecIndex {
    private MSXMLParser parser;
    private static Pattern rtPattern = Pattern.compile("\\D*(\\d+\\.\\d*|\\d*\\.\\d+|\\d+)(m|M|s|S)?");
    private int minMSLevel = 2;
    private int maxMSLevel = Integer.MAX_VALUE;
    private ArrayList<Integer> specIndexList = null;

    public MzXMLSpectraMap(String fileName) {
        this.parser = new MSXMLParser(fileName);
    }

    public MzXMLSpectraMap msLevel(int minMSLevel, int maxMSLevel) {
        this.minMSLevel = minMSLevel;
        this.maxMSLevel = maxMSLevel;
        return this;
    }

    public Spectrum getSpectrumByScanNum(int scanNumber) {
        Matcher matcher;
        Scan scanObj = this.parser.rap(scanNumber);
        if (scanObj == null) {
            return null;
        }
        int msLevel = scanObj.getHeader().getMsLevel();
        if (msLevel < this.minMSLevel || msLevel >= this.maxMSLevel) {
            return null;
        }
        double[][] peakList = scanObj.getMassIntensityList();
        ScanHeader header = scanObj.getHeader();
        int precursorCharge = header.getPrecursorCharge();
        precursorCharge = precursorCharge < 0 ? 0 : precursorCharge;
        Spectrum spec = new Spectrum(header.getPrecursorMz(), precursorCharge, header.getPrecursorIntensity());
        int scanNum = header.getNum();
        spec.setScanNum(scanNum);
        spec.setID("scan=" + String.valueOf(scanNum));
        spec.setSpecIndex(header.getNum());
        int centroided = header.getCentroided();
        if (centroided != 0) {
            spec.setIsCentroided(true);
        } else {
            spec.setIsCentroided(false);
        }
        String rtStr = header.getRetentionTime();
        if (rtStr != null && (matcher = rtPattern.matcher(rtStr)).find() && matcher.groupCount() > 0) {
            String timeScale;
            float rtFloat = Float.parseFloat(rtStr.substring(matcher.start(1), matcher.end(1)));
            if (matcher.groupCount() > 1 && ((timeScale = rtStr.substring(matcher.start(2), matcher.end(2))).equals("M") || timeScale.equals("m"))) {
                spec.setRtIsSeconds(false);
            }
            spec.setRt(rtFloat);
        }
        spec.setMsLevel(header.getMsLevel());
        String activationName = header.getActivationMethod();
        if (activationName != null) {
            ActivationMethod method = ActivationMethod.get(activationName);
            if (method == null) {
                method = ActivationMethod.register(activationName, activationName);
            }
            spec.setActivationMethod(method);
        }
        boolean sorted = true;
        float prevMass = 0.0f;
        for (int j = 0; j < peakList[0].length; ++j) {
            float mass = (float)peakList[0][j];
            float intensity = (float)peakList[1][j];
            spec.add(new Peak(mass, intensity, 1));
            if (sorted && mass < prevMass) {
                sorted = false;
                continue;
            }
            prevMass = mass;
        }
        if (!sorted) {
            Collections.sort(spec);
        }
        spec.determineIsCentroided();
        return spec;
    }

    @Override
    public Spectrum getSpectrumBySpecIndex(int specIndex) {
        return this.getSpectrumByScanNum(specIndex);
    }

    public int getMaxScanNumber() {
        return this.parser.getMaxScanNumber();
    }

    @Override
    public ArrayList<Integer> getSpecIndexList() {
        if (this.specIndexList == null) {
            this.specIndexList = new ArrayList();
            for (int scanNumber = 1; scanNumber <= this.parser.getMaxScanNumber(); ++scanNumber) {
                Scan scanObj = this.parser.rap(scanNumber);
                int msLevel = scanObj.getHeader().getMsLevel();
                if (scanObj == null || scanObj.getHeader() == null || msLevel < this.minMSLevel || msLevel >= this.maxMSLevel) continue;
                this.specIndexList.add(scanNumber);
            }
        }
        return this.specIndexList;
    }

    @Override
    public String getID(int specIndex) {
        Scan scanObj = this.parser.rap(specIndex);
        if (scanObj == null) {
            return null;
        }
        int msLevel = scanObj.getHeader().getMsLevel();
        if (msLevel < this.minMSLevel || msLevel >= this.maxMSLevel) {
            return null;
        }
        return String.valueOf(specIndex);
    }

    @Override
    public Spectrum getSpectrumById(String specId) {
        if (!specId.matches("scan=\\d+")) {
            return null;
        }
        int scanNum = Integer.parseInt(specId.substring(specId.lastIndexOf(61) + 1));
        return this.getSpectrumByScanNum(scanNum);
    }

    @Override
    public Float getPrecursorMz(int specIndex) {
        Scan scanObj = this.parser.rap(specIndex);
        if (scanObj == null) {
            return null;
        }
        int msLevel = scanObj.getHeader().getMsLevel();
        if (msLevel < this.minMSLevel || msLevel >= this.maxMSLevel) {
            return null;
        }
        ScanHeader header = scanObj.getHeader();
        float precursorMz = header.getPrecursorMz();
        return Float.valueOf(precursorMz);
    }

    @Override
    public String getTitle(int specIndex) {
        return null;
    }
}

