/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.scripts;

import edu.ucsd.msjava.msutil.SpectraIterator;
import edu.ucsd.msjava.parser.MS2SpectrumParser;
import edu.ucsd.msjava.parser.MzXMLSpectraIterator;
import edu.ucsd.msjava.parser.SpectrumParser;
import java.io.File;
import java.io.IOException;

public class CountSpectra {
    public static int countMS2(String path) {
        File fObj = new File(path);
        if (fObj.isDirectory()) {
            String[] files;
            int count = 0;
            for (String file : files = fObj.list()) {
                if (!file.endsWith(".ms2")) continue;
                count += CountSpectra.countMS2file(path + "/" + file);
            }
            return count;
        }
        return CountSpectra.countMS2file(path);
    }

    private static int countMS2file(String file) {
        try {
            int count = 0;
            SpectraIterator it = new SpectraIterator(file, (SpectrumParser)new MS2SpectrumParser());
            while (it.hasNext()) {
                it.next();
                ++count;
            }
            return count;
        }
        catch (IOException ioe) {
            System.err.println(ioe);
            System.exit(-1);
            return 0;
        }
    }

    public static int countMZXML(String path) {
        File fObj = new File(path);
        if (fObj.isDirectory()) {
            String[] files;
            int count = 0;
            for (String file : files = fObj.list()) {
                if (!file.endsWith(".mzXML")) continue;
                count += CountSpectra.countMZXMLfile(path + "/" + file);
            }
            return count;
        }
        return CountSpectra.countMS2file(path);
    }

    private static int countMZXMLfile(String file) {
        int count = 0;
        MzXMLSpectraIterator it = new MzXMLSpectraIterator(file);
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    public static void main(String[] args) {
        String userHome = System.getProperty("user.home");
        String dir = String.format("%s/Data/Spectra/Hsapiens/Heck/mzXML/tryp", userHome);
        int count = CountSpectra.countMZXML(dir);
        System.out.println("Number of spectra: " + count);
    }
}

