/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.ui;

import edu.ucsd.msjava.msdbsearch.DBScanner;
import edu.ucsd.msjava.msgf.DeNovoGraph;
import edu.ucsd.msjava.msgf.FlexAminoAcidGraph;
import edu.ucsd.msjava.msgf.GeneratingFunction;
import edu.ucsd.msjava.msgf.NominalMass;
import edu.ucsd.msjava.msscorer.NewRankScorer;
import edu.ucsd.msjava.msscorer.NewScoredSpectrum;
import edu.ucsd.msjava.msscorer.NewScorerFactory;
import edu.ucsd.msjava.msutil.ActivationMethod;
import edu.ucsd.msjava.msutil.AminoAcidSet;
import edu.ucsd.msjava.msutil.Enzyme;
import edu.ucsd.msjava.msutil.InstrumentType;
import edu.ucsd.msjava.msutil.Protocol;
import edu.ucsd.msjava.msutil.SpectraMap;
import edu.ucsd.msjava.msutil.Spectrum;
import edu.ucsd.msjava.msutil.SpectrumAccessorBySpecIndex;
import edu.ucsd.msjava.params.ParamManager;
import edu.ucsd.msjava.parser.InsPecTPSM;
import edu.ucsd.msjava.parser.InsPecTParser;
import edu.ucsd.msjava.parser.MS2SpectrumParser;
import edu.ucsd.msjava.parser.MgfSpectrumParser;
import edu.ucsd.msjava.parser.MzXMLSpectraMap;
import edu.ucsd.msjava.parser.PNNLSpectrumParser;
import edu.ucsd.msjava.parser.PSMList;
import edu.ucsd.msjava.parser.PklSpectrumParser;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Hashtable;

public class MSGF {
    public static final String VERSION = "7097";
    public static final String RELEASE_DATE = "12/29/2011";

    public static void main(String[] argv) {
        long time = System.currentTimeMillis();
        ParamManager paramManager = new ParamManager("MSGF", VERSION, RELEASE_DATE, "java -Xmx2000M -cp MSGFDB.jar ui.MSGF");
        paramManager.addMSGFParams();
        if (argv.length == 0) {
            paramManager.printUsageInfo();
            return;
        }
        String errMessage = paramManager.parseParams(argv);
        if (errMessage != null) {
            System.err.println("[Error] " + errMessage);
            System.out.println();
            paramManager.printUsageInfo();
            return;
        }
        paramManager.printToolInfo();
        String errorMessage = MSGF.runMSGF(paramManager);
        if (errorMessage != null) {
            System.err.println("[Error] " + errorMessage);
            System.out.println();
        } else {
            System.out.format("MS-GF complete (total elapsed time: %.2f sec)\n", Float.valueOf((float)(System.currentTimeMillis() - time) / 1000.0f));
        }
    }

    public static String runMSGF(ParamManager paramManager) {
        boolean onePerSpec;
        File outputFile = paramManager.getFile("o");
        PrintStream out = null;
        if (outputFile == null) {
            out = System.out;
        } else {
            try {
                out = new PrintStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        AminoAcidSet aaSet = null;
        int fixModID = paramManager.getIntValue("fixMod");
        if (fixModID == 0) {
            aaSet = AminoAcidSet.getStandardAminoAcidSet();
        } else if (fixModID == 1) {
            aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarbamidomethylatedCys();
        } else if (fixModID == 2) {
            aaSet = AminoAcidSet.getStandardAminoAcidSetWithFixedCarboxymethylatedCys();
        }
        File databaseFile = paramManager.getFile("db");
        if (databaseFile != null) {
            DBScanner.setAminoAcidProbabilities(databaseFile.getPath(), aaSet);
        }
        File resultFile = paramManager.getFile("i");
        InsPecTParser parser = new InsPecTParser(aaSet);
        parser.parse(resultFile.getPath());
        boolean addMSGFColumn = paramManager.getIntValue("addScore") == 1;
        String header = parser.getHeader();
        if (header != null) {
            out.print(header + "\tSpecProb");
            if (addMSGFColumn) {
                out.print("\tMSGFScore\tDeNovoScore");
            }
            out.println();
        }
        ArrayList<String> keyList = null;
        Hashtable<String, Double> minSpecProb = null;
        Hashtable<String, String> bestOut = null;
        boolean bl = onePerSpec = paramManager.getIntValue("x") == 1;
        if (onePerSpec) {
            minSpecProb = new Hashtable<String, Double>();
            bestOut = new Hashtable<String, String>();
            keyList = new ArrayList<String>();
        }
        float specProbThreshold = paramManager.getFloatValue("p");
        PSMList<InsPecTPSM> psmList = parser.getPSMList();
        if (psmList == null) {
            out.close();
            return "The result file is empty!";
        }
        SpectrumAccessorBySpecIndex specAccessor = null;
        String prevFileName = "";
        int prevScanNum = -1;
        Spectrum spec = null;
        File specDir = paramManager.getFile("d");
        ActivationMethod activationMethod = paramManager.getActivationMethod();
        InstrumentType instType = paramManager.getInstType();
        if (activationMethod == ActivationMethod.HCD) {
            instType = InstrumentType.HIGH_RESOLUTION_LTQ;
        }
        Enzyme enzyme = paramManager.getEnzyme();
        NewRankScorer scorer = null;
        if (activationMethod != ActivationMethod.ASWRITTEN) {
            scorer = NewScorerFactory.get(activationMethod, instType, enzyme, Protocol.AUTOMATIC);
        }
        for (InsPecTPSM psm : psmList) {
            if (psm.getPeptide() == null) {
                out.print(psm.getInsPecTString() + "\tN/A: unrecognizable annotation");
                if (addMSGFColumn) {
                    out.print("\t\t");
                }
                out.println();
                continue;
            }
            String fileName = psm.getSpecFileName();
            if (fileName.equalsIgnoreCase(prevFileName) && specAccessor != null) {
                assert (specAccessor != null);
                if (psm.getScanNum() == prevScanNum) {
                    assert (spec != null);
                } else {
                    prevScanNum = psm.getScanNum();
                    spec = specAccessor.getSpectrumBySpecIndex(prevScanNum);
                    prevScanNum = psm.getScanNum();
                    if (onePerSpec) {
                        keyList.add(psm.getSpecFileName() + ":" + psm.getScanNum());
                    }
                }
            } else {
                prevFileName = fileName;
                String filePrefix = fileName.substring(0, fileName.lastIndexOf(46));
                String ext = fileName.substring(fileName.lastIndexOf(46));
                String specFilePath = Paths.get(specDir.getPath(), fileName).toString();
                if (ext.equalsIgnoreCase(".mzxml")) {
                    File specFile = new File(specFilePath);
                    if (!specFile.exists()) {
                        for (File f : specDir.listFiles()) {
                            if (!f.getName().startsWith(filePrefix) || !f.getName().substring(f.getName().lastIndexOf(46)).equalsIgnoreCase(".mzxml")) continue;
                            specFile = f;
                        }
                        if (!specFile.exists()) {
                            out.print(psm.getInsPecTString() + "\tN/A: spectrum file is missing");
                            if (addMSGFColumn) {
                                out.print("\t\t");
                            }
                            out.println();
                            continue;
                        }
                    }
                    specAccessor = new MzXMLSpectraMap(specFile.getPath());
                } else if (ext.equalsIgnoreCase(".mgf")) {
                    specAccessor = new SpectraMap(specFilePath, new MgfSpectrumParser());
                } else if (ext.equalsIgnoreCase(".pkl")) {
                    specAccessor = new SpectraMap(specFilePath, new PklSpectrumParser());
                } else if (ext.equalsIgnoreCase(".ms2")) {
                    specAccessor = new SpectraMap(specFilePath, new MS2SpectrumParser());
                } else if (fileName.endsWith("_dta.txt")) {
                    specAccessor = new SpectraMap(specFilePath, new PNNLSpectrumParser());
                } else {
                    out.print(psm.getInsPecTString() + "\tN/A: unrecognizable spec format");
                    if (addMSGFColumn) {
                        out.print("\t\t");
                    }
                    out.println();
                    continue;
                }
                prevScanNum = psm.getScanNum();
                spec = specAccessor.getSpectrumBySpecIndex(prevScanNum);
                if (onePerSpec) {
                    keyList.add(psm.getSpecFileName() + ":" + psm.getScanNum());
                }
            }
            if (spec == null) {
                out.print(psm.getInsPecTString() + "\tN/A: unrecognizable spec format");
                if (addMSGFColumn) {
                    out.print("\t\t");
                }
                out.println();
                continue;
            }
            if (psm.getPeptide() == null || psm.getPeptide().contains(null)) {
                out.print(psm.getInsPecTString() + "\tN/A: unrecognizable identification: " + psm.getPeptideStr());
                if (addMSGFColumn) {
                    out.print("\t\t");
                }
                out.println();
                continue;
            }
            spec.getPrecursorPeak().setCharge(psm.getCharge());
            float expPM = spec.getPrecursorMass();
            float calcPM = psm.getPeptide().getParentMass();
            if (Math.abs(expPM - calcPM) > 10.0f) {
                out.print(psm.getInsPecTString() + "\tN/A: precursor mass != peptide mass (" + expPM + " vs " + calcPM + ")");
                if (addMSGFColumn) {
                    out.print("\t\t");
                }
                out.println();
                continue;
            }
            if (activationMethod == ActivationMethod.ASWRITTEN) {
                scorer = NewScorerFactory.get(spec.getActivationMethod(), instType, enzyme, Protocol.AUTOMATIC);
            }
            NewScoredSpectrum<NominalMass> scoredSpec = scorer.getScoredSpectrum(spec);
            AminoAcidSet modAASet = psm.getAASet(aaSet);
            modAASet.registerEnzyme(enzyme);
            FlexAminoAcidGraph graph = new FlexAminoAcidGraph(modAASet, psm.getPeptide().getNominalMass(), enzyme, scoredSpec, false, false);
            int msgfScore = ((DeNovoGraph)graph).getScore(psm.getAnnotation());
            GeneratingFunction<NominalMass> gf = new GeneratingFunction<NominalMass>(graph).enzyme(enzyme).doNotBacktrack().doNotCalcNumber();
            gf.setUpScoreThreshold(msgfScore);
            gf.computeGeneratingFunction();
            double specProb = gf.getSpectralProbability(msgfScore);
            assert (specProb > 0.0) : psm.getInsPecTString() + "\tSpecProb is zero!";
            String output = psm.getInsPecTString() + "\t" + specProb;
            if (addMSGFColumn) {
                output = output + "\t" + msgfScore + "\t" + (gf.getMaxScore() - 1);
            }
            if (!(specProb <= (double)specProbThreshold)) continue;
            if (!onePerSpec) {
                out.println(output);
                continue;
            }
            String specKey = psm.getSpecFileName() + ":" + psm.getScanNum();
            Double prevBest = (Double)minSpecProb.get(specKey);
            if (prevBest != null && !(specProb < prevBest)) continue;
            minSpecProb.put(specKey, specProb);
            bestOut.put(specKey, output);
        }
        if (onePerSpec) {
            for (String key : keyList) {
                out.println((String)bestOut.get(key));
            }
        }
        out.flush();
        out.close();
        return null;
    }
}

