/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsd.msjava.ui;

import edu.ucsd.msjava.msdbsearch.ConcurrentMSGFDB;
import edu.ucsd.msjava.msdbsearch.ScoredSpectraMap;
import edu.ucsd.msjava.msgf.MSGFDBResultGenerator;
import edu.ucsd.msjava.msgf.Tolerance;
import edu.ucsd.msjava.msscorer.NewScorerFactory;
import edu.ucsd.msjava.msutil.ActivationMethod;
import edu.ucsd.msjava.msutil.Enzyme;
import edu.ucsd.msjava.msutil.InstrumentType;
import edu.ucsd.msjava.msutil.Protocol;
import edu.ucsd.msjava.msutil.SpecFileFormat;
import edu.ucsd.msjava.msutil.SpecKey;
import edu.ucsd.msjava.msutil.SpectraAccessor;
import edu.ucsd.msjava.params.FileParameter;
import edu.ucsd.msjava.params.ParamManager;
import edu.ucsd.msjava.params.ToleranceParameter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Deprecated
public class MSGFDBLib {
    public static final String VERSION = "7573";
    public static final String RELEASE_DATE = "04/04/2012";
    public static final String DECOY_DB_EXTENSION = ".revConcat.fasta";

    public static void main(String[] argv) {
        long time = System.currentTimeMillis();
        ParamManager paramManager = new ParamManager("MSGFDBLib", VERSION, RELEASE_DATE, "java -Xmx2000M -jar MSGFDBLib.jar");
        paramManager.addMSGFLibParams();
        if (argv.length == 0) {
            paramManager.printUsageInfo();
            return;
        }
        String errMessage = paramManager.parseParams(argv);
        if (errMessage != null) {
            System.err.println("[Error] " + errMessage);
            System.out.println();
            paramManager.printUsageInfo();
            return;
        }
        paramManager.printToolInfo();
        String errorMessage = MSGFDBLib.runMSGFLib(paramManager);
        if (errorMessage != null) {
            System.err.println("[Error] " + errorMessage);
            System.out.println();
        } else {
            System.out.format("MS-GFDBLib complete (total elapsed time: %.2f sec)\n", Float.valueOf((float)(System.currentTimeMillis() - time) / 1000.0f));
        }
    }

    public static String runMSGFLib(ParamManager paramManager) {
        long time = System.currentTimeMillis();
        FileParameter specParam = paramManager.getSpecFileParam();
        File specFile = specParam.getFile();
        SpecFileFormat specFormat = (SpecFileFormat)specParam.getFileFormat();
        File libraryFile = paramManager.getFile("d");
        ToleranceParameter tol = (ToleranceParameter)paramManager.getParameter("t");
        Tolerance leftParentMassTolerance = tol.getLeftTolerance();
        Tolerance rightParentMassTolerance = tol.getRightTolerance();
        int numAllowedC13 = paramManager.getIntValue("c13");
        if (rightParentMassTolerance.getToleranceAsDa(1000.0f, 2) >= 0.5f) {
            numAllowedC13 = 0;
        }
        File outputFile = paramManager.getOutputFileParam().getFile();
        Enzyme enzyme = paramManager.getEnzyme();
        ActivationMethod activationMethod = paramManager.getActivationMethod();
        InstrumentType instType = paramManager.getInstType();
        if (activationMethod == ActivationMethod.HCD) {
            instType = InstrumentType.HIGH_RESOLUTION_LTQ;
        }
        Protocol protocol = paramManager.getProtocol();
        int numMatchesPerSpec = paramManager.getIntValue("n");
        int numThreads = paramManager.getIntValue("thread");
        System.out.println("Reading spectra...");
        SpectraAccessor specAcc = new SpectraAccessor(specFile, specFormat);
        if (specAcc.getSpecMap() == null || specAcc.getSpecItr() == null) {
            return "Error while parsing spectrum file: " + specFile.getPath();
        }
        long maxMemory = Runtime.getRuntime().maxMemory() - 1L << 28;
        int avgPeptideMass = 2000;
        int numBytesPerMass = 12;
        int numSpecScannedTogether = (int)((float)maxMemory / (float)avgPeptideMass / (float)numBytesPerMass);
        ArrayList<SpecKey> specKeyList = SpecKey.getSpecKeyList(specAcc.getSpecItr(), 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, activationMethod, 10, false);
        int specSize = specKeyList.size();
        System.out.print("Reading spectra finished ");
        System.out.format("(elapsed time: %.2f sec)\n", Float.valueOf((float)(System.currentTimeMillis() - time) / 1000.0f));
        numThreads = Math.min(numThreads, Math.round((float)Math.min(specSize, numSpecScannedTogether) / 250.0f));
        if (numThreads == 0) {
            numThreads = 1;
        }
        System.out.println("Using " + numThreads + (numThreads == 1 ? " thread." : " threads."));
        NewScorerFactory.SpecDataType specDataType = new NewScorerFactory.SpecDataType(activationMethod, instType, enzyme, protocol);
        List<MSGFDBResultGenerator.DBMatch> resultList = Collections.synchronizedList(new ArrayList());
        for (int fromIndexGlobal = 0; fromIndexGlobal < specSize; fromIndexGlobal += numSpecScannedTogether) {
            int i;
            int toIndexGlobal = Math.min(specSize, fromIndexGlobal + numSpecScannedTogether);
            System.out.println("Spectrum " + fromIndexGlobal + "-" + (toIndexGlobal - 1) + " (total: " + specSize + ")");
            ExecutorService executor = Executors.newFixedThreadPool(numThreads);
            int size = toIndexGlobal - fromIndexGlobal;
            int subListSize = size / numThreads;
            int residue = size % numThreads;
            int[] startIndex = new int[numThreads];
            int[] endIndex = new int[numThreads];
            for (i = 0; i < numThreads; ++i) {
                startIndex[i] = i > 0 ? endIndex[i - 1] : fromIndexGlobal;
                endIndex[i] = startIndex[i] + subListSize + (i < residue ? 1 : 0);
            }
            for (i = 0; i < numThreads; ++i) {
                ScoredSpectraMap specScanner = new ScoredSpectraMap(specAcc, Collections.synchronizedList(specKeyList.subList(startIndex[i], endIndex[i])), leftParentMassTolerance, rightParentMassTolerance, numAllowedC13, specDataType, false);
                ConcurrentMSGFDB.RunMSGFDBLib msgfdbExecutor = new ConcurrentMSGFDB.RunMSGFDBLib(specScanner, numMatchesPerSpec, resultList, specFile.getName(), libraryFile.getPath());
                executor.execute(msgfdbExecutor);
            }
            executor.shutdown();
            while (!executor.isTerminated()) {
            }
        }
        time = System.currentTimeMillis();
        Collections.sort(resultList);
        String header = "#SpecFile\tSpecIndex\tScan#\tFragMethod\tPrecursor\tPMError(" + (rightParentMassTolerance.isTolerancePPM() ? "ppm" : "Da") + ")\tCharge\tPeptide\tProtein\tDeNovoScore\tMSGFScore\tSpecProb\tP-value";
        MSGFDBResultGenerator gen = new MSGFDBResultGenerator(header, resultList);
        PrintStream out = null;
        if (outputFile == null) {
            out = System.out;
        } else {
            try {
                out = new PrintStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        gen.writeResults(out, false, false);
        if (out != System.out) {
            out.close();
        }
        return null;
    }
}

