/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.jrap.stax;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class IndexParser {
    String inputMZXMLfilename;
    Map<Integer, Long> offsetMap = new HashMap<Integer, Long>(10000);
    long chrogramIndex = -1L;
    int maxScan = -1;
    int currentScan = -1;
    boolean isXML = false;
    boolean isML = false;
    protected boolean debug = false;

    public IndexParser(String inputMZXMLfilename) {
        this.inputMZXMLfilename = inputMZXMLfilename;
        if (inputMZXMLfilename.toLowerCase().endsWith(".mzxml")) {
            this.isXML = true;
        } else {
            this.isML = true;
        }
    }

    public Map<Integer, Long> getOffsetMap() {
        if (this.debug) {
            System.out.println("offset size " + this.offsetMap.size());
        }
        return this.offsetMap;
    }

    public long getChrogramIndex() {
        if (this.debug) {
            System.out.println("chrogramIndex " + this.chrogramIndex);
        }
        return this.chrogramIndex;
    }

    public int getMaxScan() {
        if (this.debug) {
            System.out.println("maxScan " + this.maxScan);
        }
        return this.maxScan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getIndexPosition() {
        FileInputStream fileIN = null;
        long indexPosition = -1L;
        File tmpXML = null;
        String indexName = null;
        indexName = this.isXML ? "indexOffset" : "indexListOffset";
        try {
            int endIndex;
            tmpXML = new File(this.inputMZXMLfilename);
            fileIN = new FileInputStream(this.inputMZXMLfilename);
            fileIN.skip(tmpXML.length() - 500L);
            byte[] bytes = new byte[500];
            int bytesRead = fileIN.read(bytes);
            String footer = new String(bytes, 0, bytesRead);
            int offset = footer.indexOf("<" + indexName + ">");
            if (offset == -1) {
                System.err.println("<" + indexName + "> not found!!!");
            }
            if ((endIndex = (footer = footer.substring(offset + indexName.length() + 2)).indexOf("</" + indexName + ">")) == -1) {
                System.err.println("</" + indexName + "> not found!!!");
            }
            footer = footer.substring(0, endIndex);
            indexPosition = Long.parseLong(footer);
            fileIN.close();
            if (this.debug) {
                System.out.println("indexPosition is " + indexPosition);
            }
        }
        catch (Exception e) {
            System.out.println("exception:" + e);
            e.printStackTrace();
        }
        finally {
            if (fileIN != null) {
                try {
                    fileIN.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return indexPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseIndexes() {
        FileInputStream fileIN = null;
        XMLStreamReader xmlSR = null;
        try {
            long indexPos = this.getIndexPosition();
            fileIN = new FileInputStream(this.inputMZXMLfilename);
            fileIN.skip(indexPos);
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            xmlSR = inputFactory.createXMLStreamReader(fileIN);
            String elementName = null;
            StringBuffer indexBuffer = new StringBuffer();
            boolean inOffSet = false;
            boolean inSpec = false;
            boolean inChrogram = false;
            while (xmlSR.hasNext()) {
                int event = xmlSR.next();
                if (event == 1) {
                    elementName = xmlSR.getLocalName();
                    if (elementName.equals("index") && this.isML) {
                        if (xmlSR.getAttributeValue(null, "name").equals("spectrum")) {
                            inSpec = true;
                        }
                        if (xmlSR.getAttributeValue(null, "name").equals("chromatogram")) {
                            inSpec = false;
                            inChrogram = true;
                        }
                    }
                    if (elementName.equals("offset")) {
                        if (indexBuffer.length() > 0) {
                            indexBuffer.delete(0, indexBuffer.capacity());
                        }
                        inOffSet = true;
                        if (this.isXML) {
                            this.currentScan = Integer.parseInt(xmlSR.getAttributeValue(null, "id"));
                        } else if (inSpec) {
                            this.currentScan = this.parseScanNumberFromOffsetIdrefField(xmlSR.getAttributeValue(null, "idRef"));
                        }
                    }
                }
                if (event == 4 && inOffSet) {
                    indexBuffer.append(xmlSR.getText());
                }
                if (event != 2) continue;
                elementName = xmlSR.getLocalName();
                if (elementName.equals("offset")) {
                    long offset = Long.valueOf(indexBuffer.toString());
                    if (inChrogram) {
                        this.chrogramIndex = offset;
                    } else {
                        assert (this.currentScan != -1) : "Did not find the scan number associated with offset " + indexBuffer.toString();
                        this.offsetMap.put(this.currentScan, offset);
                        this.maxScan = this.currentScan;
                        this.currentScan = -1;
                        indexBuffer.delete(0, indexBuffer.capacity());
                        inOffSet = false;
                    }
                }
                if (!elementName.equals("index")) continue;
                if (this.isXML) {
                    throw new XMLStreamException("IndexEndFoundException");
                }
                if (!inChrogram) continue;
                throw new XMLStreamException("IndexEndFoundException");
            }
        }
        catch (Exception e) {
            if (!e.getMessage().equals("IndexEndFoundException")) {
                e.printStackTrace(System.err);
            }
        }
        finally {
            if (xmlSR != null) {
                try {
                    xmlSR.close();
                }
                catch (XMLStreamException e) {
                    e.printStackTrace();
                }
            }
            if (fileIN != null) {
                try {
                    fileIN.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected int parseScanNumberFromOffsetIdrefField(String idString) {
        if (idString.contains("scan=")) {
            idString = idString.substring(idString.indexOf("scan=") + "scan=".length());
        }
        if (idString.contains(" ")) {
            idString = idString.substring(0, idString.indexOf(" "));
        }
        return Integer.parseInt(idString);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

