/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzidml.model.mzidml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import uk.ac.ebi.jmzidml.model.ParamGroupCapable;
import uk.ac.ebi.jmzidml.model.mzidml.AbstractParam;
import uk.ac.ebi.jmzidml.model.mzidml.CvParam;
import uk.ac.ebi.jmzidml.model.mzidml.DBSequence;
import uk.ac.ebi.jmzidml.model.mzidml.Identifiable;
import uk.ac.ebi.jmzidml.model.mzidml.PeptideHypothesis;
import uk.ac.ebi.jmzidml.model.mzidml.UserParam;
import uk.ac.ebi.jmzidml.model.utils.FacadeList;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ProteinDetectionHypothesisType", propOrder={"peptideHypothesis", "paramGroup"})
public class ProteinDetectionHypothesis
extends Identifiable
implements Serializable,
ParamGroupCapable {
    private static final long serialVersionUID = 100L;
    @XmlElement(name="PeptideHypothesis", required=true)
    protected List<PeptideHypothesis> peptideHypothesis;
    @XmlElements(value={@XmlElement(name="cvParam", type=CvParam.class), @XmlElement(name="userParam", type=UserParam.class)})
    protected List<AbstractParam> paramGroup;
    @XmlAttribute(name="dBSequence_ref")
    protected String dbSequenceRef;
    @XmlAttribute(required=true)
    protected boolean passThreshold;
    @XmlTransient
    protected DBSequence dbSequence;

    public List<PeptideHypothesis> getPeptideHypothesis() {
        if (this.peptideHypothesis == null) {
            this.peptideHypothesis = new ArrayList<PeptideHypothesis>();
        }
        return this.peptideHypothesis;
    }

    public List<AbstractParam> getParamGroup() {
        if (this.paramGroup == null) {
            this.paramGroup = new ArrayList<AbstractParam>();
        }
        return this.paramGroup;
    }

    public String getDBSequenceRef() {
        return this.dbSequenceRef;
    }

    public boolean isPassThreshold() {
        return this.passThreshold;
    }

    public void setPassThreshold(boolean value) {
        this.passThreshold = value;
    }

    public DBSequence getDBSequence() {
        return this.dbSequence;
    }

    public void setDBSequence(DBSequence dbSequence) {
        if (dbSequence == null) {
            this.dbSequenceRef = null;
        } else {
            String refId = dbSequence.getId();
            if (refId == null) {
                throw new IllegalArgumentException("Referenced object does not have an identifier.");
            }
            this.dbSequenceRef = refId;
        }
        this.dbSequence = dbSequence;
    }

    @Override
    public List<CvParam> getCvParam() {
        return new FacadeList<CvParam>(this.getParamGroup(), CvParam.class);
    }

    @Override
    public List<UserParam> getUserParam() {
        return new FacadeList<UserParam>(this.getParamGroup(), UserParam.class);
    }
}

