/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzidml.model.mzidml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import uk.ac.ebi.jmzidml.model.ParamGroupCapable;
import uk.ac.ebi.jmzidml.model.mzidml.AbstractParam;
import uk.ac.ebi.jmzidml.model.mzidml.CvParam;
import uk.ac.ebi.jmzidml.model.mzidml.Fragmentation;
import uk.ac.ebi.jmzidml.model.mzidml.Identifiable;
import uk.ac.ebi.jmzidml.model.mzidml.MassTable;
import uk.ac.ebi.jmzidml.model.mzidml.Peptide;
import uk.ac.ebi.jmzidml.model.mzidml.PeptideEvidenceRef;
import uk.ac.ebi.jmzidml.model.mzidml.Sample;
import uk.ac.ebi.jmzidml.model.mzidml.UserParam;
import uk.ac.ebi.jmzidml.model.utils.FacadeList;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SpectrumIdentificationItemType", propOrder={"peptideEvidenceRef", "fragmentation", "paramGroup"})
public class SpectrumIdentificationItem
extends Identifiable
implements Serializable,
ParamGroupCapable {
    private static final long serialVersionUID = 100L;
    @XmlElement(name="PeptideEvidenceRef", required=true)
    protected List<PeptideEvidenceRef> peptideEvidenceRef;
    @XmlElement(name="Fragmentation")
    protected Fragmentation fragmentation;
    @XmlElements(value={@XmlElement(name="cvParam", type=CvParam.class), @XmlElement(name="userParam", type=UserParam.class)})
    protected List<AbstractParam> paramGroup;
    @XmlAttribute(required=true)
    protected int chargeState;
    @XmlAttribute(required=true)
    protected double experimentalMassToCharge;
    @XmlAttribute
    protected Double calculatedMassToCharge;
    @XmlAttribute
    protected Float calculatedPI;
    @XmlAttribute(name="peptide_ref")
    protected String peptideRef;
    @XmlAttribute(required=true)
    protected int rank;
    @XmlAttribute(required=true)
    protected boolean passThreshold;
    @XmlAttribute(name="massTable_ref")
    protected String massTableRef;
    @XmlAttribute(name="sample_ref")
    protected String sampleRef;
    @XmlTransient
    protected Peptide peptide;
    @XmlTransient
    protected MassTable massTable;
    @XmlTransient
    protected Sample sample;

    public Peptide getPeptide() {
        return this.peptide;
    }

    public void setPeptide(Peptide peptide) {
        if (peptide == null) {
            this.peptideRef = null;
        } else {
            String refId = peptide.getId();
            if (refId == null) {
                throw new IllegalArgumentException("Referenced object does not have an identifier.");
            }
            this.peptideRef = refId;
        }
        this.peptide = peptide;
    }

    public MassTable getMassTable() {
        return this.massTable;
    }

    public void setMassTable(MassTable massTable) {
        if (massTable == null) {
            this.massTableRef = null;
        } else {
            String refId = massTable.getId();
            if (refId == null) {
                throw new IllegalArgumentException("Referenced object does not have an identifier.");
            }
            this.massTableRef = refId;
        }
        this.massTable = massTable;
    }

    public Sample getSample() {
        return this.sample;
    }

    public void setSample(Sample sample) {
        if (sample == null) {
            this.sampleRef = null;
        } else {
            String refId = sample.getId();
            if (refId == null) {
                throw new IllegalArgumentException("Referenced object does not have an identifier.");
            }
            this.sampleRef = refId;
        }
        this.sample = sample;
    }

    public List<PeptideEvidenceRef> getPeptideEvidenceRef() {
        if (this.peptideEvidenceRef == null) {
            this.peptideEvidenceRef = new ArrayList<PeptideEvidenceRef>();
        }
        return this.peptideEvidenceRef;
    }

    public Fragmentation getFragmentation() {
        if (this.fragmentation == null) {
            this.fragmentation = new Fragmentation();
        }
        return this.fragmentation;
    }

    public void setFragmentation(Fragmentation value) {
        this.fragmentation = value;
    }

    public List<AbstractParam> getParamGroup() {
        if (this.paramGroup == null) {
            this.paramGroup = new ArrayList<AbstractParam>();
        }
        return this.paramGroup;
    }

    public int getChargeState() {
        return this.chargeState;
    }

    public void setChargeState(int value) {
        this.chargeState = value;
    }

    public double getExperimentalMassToCharge() {
        return this.experimentalMassToCharge;
    }

    public void setExperimentalMassToCharge(double value) {
        this.experimentalMassToCharge = value;
    }

    public Double getCalculatedMassToCharge() {
        return this.calculatedMassToCharge;
    }

    public void setCalculatedMassToCharge(Double value) {
        this.calculatedMassToCharge = value;
    }

    public Float getCalculatedPI() {
        return this.calculatedPI;
    }

    public void setCalculatedPI(Float value) {
        this.calculatedPI = value;
    }

    public String getPeptideRef() {
        return this.peptideRef;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int value) {
        this.rank = value;
    }

    public boolean isPassThreshold() {
        return this.passThreshold;
    }

    public void setPassThreshold(boolean value) {
        this.passThreshold = value;
    }

    public String getMassTableRef() {
        return this.massTableRef;
    }

    public String getSampleRef() {
        return this.sampleRef;
    }

    @Override
    public List<CvParam> getCvParam() {
        return new FacadeList<CvParam>(this.getParamGroup(), CvParam.class);
    }

    @Override
    public List<UserParam> getUserParam() {
        return new FacadeList<UserParam>(this.getParamGroup(), UserParam.class);
    }
}

