/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzidml.xml.util;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import uk.ac.ebi.jmzidml.model.utils.MzIdentMLVersion;
import uk.ac.ebi.jmzidml.xml.util.EscapingXMLUtilities;

public class EscapingXMLStreamWriter
implements XMLStreamWriter {
    private final XMLStreamWriter writer;
    private String charEncoding;
    private MzIdentMLVersion version;

    public EscapingXMLStreamWriter(XMLStreamWriter writer, MzIdentMLVersion version) {
        if (null == writer) {
            throw new IllegalArgumentException("null");
        }
        this.writer = writer;
        this.charEncoding = "UTF-8";
        this.version = version;
    }

    public EscapingXMLStreamWriter(XMLStreamWriter writer, MzIdentMLVersion version, String encoding) {
        this(writer, version);
        if (encoding != null) {
            this.charEncoding = encoding;
        }
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.writer.writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writer.writeStartElement(this.version.getNameSpace(), localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writer.writeStartElement("", localName, this.version.getNameSpace());
    }

    @Override
    public void writeEmptyElement(String namesapceURI, String localName) throws XMLStreamException {
        this.writer.writeEmptyElement(this.version.getNameSpace(), localName);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namesapceURI) throws XMLStreamException {
        this.writer.writeEmptyElement("", localName, this.version.getNameSpace());
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.writer.writeEmptyElement(localName);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.writer.writeEndElement();
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.writer.writeEndDocument();
    }

    @Override
    public void close() throws XMLStreamException {
        this.writer.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.writer.flush();
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(localName, EscapingXMLUtilities.escapeCharacters(value));
    }

    @Override
    public void writeAttribute(String prefix, String namespaceUri, String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute("", this.version.getNameSpace(), localName, EscapingXMLUtilities.escapeCharacters(value));
    }

    @Override
    public void writeAttribute(String namespaceUri, String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(this.version.getNameSpace(), localName, EscapingXMLUtilities.escapeCharacters(value));
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.writer.writeNamespace("", this.version.getNameSpace());
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.writer.writeDefaultNamespace(this.version.getNameSpace());
    }

    @Override
    public void writeComment(String s) throws XMLStreamException {
        this.writer.writeComment(s);
    }

    @Override
    public void writeProcessingInstruction(String s) throws XMLStreamException {
        this.writer.writeProcessingInstruction(s);
    }

    @Override
    public void writeProcessingInstruction(String s, String s1) throws XMLStreamException {
        this.writer.writeProcessingInstruction(s, s1);
    }

    @Override
    public void writeCData(String s) throws XMLStreamException {
        this.writer.writeCData(EscapingXMLUtilities.escapeCharacters(s));
    }

    @Override
    public void writeDTD(String s) throws XMLStreamException {
        this.writer.writeDTD(s);
    }

    @Override
    public void writeEntityRef(String s) throws XMLStreamException {
        this.writer.writeEntityRef(s);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.writer.writeStartDocument(this.charEncoding, "1.0");
    }

    @Override
    public void writeStartDocument(String s) throws XMLStreamException {
        this.writer.writeStartDocument(s);
    }

    @Override
    public void writeStartDocument(String s, String s1) throws XMLStreamException {
        this.writer.writeStartDocument(s, s1);
    }

    @Override
    public void writeCharacters(String s) throws XMLStreamException {
        this.writer.writeCharacters(EscapingXMLUtilities.escapeCharacters(s));
    }

    @Override
    public void writeCharacters(char[] chars, int start, int len) throws XMLStreamException {
        this.writer.writeCharacters(EscapingXMLUtilities.escapeCharacters(new String(chars, start, len)));
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.writer.getPrefix(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.writer.setPrefix(prefix, uri);
    }

    @Override
    public void setDefaultNamespace(String s) throws XMLStreamException {
        this.writer.setDefaultNamespace(this.version.getNameSpace());
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        this.writer.setNamespaceContext(namespaceContext);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.writer.getNamespaceContext();
    }

    @Override
    public Object getProperty(String s) throws IllegalArgumentException {
        return this.writer.getProperty(s);
    }
}

