/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzml.model.mzml.utilities;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import uk.ac.ebi.jmzml.MzMLElement;
import uk.ac.ebi.jmzml.model.mzml.MzML;

public class ModelConstants {
    public static final String PACKAGE = MzML.class.getPackage().getName();
    public static final String MZML_NS = "http://psi.hupo.org/ms/mzml";
    private static Map<Class, QName> modelQNames = new HashMap<Class, QName>();

    public static boolean isRegisteredClass(Class cls) {
        return modelQNames.containsKey(cls);
    }

    public static QName getQNameForClass(Class cls) {
        if (ModelConstants.isRegisteredClass(cls)) {
            return modelQNames.get(cls);
        }
        throw new IllegalStateException("No QName registered for class: " + cls);
    }

    public static String getElementNameForClass(Class cls) {
        if (ModelConstants.isRegisteredClass(cls)) {
            return modelQNames.get(cls).getLocalPart();
        }
        throw new IllegalStateException("No QName registered for class: " + cls);
    }

    public static Class getClassForElementName(String name) {
        for (Map.Entry<Class, QName> entry : modelQNames.entrySet()) {
            if (!entry.getValue().getLocalPart().equals(name)) continue;
            return entry.getKey();
        }
        return null;
    }

    static {
        for (MzMLElement element : MzMLElement.values()) {
            if (element.getTagName() == null) continue;
            modelQNames.put(element.getClazz(), new QName(MZML_NS, element.getTagName()));
        }
        modelQNames = Collections.unmodifiableMap(modelQNames);
    }
}

