/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzml.xml.jaxb.resolver;

import java.io.StringReader;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.sax.SAXSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import uk.ac.ebi.jmzml.model.mzml.MzMLObject;
import uk.ac.ebi.jmzml.xml.io.MzMLObjectCache;
import uk.ac.ebi.jmzml.xml.jaxb.unmarshaller.UnmarshallerFactory;
import uk.ac.ebi.jmzml.xml.jaxb.unmarshaller.filters.MzMLNamespaceFilter;
import uk.ac.ebi.jmzml.xml.xxindex.MzMLIndexer;

public abstract class AbstractReferenceResolver<T extends MzMLObject>
extends Unmarshaller.Listener {
    private static final Logger log = LoggerFactory.getLogger(AbstractReferenceResolver.class);
    private MzMLIndexer index = null;
    private MzMLObjectCache cache = null;

    protected AbstractReferenceResolver(MzMLIndexer index, MzMLObjectCache cache) {
        this.index = index;
        this.cache = cache;
    }

    public <R extends MzMLObject> R unmarshal(String refId, Class<R> cls) {
        MzMLObject retVal = null;
        if (retVal == null) {
            log.debug("AbstractReferenceResolver.unmarshal for id: " + refId);
            String xml = this.index.getXmlString(refId, cls);
            try {
                MzMLNamespaceFilter xmlFilter = new MzMLNamespaceFilter();
                Unmarshaller unmarshaller = UnmarshallerFactory.getInstance().initializeUnmarshaller(this.index, this.cache, xmlFilter);
                JAXBElement<R> holder = unmarshaller.unmarshal(new SAXSource(xmlFilter, new InputSource(new StringReader(xml))), cls);
                retVal = (MzMLObject)holder.getValue();
            }
            catch (JAXBException e) {
                log.error("AbstractReferenceResolver.unmarshal", e);
                throw new IllegalStateException("Could not unmarshall refId: " + refId + " for element type: " + cls);
            }
        }
        return (R)retVal;
    }

    public abstract void updateObject(T var1);

    public abstract void checkRefID(T var1);
}

