/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jaxb.utils;

import java.util.Arrays;
import java.util.Collection;

public enum CvTermReference {
    FLOAT_16_BIT("MS", "MS:1000520", "16-bit float", "MS:1000518"),
    FLOAT_32_BIT("MS", "MS:1000521", "32-bit float", "MS:1000518"),
    FLOAT_64_BIT("MS", "MS:1000523", "64-bit float", "MS:1000518"),
    INT_32_BIT("MS", "MS:1000519", "32-bit integer", "MS:1000518"),
    INT_64_BIT("MS", "MS:1000522", "64-bit integer", "MS:1000518");

    private final String cvLabel;
    private final String accession;
    private final String name;
    private final String parentAccession;

    private CvTermReference(String cvLabel, String accession, String name, String parentAccession) {
        this.cvLabel = cvLabel;
        this.accession = accession;
        this.name = name;
        this.parentAccession = parentAccession;
    }

    public String getCvLabel() {
        return this.cvLabel;
    }

    private String getAccession() {
        return this.accession;
    }

    public String getName() {
        return this.name;
    }

    private Collection<String> getParentAccessions() {
        return Arrays.asList(this.parentAccession.split(";"));
    }

    private static CvTermReference getCvRefByAccession(String accession) {
        CvTermReference[] cvTerms;
        CvTermReference cvTerm = null;
        for (CvTermReference cv : cvTerms = CvTermReference.values()) {
            if (!cv.getAccession().equals(accession)) continue;
            cvTerm = cv;
        }
        return cvTerm;
    }

    public static boolean hasAccession(String accession) {
        CvTermReference[] cvTerms;
        boolean result = false;
        for (CvTermReference cv : cvTerms = CvTermReference.values()) {
            if (!cv.getAccession().equals(accession)) continue;
            result = true;
        }
        return result;
    }

    public static boolean isChild(String parentAcc, String childAcc) {
        boolean isChild = false;
        CvTermReference childCvTerm = CvTermReference.getCvRefByAccession(childAcc);
        if (childCvTerm != null && childCvTerm.getParentAccessions().contains(parentAcc)) {
            isChild = true;
        }
        return isChild;
    }
}

