/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jaxb.xml.extractor;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import psidev.psi.tools.xxindex.index.IndexElement;
import uk.ac.ebi.pride.jaxb.xml.PrideXmlXpath;
import uk.ac.ebi.pride.jaxb.xml.xxindex.XmlIndexer;
import uk.ac.ebi.pride.jaxb.xml.xxindex.XmlIndexerFactory;

public class PrideXmlExtractor {
    private static final Logger logger = LoggerFactory.getLogger(PrideXmlExtractor.class.getName());
    private static final Pattern ID_PATTERN = Pattern.compile("\\sid\\s*=\\s*['\"]([^'\"]*)['\"]", 2);
    private static final Pattern VERSION_PATTERN = Pattern.compile("\\sversion\\s*=\\s*['\"]([^'\"]*)['\"]", 2);
    private static final Pattern TAG_PATTERN = Pattern.compile("<[^>]+>\\s*([^<>]+)\\s*</[^>]+>", 2);
    private static final Pattern MS_LEVEL_PATTERN = Pattern.compile("\\smslevel\\s*=\\s*['\"]([^'\"]*)['\"]", 2);
    private static final int XML_CHAR_INCREMENT = 300;
    private Map<String, IndexElement> spectrumIdMap = null;
    private Map<String, IndexElement> gelFreeAccMap = null;
    private Map<String, IndexElement> twoDimAccMap = null;
    private Map<String, List<IndexElement>> identToPeptideMap = null;
    private List<String> identifiedSpectrumList = null;
    private XmlIndexer indexer = null;
    private File prideXmlFile = null;
    private int identificationId = 0;

    public PrideXmlExtractor(File xml) {
        if (xml == null) {
            throw new IllegalArgumentException("Xml file to be indexed must not be null");
        }
        if (!xml.exists()) {
            throw new IllegalArgumentException("Xml file to be indexed does not exist: " + xml.getAbsolutePath());
        }
        this.prideXmlFile = xml;
        this.indexer = XmlIndexerFactory.getInstance().buildIndex(this.prideXmlFile, PrideXmlXpath.getXpaths());
        this.initializeCaches();
    }

    public File getSourceFile() {
        return this.prideXmlFile;
    }

    private void initializeCaches() {
        this.spectrumIdMap = this.initCacheMap(PrideXmlXpath.MZDATA_SPECTRUM.getXpath(), ID_PATTERN);
        this.gelFreeAccMap = this.initIdentificationCacheMap(PrideXmlXpath.GELFREE.getXpath());
        this.twoDimAccMap = this.initIdentificationCacheMap(PrideXmlXpath.TWOD.getXpath());
        this.identToPeptideMap = this.initPeptideCacheMap();
        this.identifiedSpectrumList = this.initIdentifiedSpectrumList();
    }

    private Map<String, IndexElement> initCacheMap(String xpath, Pattern idPattern) {
        LinkedHashMap<String, IndexElement> idMap = new LinkedHashMap<String, IndexElement>();
        Collection<IndexElement> indexElements = this.indexer.getIndexElements(xpath);
        for (IndexElement indexElement : indexElements) {
            String id = this.getIDByPattern(indexElement, idPattern, true);
            if (idMap.containsKey(id)) {
                logger.error("Ambiguous ID Exception: " + xpath + " \nID: " + id);
                continue;
            }
            idMap.put(id, indexElement);
        }
        return idMap;
    }

    private Map<String, IndexElement> initIdentificationCacheMap(String xpath) {
        LinkedHashMap<String, IndexElement> idMap = new LinkedHashMap<String, IndexElement>();
        Collection<IndexElement> indexElements = this.indexer.getIndexElements(xpath);
        for (IndexElement indexElement : indexElements) {
            if (idMap.containsKey(this.identificationId + "")) {
                logger.error("Ambiguous ID Exception: " + xpath + " \nID: " + this.identificationId);
            } else {
                idMap.put(this.identificationId + "", indexElement);
            }
            ++this.identificationId;
        }
        return idMap;
    }

    private Map<String, List<IndexElement>> initPeptideCacheMap() {
        LinkedHashMap<String, List<IndexElement>> identPeptideMap = new LinkedHashMap<String, List<IndexElement>>();
        Collection<IndexElement> gelFreePeptideElements = this.indexer.getIndexElements(PrideXmlXpath.GELFREE_PEPTIDE.getXpath());
        for (IndexElement gelFreePeptideElement : gelFreePeptideElements) {
            String identId = this.searchForId(gelFreePeptideElement, this.gelFreeAccMap);
            this.addIdentPeptide(identId, gelFreePeptideElement, identPeptideMap);
        }
        Collection<IndexElement> twoDimPeptideElements = this.indexer.getIndexElements(PrideXmlXpath.TWOD_PEPTIDE.getXpath());
        for (IndexElement twoDimPeptideElement : twoDimPeptideElements) {
            String identId = this.searchForId(twoDimPeptideElement, this.twoDimAccMap);
            this.addIdentPeptide(identId, twoDimPeptideElement, identPeptideMap);
        }
        return identPeptideMap;
    }

    private List<String> initIdentifiedSpectrumList() {
        ArrayList<String> identifiedList = new ArrayList<String>();
        Collection<IndexElement> gelFreeSpectrumRefElements = this.indexer.getIndexElements(PrideXmlXpath.GELFREE_PEPTIDE_SPEC_REF.getXpath());
        for (IndexElement spectrumRefElement : gelFreeSpectrumRefElements) {
            String id = this.getIDByPattern(spectrumRefElement, TAG_PATTERN, false);
            identifiedList.add(id);
        }
        Collection<IndexElement> twoDimSpectrumRefElements = this.indexer.getIndexElements(PrideXmlXpath.TWOD_PEPTIDE_SPEC_REF.getXpath());
        for (IndexElement twoDimSpectrumRefElement : twoDimSpectrumRefElements) {
            String id = this.getIDByPattern(twoDimSpectrumRefElement, TAG_PATTERN, false);
            identifiedList.add(id);
        }
        return identifiedList;
    }

    private String searchForId(IndexElement element, Map<String, IndexElement> mappings) {
        String id = null;
        for (Map.Entry<String, IndexElement> entry : mappings.entrySet()) {
            IndexElement identElement = entry.getValue();
            if (identElement.getStart() > element.getStart() || identElement.getStop() < element.getStop()) continue;
            id = entry.getKey();
            break;
        }
        return id;
    }

    private void addIdentPeptide(String identId, IndexElement peptideElement, Map<String, List<IndexElement>> identPeptideMap) {
        List<IndexElement> elements = identPeptideMap.get(identId);
        if (elements == null) {
            elements = new ArrayList<IndexElement>();
            identPeptideMap.put(identId, elements);
        }
        elements.add(peptideElement);
    }

    public String getExpCollectionVersionString() {
        String version;
        block0: {
            Collection<IndexElement> indexElements = this.indexer.getIndexElements(PrideXmlXpath.EXP_COLLECTION.getXpath());
            version = null;
            Iterator<IndexElement> iterator = indexElements.iterator();
            if (!iterator.hasNext()) break block0;
            IndexElement indexElement = iterator.next();
            version = this.getIDByPattern(indexElement, VERSION_PATTERN, true);
        }
        return version;
    }

    public String getExpAccXmlString() {
        return this.getFirstXmlString(PrideXmlXpath.EXP_ACC.getXpath());
    }

    public String getExpTitleXmlString() {
        return this.getFirstXmlString(PrideXmlXpath.EXP_TITLE.getXpath());
    }

    public List<String> getReferenceXmlStrings() {
        return this.indexer.getXmlStringList(PrideXmlXpath.EXP_REF.getXpath());
    }

    public String getExpShortLabelXmlString() {
        return this.getFirstXmlString(PrideXmlXpath.EXP_SHORTLABEL.getXpath());
    }

    public String getProtocolXmlString() {
        return this.getFirstXmlString(PrideXmlXpath.EXP_PROTOCOL.getXpath());
    }

    public String getAdditionalParamXmlString() {
        return this.getFirstXmlString(PrideXmlXpath.EXP_ADDITIONAL.getXpath());
    }

    public List<String> getCvLookupXmlStrings() {
        return this.indexer.getXmlStringList(PrideXmlXpath.MZDATA_CVLOOKUP.getXpath());
    }

    public String getDescriptionXmlString() {
        return this.getFirstXmlString(PrideXmlXpath.MZDATA_DESC.getXpath());
    }

    public String getAdminXmlString() {
        return this.getFirstXmlString(PrideXmlXpath.MZDATA_DESC_AMDIN.getXpath());
    }

    public String getInstrumentXmlString() {
        return this.getFirstXmlString(PrideXmlXpath.MZDATA_DESC_INSTRUMENT.getXpath());
    }

    public String getDataProcessingXmlString() {
        return this.getFirstXmlString(PrideXmlXpath.MZDATA_DESC_DATAPROCESSING.getXpath());
    }

    public List<String> getSpectrumIds() {
        return new ArrayList<String>(this.spectrumIdMap.keySet());
    }

    public String getSpectrumXmlString(String id) {
        String result = null;
        if (this.spectrumIdMap != null && this.spectrumIdMap.containsKey(id)) {
            result = this.indexer.getXmlByIndexElement(this.spectrumIdMap.get(id));
        }
        return result;
    }

    public Map<String, IndexElement> getSpectrumIndices() {
        return new HashMap<String, IndexElement>(this.spectrumIdMap);
    }

    public int getSpectrumMsLevel(String id) {
        int msLevel = -1;
        if (this.spectrumIdMap != null && this.spectrumIdMap.containsKey(id)) {
            String msLevelStr = this.getIDByPattern(this.spectrumIdMap.get(id), MS_LEVEL_PATTERN, false);
            msLevel = Integer.parseInt(msLevelStr);
        }
        return msLevel;
    }

    public boolean isIdentifiedSpectrum(String id) {
        return this.identifiedSpectrumList.contains(id);
    }

    public List<String> getIdentIds() {
        ArrayList<String> ids = new ArrayList<String>(this.gelFreeAccMap.keySet());
        ids.addAll(this.twoDimAccMap.keySet());
        return ids;
    }

    public String getIdentXmlString(String id) {
        String result = this.getGelFreeIdentXmlString(id);
        if (result == null) {
            result = this.getTwoDimIdentXmlString(id);
        }
        return result;
    }

    public boolean hasGelFreeIdentId(String id) {
        return this.gelFreeAccMap.containsKey(id);
    }

    public List<String> getGelFreeIdentIds() {
        return new ArrayList<String>(this.gelFreeAccMap.keySet());
    }

    public String getGelFreeIdentXmlString(String id) {
        String result = null;
        if (this.gelFreeAccMap != null && this.gelFreeAccMap.containsKey(id)) {
            result = this.indexer.getXmlByIndexElement(this.gelFreeAccMap.get(id));
        }
        return result;
    }

    public boolean hasTwoDimIdentId(String id) {
        return this.twoDimAccMap.containsKey(id);
    }

    public List<String> getTwoDimIdentIds() {
        return new ArrayList<String>(this.twoDimAccMap.keySet());
    }

    public String getTwoDimIdentXmlString(String id) {
        String result = null;
        if (this.twoDimAccMap != null && this.twoDimAccMap.containsKey(id)) {
            result = this.indexer.getXmlByIndexElement(this.twoDimAccMap.get(id));
        }
        return result;
    }

    public int getNumberOfPeptides() {
        int cnt = 0;
        Collection<IndexElement> gelFreePeptides = this.indexer.getIndexElements(PrideXmlXpath.GELFREE_PEPTIDE.getXpath());
        cnt += gelFreePeptides == null ? 0 : gelFreePeptides.size();
        Collection<IndexElement> twoDimPeptides = this.indexer.getIndexElements(PrideXmlXpath.TWOD_PEPTIDE.getXpath());
        return cnt += twoDimPeptides == null ? 0 : twoDimPeptides.size();
    }

    public int getNumberOfPeptides(String identId) {
        int cnt = 0;
        List<IndexElement> elements = this.identToPeptideMap.get(identId);
        if (elements != null) {
            cnt = elements.size();
        }
        return cnt;
    }

    public String getPeptideXmlString(String identId, int index) {
        String xml = null;
        List<IndexElement> elements = this.identToPeptideMap.get(identId);
        if (elements != null && index >= 0 && index < elements.size()) {
            xml = this.indexer.getXmlByIndexElement(elements.get(index));
        }
        return xml;
    }

    public List<String> getPeptideXmlStrings(String identId) {
        ArrayList<String> peptides = new ArrayList<String>();
        List<IndexElement> elements = this.identToPeptideMap.get(identId);
        for (IndexElement element : elements) {
            peptides.add(this.indexer.getXmlByIndexElement(element));
        }
        return peptides;
    }

    public Iterator<String> getPrideXmlEntries(String xpath) {
        return this.indexer.getXmlStringIterator(xpath);
    }

    private String getFirstXmlString(String xpath) {
        String xml = null;
        Iterator<String> xmlStrs = this.indexer.getXmlStringIterator(xpath);
        if (xmlStrs != null && xmlStrs.hasNext()) {
            xml = xmlStrs.next();
        }
        return xml;
    }

    private String getIDByPattern(IndexElement indexElement, Pattern pattern, boolean quickMatch) {
        long stop;
        String id = null;
        long start = indexElement.getStart();
        String xml = this.indexer.getXmlSnippet(start, stop = quickMatch ? start + 300L : indexElement.getStop());
        Matcher m = pattern.matcher(xml);
        if (m.find()) {
            id = m.group(1);
        }
        return id;
    }
}

