/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.tools.dta_parser;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;
import uk.ac.ebi.pride.tools.dta_parser.model.DtaSpectrum;
import uk.ac.ebi.pride.tools.jmzreader.JMzReader;
import uk.ac.ebi.pride.tools.jmzreader.JMzReaderException;
import uk.ac.ebi.pride.tools.jmzreader.model.IndexElement;
import uk.ac.ebi.pride.tools.jmzreader.model.Spectrum;
import uk.ac.ebi.pride.tools.jmzreader.model.impl.IndexElementImpl;
import uk.ac.ebi.pride.tools.utils.StringUtils;

public class DtaFile
implements JMzReader {
    private File sourceFile;
    private ArrayList<String> filenames;
    private Map<Integer, IndexElement> fileIndex;

    public DtaFile(File sourceFile) throws JMzReaderException {
        this.sourceFile = sourceFile;
        if (sourceFile.isDirectory()) {
            this.loadDirectoryIndex();
        } else {
            try {
                this.indexFile();
            }
            catch (IOException e) {
                throw new JMzReaderException("Failed to read from DTA file", e);
            }
        }
    }

    @Override
    public List<String> getSpectraIds() {
        ArrayList<String> ids = new ArrayList<String>();
        if (this.sourceFile.isDirectory()) {
            ids.addAll(this.filenames);
        } else {
            for (Integer id : this.fileIndex.keySet()) {
                ids.add(id.toString());
            }
        }
        return ids;
    }

    public static Spectrum getIndexedSpectrum(File sourcefile, IndexElement indexElement) throws JMzReaderException {
        if (sourcefile == null) {
            throw new JMzReaderException("Missing required parameter sourcefile.");
        }
        if (indexElement == null) {
            throw new JMzReaderException("Missing required parameter indexElement");
        }
        String specString = DtaFile.readSpectrumFromFile(sourcefile, indexElement);
        return new DtaSpectrum(specString, 1);
    }

    @Override
    public boolean acceptsFile() {
        return true;
    }

    @Override
    public boolean acceptsDirectory() {
        return true;
    }

    @Override
    public Spectrum getSpectrumById(String id) throws JMzReaderException {
        return this.getDtaSpectrum(id);
    }

    @Override
    public Spectrum getSpectrumByIndex(int index) throws JMzReaderException {
        return this.getDtaSpectrum(index);
    }

    @Override
    public Iterator<Spectrum> getSpectrumIterator() {
        return new SpectrumIterator();
    }

    private void indexFile() throws IOException {
        int size;
        String line;
        BufferedRandomAccessFile reader = new BufferedRandomAccessFile(this.sourceFile, "r", 1024000);
        this.fileIndex = new TreeMap<Integer, IndexElement>();
        boolean emptyLineFound = true;
        int currentSpectrum = 0;
        long startOffset = 0L;
        while ((line = reader.getNextLine()) != null) {
            if (StringUtils.globalTrim(line).length() == 0) {
                if (!emptyLineFound) {
                    size = (int)(reader.getFilePointer() - startOffset);
                    this.fileIndex.put(++currentSpectrum, new IndexElementImpl(startOffset, size));
                }
                startOffset = reader.getFilePointer();
                emptyLineFound = true;
                continue;
            }
            emptyLineFound = false;
        }
        size = (int)(reader.getFilePointer() - startOffset);
        if (size > 0) {
            this.fileIndex.put(++currentSpectrum, new IndexElementImpl(startOffset, size));
        }
        reader.close();
    }

    private void loadDirectoryIndex() {
        String[] dtaFiles = this.sourceFile.list(new DtaFileFilter());
        this.filenames = new ArrayList();
        Collections.addAll(this.filenames, dtaFiles);
    }

    @Override
    public int getSpectraCount() {
        return this.sourceFile.isDirectory() ? this.filenames.size() : this.fileIndex.size();
    }

    public DtaSpectrum getDtaSpectrum(Object index) throws JMzReaderException {
        IndexElement indexElement;
        if (this.sourceFile.isDirectory()) {
            if (!(index instanceof String)) {
                throw new JMzReaderException("Non-filename passed to DTA file object representing a directory. The spectrum index must be a filename.");
            }
            File specFile = new File(this.sourceFile.getAbsoluteFile() + File.separator + index);
            return new DtaSpectrum(specFile);
        }
        if (!(index instanceof Integer)) {
            index = Integer.parseInt(index.toString());
        }
        if ((indexElement = this.fileIndex.get(index)) == null) {
            throw new JMzReaderException("Spectrum with given index " + index + " does not exist in the parsed dta file.");
        }
        String spec = DtaFile.readSpectrumFromFile(this.sourceFile, indexElement);
        return new DtaSpectrum(spec, (Integer)index);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readSpectrumFromFile(File sourcefile, IndexElement indexElement) {
        try (RandomAccessFile accessFile = new RandomAccessFile(sourcefile, "r");){
            accessFile.seek(indexElement.getStart());
            int size = indexElement.getSize();
            byte[] buffer = new byte[size];
            accessFile.read(buffer);
            String string = new String(buffer);
            return string;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to read from file", e);
        }
    }

    public Iterator<DtaSpectrum> getDtaSpectrumIterator() {
        return new DtaFileSpectrumIterator();
    }

    @Override
    public List<IndexElement> getMsNIndexes(int msLevel) {
        if (msLevel != 2) {
            return Collections.emptyList();
        }
        if (this.sourceFile.isDirectory()) {
            return Collections.emptyList();
        }
        ArrayList<IndexElement> index = new ArrayList<IndexElement>(this.fileIndex.size());
        Integer i = 1;
        while (i <= this.fileIndex.size()) {
            index.add(this.fileIndex.get(i));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return index;
    }

    @Override
    public List<Integer> getMsLevels() {
        ArrayList<Integer> msLevels = new ArrayList<Integer>(1);
        msLevels.add(2);
        return msLevels;
    }

    @Override
    public Map<String, IndexElement> getIndexElementForIds() {
        if (this.sourceFile.isDirectory()) {
            return Collections.emptyMap();
        }
        HashMap<String, IndexElement> index = new HashMap<String, IndexElement>(this.fileIndex.size());
        Integer i = 1;
        while (i <= this.fileIndex.size()) {
            index.put(i.toString(), this.fileIndex.get(i));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return index;
    }

    public class DtaFileFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".dta");
        }
    }

    private class DtaFileSpectrumIterator
    implements Iterator<DtaSpectrum>,
    Iterable<DtaSpectrum> {
        int currentIndex = 0;

        private DtaFileSpectrumIterator() {
        }

        @Override
        public Iterator<DtaSpectrum> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            if (DtaFile.this.sourceFile.isDirectory()) {
                return this.currentIndex < DtaFile.this.filenames.size();
            }
            return DtaFile.this.fileIndex.containsKey(this.currentIndex + 1);
        }

        @Override
        public DtaSpectrum next() {
            if (DtaFile.this.sourceFile.isDirectory()) {
                String filename = (String)DtaFile.this.filenames.get(this.currentIndex++);
                File specFile = new File(DtaFile.this.sourceFile.getAbsolutePath() + File.separator + filename);
                try {
                    return new DtaSpectrum(specFile);
                }
                catch (JMzReaderException e) {
                    throw new RuntimeException("Failed to parse dta spectrum", e);
                }
            }
            IndexElement indexElement = (IndexElement)DtaFile.this.fileIndex.get(this.currentIndex++ + 1);
            String spec = DtaFile.readSpectrumFromFile(DtaFile.this.sourceFile, indexElement);
            try {
                return new DtaSpectrum(spec, this.currentIndex);
            }
            catch (JMzReaderException e) {
                throw new RuntimeException("Failed to parse dta spectrum", e);
            }
        }

        @Override
        public void remove() {
            throw new IllegalStateException("Objects cannot be removed from DtaFileSpectrumIterator.");
        }
    }

    private class SpectrumIterator
    implements Iterator<Spectrum> {
        private DtaFileSpectrumIterator it;

        private SpectrumIterator() {
            this.it = new DtaFileSpectrumIterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Spectrum next() {
            return this.it.next();
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }
}

