/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.tools.mgf_parser.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import uk.ac.ebi.pride.tools.jmzreader.JMzReaderException;
import uk.ac.ebi.pride.tools.jmzreader.model.Spectrum;
import uk.ac.ebi.pride.tools.jmzreader.model.impl.CvParam;
import uk.ac.ebi.pride.tools.jmzreader.model.impl.ParamGroup;
import uk.ac.ebi.pride.tools.jmzreader.model.impl.UserParam;
import uk.ac.ebi.pride.tools.mgf_parser.MgfFile;
import uk.ac.ebi.pride.tools.utils.StringUtils;

public class Ms2Query
implements Spectrum {
    private String title;
    private String chargeState;
    private Double tolerance;
    private MgfFile.PeptideToleranceUnit toleranceUnit;
    private List<String> sequenceQualifiers;
    private String composition;
    private List<String> tags;
    private List<String> errorTolerantTags;
    private String scan;
    private String rawScan;
    private String retentionTime;
    private String instrument;
    private String variableModifications;
    private Map<Double, Double> peakList;
    private Double peptideMass;
    private Double peptideIntensity;
    private Integer index;
    private Map<Integer, String> userTags = new HashMap<Integer, String>();
    private final boolean disableCommentSupport;

    public Ms2Query(boolean disableCommentSupport) {
        this.disableCommentSupport = disableCommentSupport;
    }

    public Ms2Query(String mgfQuery, int index, boolean disableCommentSupport) throws JMzReaderException {
        this.disableCommentSupport = disableCommentSupport;
        this.index = index;
        String[] lines = mgfQuery.trim().split("\n");
        boolean inAttributeSection = true;
        for (int nLineNumber = 0; nLineNumber < lines.length; ++nLineNumber) {
            String line = lines[nLineNumber].trim();
            if (!disableCommentSupport) {
                line = line.replaceAll("^[#;!/].*", line);
            }
            if (line.length() < 1) continue;
            if (nLineNumber == 0 && !"BEGIN IONS".equals(StringUtils.removeBOMString(line))) {
                throw new JMzReaderException("MS2 query must start with 'BEGIN IONS'");
            }
            if (nLineNumber == 0) continue;
            if (nLineNumber == lines.length - 1 && !"END IONS".equals(line)) {
                throw new JMzReaderException("MS2 query must end with 'END IONS'");
            }
            if (nLineNumber == lines.length - 1) continue;
            Matcher attributeMatcher = MgfFile.attributePattern.matcher(line);
            boolean matchesAttributePattern = false;
            if (inAttributeSection) {
                matchesAttributePattern = attributeMatcher.find();
            }
            if (matchesAttributePattern) {
                if (attributeMatcher.groupCount() != 2) {
                    throw new JMzReaderException("Invalid attribute line encountered in MS2 query: " + line);
                }
                String name = attributeMatcher.group(1);
                String value = attributeMatcher.group(2);
                this.saveAttribute(name, value);
                continue;
            }
            String cleanedLine = line.replaceAll("\\s+", " ");
            int indexSpace = cleanedLine.indexOf(32);
            if (indexSpace < 0) {
                throw new JMzReaderException("Unable to parse 'mz' and 'intensity' values for " + line);
            }
            String firstHalf = cleanedLine.substring(0, indexSpace);
            String secondHalf = cleanedLine.substring(indexSpace + 1);
            int anotherSpace = secondHalf.indexOf(32);
            Double intensity = anotherSpace < 0 ? Double.valueOf(Double.parseDouble(secondHalf)) : StringUtils.smartParseDouble(secondHalf.substring(0, anotherSpace));
            this.addPeak(Double.parseDouble(firstHalf), intensity);
            inAttributeSection = false;
        }
    }

    private void saveAttribute(String name, String value) {
        if ("TITLE".equals(name)) {
            this.title = value;
        } else if ("CHARGE".equals(name)) {
            this.chargeState = value;
        } else if ("TOL".equals(name)) {
            this.tolerance = Double.parseDouble(value);
        } else if ("TOLU".equals(value)) {
            if ("%".equals(value)) {
                this.toleranceUnit = MgfFile.PeptideToleranceUnit.PERCENT;
            }
            if ("ppm".equals(value)) {
                this.toleranceUnit = MgfFile.PeptideToleranceUnit.PPM;
            }
            if ("mmu".equals(value)) {
                this.toleranceUnit = MgfFile.PeptideToleranceUnit.MMU;
            }
            if ("Da".equals(value)) {
                this.toleranceUnit = MgfFile.PeptideToleranceUnit.DA;
            }
            if (this.toleranceUnit == null) {
                throw new IllegalStateException("Invalid tolerance unit set.");
            }
        } else if ("SEQ".equals(name)) {
            this.addSequenceQualifier(value);
        } else if ("COMP".equals(name)) {
            this.composition = value;
        } else if ("TAG".equals(name)) {
            this.addTag(value);
        } else if ("ETAG".equals(name)) {
            this.addETag(value);
        } else if ("SCANS".equals(name)) {
            this.scan = value;
        } else if ("RAWSCANS".equals(name)) {
            this.rawScan = value;
        } else if ("RTINSECONDS".equals(name)) {
            this.retentionTime = value;
        } else if ("INSTRUMENT".equals(name)) {
            this.instrument = value;
        } else if ("IT_MODS".equals(name)) {
            this.variableModifications = value;
        } else if ("PEPMASS".equals(name)) {
            if (value.trim().split("\\s+").length > 1) {
                String[] parts = value.trim().split("\\s+");
                this.peptideMass = Double.parseDouble(parts[0]);
                this.peptideIntensity = Double.parseDouble(parts[1]);
            } else {
                this.peptideMass = Double.parseDouble(value);
            }
        } else if (name != null && name.startsWith("USER")) {
            Integer index = Integer.parseInt(name.substring("USER".length()));
            this.userTags.put(index, value);
        }
    }

    public void addPeak(Double mz, Double intensity) {
        if (this.peakList == null) {
            this.peakList = new HashMap<Double, Double>(1);
        }
        this.peakList.put(mz, intensity);
    }

    public void addSequenceQualifier(String sequenceQualifier) {
        if (this.sequenceQualifiers == null) {
            this.sequenceQualifiers = new ArrayList<String>();
        }
        this.sequenceQualifiers.add(sequenceQualifier);
    }

    public void addTag(String tag) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tag);
    }

    public void addETag(String errorTolerantTag) {
        this.addErrorTag(errorTolerantTag);
    }

    public void addErrorTag(String errorTolerantTag) {
        if (this.errorTolerantTags == null) {
            this.errorTolerantTags = new ArrayList<String>();
        }
        this.errorTolerantTags.add(errorTolerantTag);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getChargeState() {
        return this.chargeState;
    }

    public void setChargeState(String chargeState) {
        this.chargeState = chargeState;
    }

    public Double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(Double tolerance) {
        this.tolerance = tolerance;
    }

    public MgfFile.PeptideToleranceUnit getToleranceUnit() {
        return this.toleranceUnit;
    }

    public void setToleranceUnit(MgfFile.PeptideToleranceUnit toleranceUnit) {
        this.toleranceUnit = toleranceUnit;
    }

    public String getComposition() {
        return this.composition;
    }

    public void setComposition(String composition) {
        this.composition = composition;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public String getRetentionTime() {
        return this.retentionTime;
    }

    public void setRetentionTime(String retentionTime) {
        this.retentionTime = retentionTime;
    }

    public String getInstrument() {
        return this.instrument;
    }

    public void setInstrument(String instrument) {
        this.instrument = instrument;
    }

    public List<String> getSequenceQualifiers() {
        return this.sequenceQualifiers;
    }

    public void setSequenceQualifiers(List<String> sequenceQualifiers) {
        this.sequenceQualifiers = sequenceQualifiers;
    }

    public List<String> getErrorTolerantTags() {
        return this.errorTolerantTags;
    }

    public void setErrorTolerantTags(List<String> errorTolerantTags) {
        this.errorTolerantTags = errorTolerantTags;
    }

    public String getScan() {
        return this.scan;
    }

    public void setScan(String scan) {
        this.scan = scan;
    }

    public String getVariableModifications() {
        return this.variableModifications;
    }

    public void setVariableModifications(String variableModifications) {
        this.variableModifications = variableModifications;
    }

    @Override
    public Map<Double, Double> getPeakList() {
        return this.peakList;
    }

    public void setPeakList(Map<Double, Double> peakList) {
        this.peakList = peakList;
    }

    public Double getPeptideMass() {
        return this.peptideMass;
    }

    public void setPeptideMass(Double peptideMass) {
        this.peptideMass = peptideMass;
    }

    public Double getPeptideIntensity() {
        return this.peptideIntensity;
    }

    public void setPeptideIntensity(Double peptideIntensity) {
        this.peptideIntensity = peptideIntensity;
    }

    public Map<Integer, String> getUserTags() {
        return this.userTags;
    }

    public void setUserTags(Map<Integer, String> userTags) {
        this.userTags = userTags;
    }

    public String toString() {
        StringBuilder query = new StringBuilder("BEGIN IONS\n");
        if (this.chargeState != null) {
            query.append("CHARGE=").append(this.chargeState).append('\n');
        }
        if (this.composition != null) {
            query.append("COMP=").append(this.composition).append('\n');
        }
        if (this.errorTolerantTags != null && this.errorTolerantTags.size() > 0) {
            for (String tag : this.errorTolerantTags) {
                query.append("ETAG=").append(tag).append('\n');
            }
        }
        if (this.instrument != null) {
            query.append("INSTRUMENT=").append(this.instrument).append('\n');
        }
        if (this.variableModifications != null) {
            query.append("IT_MODS=").append(this.variableModifications).append('\n');
        }
        if (this.peptideMass != null) {
            query.append("PEPMASS=").append(this.peptideMass).append('\n');
        }
        if (this.retentionTime != null) {
            query.append("RTINSECONDS=").append(this.retentionTime).append('\n');
        }
        if (this.scan != null) {
            query.append("SCANS=").append(this.scan).append('\n');
        }
        if (this.sequenceQualifiers != null) {
            for (String qual : this.sequenceQualifiers) {
                query.append("SEQ=").append(qual).append('\n');
            }
        }
        if (this.tags != null) {
            for (String tag : this.tags) {
                query.append("TAG=").append(tag).append('\n');
            }
        }
        if (this.title != null) {
            query.append("TITLE=").append(this.title).append('\n');
        }
        if (this.tolerance != null) {
            query.append("TOL=").append(this.tolerance).append('\n');
        }
        if (this.toleranceUnit != null) {
            query.append("TOLU=").append((Object)this.toleranceUnit).append('\n');
        }
        ArrayList<Double> masses = new ArrayList<Double>(this.peakList.keySet());
        Collections.sort(masses);
        for (Double mz : masses) {
            query.append(mz).append(' ').append(this.peakList.get(mz)).append('\n');
        }
        query.append("END IONS\n");
        return query.toString();
    }

    @Override
    public String getId() {
        String result = null;
        if (this.index != null) {
            result = this.index.toString();
        }
        return result;
    }

    @Override
    public Integer getPrecursorCharge() {
        Integer result = null;
        if (!(this.chargeState == null || this.chargeState.isEmpty() || this.chargeState.contains(",") || this.chargeState.contains("and"))) {
            String modifiedChargeState = this.chargeState;
            if (modifiedChargeState.contains(".")) {
                modifiedChargeState = modifiedChargeState.substring(0, modifiedChargeState.indexOf("."));
            }
            if (modifiedChargeState.contains("+")) {
                modifiedChargeState = modifiedChargeState.replace("+", "");
            }
            if (StringUtils.isInteger(modifiedChargeState)) {
                result = Integer.parseInt(modifiedChargeState);
            } else {
                throw new NumberFormatException("Unable to parse chargeState: " + this.chargeState);
            }
        }
        return result;
    }

    @Override
    public Double getPrecursorMZ() {
        return this.peptideMass;
    }

    @Override
    public Double getPrecursorIntensity() {
        return this.peptideIntensity;
    }

    @Override
    public Integer getMsLevel() {
        return 2;
    }

    @Override
    public ParamGroup getAdditional() {
        ParamGroup paramGroup = new ParamGroup();
        if (this.retentionTime != null) {
            paramGroup.addParam(new CvParam("retention time", this.retentionTime, "MS", "MS:1000894"));
        }
        if (this.scan != null) {
            paramGroup.addParam(new CvParam("peak list scans", this.scan, "MS", "MS:1000797"));
        }
        if (this.title != null) {
            paramGroup.addParam(new CvParam("spectrum title", this.title, "MS", "MS:1000796"));
        }
        if (this.tolerance != null) {
            paramGroup.addParam(new CvParam("Fragment mass tolerance setting", this.tolerance.toString(), "PRIDE", "PRIDE:0000161"));
        }
        if (this.toleranceUnit != null) {
            paramGroup.addParam(new UserParam("Fragment mass tolerance unit", this.toleranceUnit.toString()));
        }
        if (this.instrument != null) {
            paramGroup.addParam(new UserParam("Instrument", this.instrument));
        }
        if (this.sequenceQualifiers != null && this.sequenceQualifiers.size() == 1) {
            paramGroup.addParam(new UserParam("Sequence", this.sequenceQualifiers.get(0)));
        }
        for (Map.Entry<Integer, String> integerStringEntry : this.userTags.entrySet()) {
            String userIndexString = String.valueOf(integerStringEntry.getKey());
            if (integerStringEntry.getKey() < 10) {
                userIndexString = '0' + userIndexString;
            }
            paramGroup.addParam(new UserParam("USER" + userIndexString, integerStringEntry.getValue()));
        }
        return paramGroup;
    }
}

