/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.tools.mzxml_parser.mzxml.unmarshaller;

import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.sax.SAXSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import uk.ac.ebi.pride.tools.mzxml_parser.mzxml.model.MzXMLObject;
import uk.ac.ebi.pride.tools.mzxml_parser.mzxml.model.MzXmlElement;
import uk.ac.ebi.pride.tools.mzxml_parser.mzxml.unmarshaller.MzXMLUnmarshaller;

public class MzXMLUnmarshallerFactory {
    private static final Logger logger = LoggerFactory.getLogger(MzXMLUnmarshallerFactory.class);
    private static MzXMLUnmarshallerFactory instance = new MzXMLUnmarshallerFactory();
    private static JAXBContext jc = null;

    private MzXMLUnmarshallerFactory() {
    }

    public static MzXMLUnmarshallerFactory getInstance() {
        return instance;
    }

    public MzXMLUnmarshaller initializeUnmarshaller() {
        try {
            if (jc == null) {
                jc = JAXBContext.newInstance("uk.ac.ebi.pride.tools.mzxml_parser.mzxml.model");
            }
            MzXMLUnmarshallerImpl pum = new MzXMLUnmarshallerImpl();
            logger.debug("Unmarshaller Initialized");
            return pum;
        }
        catch (JAXBException e) {
            logger.error("UnmarshallerFactory.initializeUnmarshaller", e);
            throw new IllegalStateException("Could not initialize unmarshaller", e);
        }
    }

    static /* synthetic */ JAXBContext access$100() {
        return jc;
    }

    private class MzXMLUnmarshallerImpl
    implements MzXMLUnmarshaller {
        private Unmarshaller unmarshaller = MzXMLUnmarshallerFactory.access$100().createUnmarshaller();

        private MzXMLUnmarshallerImpl() throws JAXBException {
        }

        @Override
        public synchronized <T extends MzXMLObject> T unmarshal(String xmlSnippet, MzXmlElement element) throws Exception {
            MzXMLObject retval;
            try {
                if (xmlSnippet == null || element == null) {
                    return null;
                }
                JAXBElement holder = this.unmarshaller.unmarshal(new SAXSource(new InputSource(new StringReader(xmlSnippet))), element.getClassType());
                retval = (MzXMLObject)holder.getValue();
            }
            catch (JAXBException e) {
                throw new Exception("Error unmarshalling object: " + e.getMessage(), e);
            }
            return (T)retval;
        }
    }
}

