/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.tools.pride_wrapper;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import uk.ac.ebi.pride.jaxb.model.AcqSpecification;
import uk.ac.ebi.pride.jaxb.model.Data;
import uk.ac.ebi.pride.jaxb.model.Precursor;
import uk.ac.ebi.pride.jaxb.model.Spectrum;
import uk.ac.ebi.pride.jaxb.model.SpectrumDesc;
import uk.ac.ebi.pride.jaxb.model.SpectrumInstrument;
import uk.ac.ebi.pride.jaxb.model.SpectrumSettings;
import uk.ac.ebi.pride.jaxb.xml.PrideXmlReader;
import uk.ac.ebi.pride.tools.jmzreader.JMzReader;
import uk.ac.ebi.pride.tools.jmzreader.JMzReaderException;
import uk.ac.ebi.pride.tools.jmzreader.model.IndexElement;
import uk.ac.ebi.pride.tools.jmzreader.model.impl.CvParam;
import uk.ac.ebi.pride.tools.jmzreader.model.impl.IndexElementImpl;
import uk.ac.ebi.pride.tools.jmzreader.model.impl.ParamGroup;
import uk.ac.ebi.pride.tools.jmzreader.model.impl.UserParam;

public class PRIDEXmlWrapper
implements JMzReader {
    private PrideXmlReader prideXmlReader;
    private List<String> spectrumIds;
    private Map<String, IndexElement> spectrumIndices;
    private Map<Integer, List<IndexElement>> msLevelIndices;

    public PRIDEXmlWrapper(File file) {
        this.prideXmlReader = new PrideXmlReader(file);
        this.spectrumIds = new ArrayList<String>(this.prideXmlReader.getSpectrumIds());
        this.convertIndices(this.prideXmlReader.getSpectrumIndices());
    }

    private void convertIndices(Map<String, psidev.psi.tools.xxindex.index.IndexElement> rawIndices) {
        this.spectrumIndices = new HashMap<String, IndexElement>();
        this.msLevelIndices = new HashMap<Integer, List<IndexElement>>();
        for (Map.Entry<String, psidev.psi.tools.xxindex.index.IndexElement> rawIndex : rawIndices.entrySet()) {
            psidev.psi.tools.xxindex.index.IndexElement rawIndexElement = rawIndex.getValue();
            long start = rawIndexElement.getStart();
            int size = (int)(rawIndexElement.getStop() - rawIndexElement.getStart());
            IndexElementImpl indexElement = new IndexElementImpl(start, size);
            this.spectrumIndices.put(rawIndex.getKey(), indexElement);
            int msLevel = this.prideXmlReader.getSpectrumMsLevel(rawIndex.getKey());
            List msLevelIndexElements = this.msLevelIndices.computeIfAbsent(msLevel, k -> new ArrayList());
            msLevelIndexElements.add(indexElement);
        }
    }

    @Override
    public int getSpectraCount() {
        return this.prideXmlReader.getSpectrumIds().size();
    }

    @Override
    public boolean acceptsFile() {
        return true;
    }

    @Override
    public boolean acceptsDirectory() {
        return false;
    }

    @Override
    public List<String> getSpectraIds() {
        return new ArrayList<String>(this.spectrumIds);
    }

    @Override
    public uk.ac.ebi.pride.tools.jmzreader.model.Spectrum getSpectrumById(String id) {
        Spectrum prideSpectrum = this.prideXmlReader.getSpectrumById(id);
        return new PRIDEXmlSpectrumWrapper(prideSpectrum);
    }

    @Override
    public uk.ac.ebi.pride.tools.jmzreader.model.Spectrum getSpectrumByIndex(int index) throws JMzReaderException {
        if (index < 1 || index > this.prideXmlReader.getSpectrumIds().size()) {
            throw new JMzReaderException("Index out of range.");
        }
        String spectrumId = this.spectrumIds.get(index);
        return this.getSpectrumById(spectrumId);
    }

    @Override
    public Iterator<uk.ac.ebi.pride.tools.jmzreader.model.Spectrum> getSpectrumIterator() {
        return new PRIDEXmlSpectrumIterator();
    }

    @Override
    public List<IndexElement> getMsNIndexes(int msLevel) {
        return new ArrayList<IndexElement>((Collection)this.msLevelIndices.get(msLevel));
    }

    @Override
    public List<Integer> getMsLevels() {
        return new ArrayList<Integer>(this.msLevelIndices.keySet());
    }

    @Override
    public Map<String, IndexElement> getIndexElementForIds() {
        return new HashMap<String, IndexElement>(this.spectrumIndices);
    }

    private static class PRIDEXmlSpectrumWrapper
    implements uk.ac.ebi.pride.tools.jmzreader.model.Spectrum {
        private Spectrum prideSpectrum;
        private Integer precursorCharge = null;
        private Double precursorMz = null;
        private Double precursorIntensity = null;
        private Map<Double, Double> peakList;
        private int msLevel;
        private Integer id;
        private ParamGroup paramGroup;

        private PRIDEXmlSpectrumWrapper(Spectrum prideSpectrum) {
            this.prideSpectrum = prideSpectrum;
            this.id = prideSpectrum.getId();
            this.msLevel = prideSpectrum.getSpectrumDesc().getSpectrumSettings().getSpectrumInstrument().getMsLevel();
            this.extractPrecursorInformation();
            this.extractPeakList();
            this.extractAdditional();
        }

        private void extractPrecursorInformation() {
            if (this.prideSpectrum.getSpectrumDesc().getPrecursorList() == null || this.prideSpectrum.getSpectrumDesc().getPrecursorList().getCount() == 0) {
                return;
            }
            Precursor precursor = this.prideSpectrum.getSpectrumDesc().getPrecursorList().getPrecursor().get(0);
            for (uk.ac.ebi.pride.jaxb.model.CvParam cvParam : precursor.getIonSelection().getCvParam()) {
                String accession = cvParam.getAccession();
                String value = cvParam.getValue();
                if ("PSI:1000040".equals(accession) || "MS:1000744".equals(accession)) {
                    this.precursorMz = Double.parseDouble(value);
                }
                if ("PSI:1000041".equals(accession) || "MS:1000041".equals(accession)) {
                    this.precursorCharge = Integer.parseInt(value);
                }
                if (!"PSI:1000042".equals(accession) && !"MS:1000042".equals(accession)) continue;
                this.precursorIntensity = Double.parseDouble(value);
            }
        }

        private void extractPeakList() {
            int i;
            Data mzData = this.prideSpectrum.getMzArrayBinary().getData();
            Data intenData = this.prideSpectrum.getIntenArrayBinary().getData();
            ByteBuffer mzBuffer = ByteBuffer.wrap(mzData.getValue());
            ByteBuffer intenBuffer = ByteBuffer.wrap(intenData.getValue());
            if (mzData.getEndian().equalsIgnoreCase("little")) {
                mzBuffer.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                mzBuffer.order(ByteOrder.BIG_ENDIAN);
            }
            if (intenData.getEndian().equalsIgnoreCase("little")) {
                intenBuffer.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                intenBuffer.order(ByteOrder.BIG_ENDIAN);
            }
            ArrayList<Double> mz = new ArrayList<Double>();
            ArrayList<Double> inten = new ArrayList<Double>();
            int size = mzData.getPrecision().equals("32") ? 4 : 8;
            for (i = 0; i < mzBuffer.limit(); i += size) {
                mz.add(size == 4 ? Float.valueOf(mzBuffer.getFloat(i)).doubleValue() : mzBuffer.getDouble(i));
            }
            size = intenData.getPrecision().equals("32") ? 4 : 8;
            for (i = 0; i < intenBuffer.limit(); i += size) {
                inten.add(size == 4 ? Float.valueOf(intenBuffer.getFloat(i)).doubleValue() : intenBuffer.getDouble(i));
            }
            if (inten.size() != mz.size()) {
                throw new IllegalStateException("Different sizes encountered for intensity and m/z array (spectrum id = " + this.id + ')');
            }
            this.peakList = new HashMap<Double, Double>();
            for (i = 0; i < mz.size(); ++i) {
                this.peakList.put((Double)mz.get(i), (Double)inten.get(i));
            }
        }

        private void extractAdditional() {
            List<uk.ac.ebi.pride.jaxb.model.UserParam> rawUserParams;
            List<uk.ac.ebi.pride.jaxb.model.CvParam> rawCvParams;
            this.paramGroup = new ParamGroup();
            SpectrumDesc rawSpecDesc = this.prideSpectrum.getSpectrumDesc();
            SpectrumSettings rawSpecSettings = this.prideSpectrum.getSpectrumDesc().getSpectrumSettings();
            AcqSpecification rawActSpec = rawSpecSettings.getAcqSpecification();
            SpectrumInstrument rawSpecInstrument = rawSpecSettings.getSpectrumInstrument();
            this.paramGroup.addParam(new CvParam("ms level", this.msLevel + "", "MS", "MS:1000449"));
            if (rawActSpec != null) {
                String rawSpecType = rawActSpec.getSpectrumType();
                if ("discrete".equals(rawSpecType)) {
                    this.paramGroup.addParam(new CvParam("centroid spectrum", rawSpecType, "MS", "MS:1000127"));
                } else if ("continuous".equals(rawSpecType)) {
                    this.paramGroup.addParam(new CvParam("profile spectrum", rawSpecType, "MS", "MS:1000128"));
                }
            }
            if ((rawCvParams = rawSpecInstrument.getCvParam()) != null) {
                for (uk.ac.ebi.pride.jaxb.model.CvParam cvParam : rawCvParams) {
                    this.paramGroup.addParam(new CvParam(cvParam.getName(), cvParam.getValue(), cvParam.getCvLabel(), cvParam.getAccession()));
                }
            }
            if ((rawUserParams = rawSpecInstrument.getUserParam()) != null) {
                for (uk.ac.ebi.pride.jaxb.model.UserParam rawUserParam : rawUserParams) {
                    this.paramGroup.addParam(new UserParam(rawUserParam.getName(), rawUserParam.getValue()));
                }
            }
            List<String> list = rawSpecDesc.getComments();
            for (String comment : list) {
                this.paramGroup.addParam(new UserParam("comment", comment));
            }
        }

        @Override
        public String getId() {
            return this.id.toString();
        }

        @Override
        public Integer getPrecursorCharge() {
            return this.precursorCharge;
        }

        @Override
        public Double getPrecursorMZ() {
            return this.precursorMz;
        }

        @Override
        public Double getPrecursorIntensity() {
            return this.precursorIntensity;
        }

        @Override
        public Map<Double, Double> getPeakList() {
            return this.peakList;
        }

        @Override
        public Integer getMsLevel() {
            return this.msLevel;
        }

        @Override
        public ParamGroup getAdditional() {
            return this.paramGroup;
        }
    }

    private class PRIDEXmlSpectrumIterator
    implements Iterator<uk.ac.ebi.pride.tools.jmzreader.model.Spectrum> {
        private final Iterator<String> idIterator;

        private PRIDEXmlSpectrumIterator() {
            this.idIterator = PRIDEXmlWrapper.this.spectrumIds.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.idIterator.hasNext();
        }

        @Override
        public uk.ac.ebi.pride.tools.jmzreader.model.Spectrum next() {
            return PRIDEXmlWrapper.this.getSpectrumById(this.idIterator.next());
        }

        @Override
        public void remove() {
        }
    }
}

