# Copyright (c) 2002-present, OpenMS Inc. -- EKU Tuebingen, ETH Zurich, and FU Berlin
# SPDX-License-Identifier: Apache-2.0
label: AssayGeneratorMetabo
doc: Assay library generation from DDA data (Metabolomics)
inputs:
  in:
    doc: MzML input file(s) used for assay library generation
    type: File[]
  in_featureinfo:
    doc: FeatureXML input file(s) containing identification information (e.g. AccurateMassSearch)
    type: File[]
  out:
    doc: Assay library output file
    type: string
  ambiguity_resolution_mz_tolerance:
    doc: Mz tolerance for the resolution of identification ambiguity over multiple files
    type: double?
  ambiguity_resolution_mz_tolerance_unit:
    doc: Unit of the ambiguity_resolution_mz_tolerance
    type: string?
  ambiguity_resolution_rt_tolerance:
    doc: RT tolerance in seconds for the resolution of identification ambiguity over multiple files
    type: double?
  total_occurrence_filter:
    doc: Filter compound based on total occurrence in analysed samples
    type: double?
  method:
    doc: Spectrum with the highest precursor intensity or a consensus spectrum is used for assay library construction (if no fragment annotation is used).
    type: string?
  exclude_ms2_precursor:
    doc: Excludes precursor in ms2 from transition list
    type: boolean?
  use_known_unknowns:
    doc: Use features without identification information
    type: boolean?
  min_transitions:
    doc: Minimal number of transitions
    type: long?
  max_transitions:
    doc: Maximal number of transitions
    type: long?
  cosine_similarity_threshold:
    doc: Threshold for cosine similarity of MS2 spectra from the same precursor used in consensus spectrum creation
    type: double?
  transition_threshold:
    doc: Further transitions need at least x% of the maximum intensity (default 5%)
    type: double?
  min_fragment_mz:
    doc: Minimal m/z of a fragment ion choosen as a transition
    type: double?
  max_fragment_mz:
    doc: Maximal m/z of a fragment ion choosen as a transition
    type: double?
  precursor_mz_distance:
    doc: Max m/z distance of the precursor entries of two spectra to be merged in [Da].
    type: double?
  precursor_recalibration_window:
    doc: Tolerance window for precursor selection (Annotation of precursor mz and intensity)
    type: double?
  precursor_recalibration_window_unit:
    doc: Unit of the precursor_mz_tolerance_annotation
    type: string?
  precursor_consensus_spectrum_rt_tolerance:
    doc: Tolerance window (left and right) for precursor selection [seconds], for consensus spectrum generation (only available without fragment annotation)
    type: double?
  deisotoping_use_deisotoper:
    doc: Use Deisotoper (if no fragment annotation is used)
    type: boolean?
  deisotoping_fragment_tolerance:
    doc: Tolerance used to match isotopic peaks
    type: double?
  deisotoping_fragment_unit:
    doc: Unit of the fragment tolerance
    type: string?
  deisotoping_min_charge:
    doc: The minimum charge considered
    type: long?
  deisotoping_max_charge:
    doc: The maximum charge considered
    type: long?
  deisotoping_min_isopeaks:
    doc: The minimum number of isotopic peaks (at least 2) required for an isotopic cluster
    type: long?
  deisotoping_max_isopeaks:
    doc: The maximum number of isotopic peaks (at least 2) considered for an isotopic cluster
    type: long?
  deisotoping_keep_only_deisotoped:
    doc: Only monoisotopic peaks of fragments with isotopic pattern are retained
    type: boolean?
  deisotoping_annotate_charge:
    doc: Annotate the charge to the peaks
    type: boolean?
  filter_by_num_masstraces:
    doc: Number of mass traces each feature has to have to be included. To use this parameter, setting the feature_only flag is necessary
    type: long?
  precursor_mz_tolerance:
    doc: Tolerance window for precursor selection (Feature selection in regard to the precursor)
    type: double?
  precursor_mz_tolerance_unit:
    doc: Unit of the preprocessing_precursor_mz_tolerance
    type: string?
  precursor_rt_tolerance:
    doc: Tolerance window (left and right) for precursor selection [seconds]
    type: double?
  feature_only:
    doc: Uses the feature information from in_featureinfo to reduce the search space to MS2 associated with a feature
    type: string?
  log:
    doc: Name of log file (created only when specified)
    type: string?
  debug:
    doc: Sets the debug level
    type: long?
  threads:
    doc: Sets the number of threads allowed to be used by the TOPP tool
    type: long?
  no_progress:
    doc: Disables progress logging to command line
    type: boolean?
  force:
    doc: Overrides tool-specific checks
    type: boolean?
  test:
    doc: Enables the test mode (needed for internal use only)
    type: boolean?
outputs:
  out:
    type: File
    outputBinding:
      glob: $(inputs.out)
cwlVersion: v1.2
class: CommandLineTool
baseCommand:
  - AssayGeneratorMetabo
requirements:
  InlineJavascriptRequirement: {}
  InitialWorkDirRequirement:
    listing:
      - entryname: cwl_inputs.json
        entry: $(JSON.stringify(inputs))
arguments:
  - -ini
  - cwl_inputs.json
