# Copyright (c) 2002-present, OpenMS Inc. -- EKU Tuebingen, ETH Zurich, and FU Berlin
# SPDX-License-Identifier: Apache-2.0
label: AssayGeneratorMetaboSirius
doc: Assay library generation from a SIRIUS project directory (Metabolomics)
inputs:
  in:
    doc: SIRIUS project directory
    type: File
  in_compoundinfo:
    doc: Compound info table (.tsv file)
    type: File
  out:
    doc: Assay library output file
    type: string
  ambiguity_resolution_mz_tolerance:
    doc: Mz tolerance for the resolution of identification ambiguity over multiple files
    type: double?
  ambiguity_resolution_mz_tolerance_unit:
    doc: Unit of the ambiguity_resolution_mz_tolerance
    type: string?
  ambiguity_resolution_rt_tolerance:
    doc: RT tolerance in seconds for the resolution of identification ambiguity over multiple files
    type: double?
  total_occurrence_filter:
    doc: Filter compound based on total occurrence in analysed samples
    type: double?
  fragment_annotation_score_threshold:
    doc: Filters annotations based on the explained intensity of the peaks in a spectrum
    type: double?
  method:
    doc: Spectrum with the highest precursor intensity or a consensus spectrum is used for assay library construction (if no fragment annotation is used).
    type: string?
  use_exact_mass:
    doc: Use exact mass for precursor and fragment annotations
    type: boolean?
  exclude_ms2_precursor:
    doc: Excludes precursor in ms2 from transition list
    type: boolean?
  use_known_unknowns:
    doc: Use features without identification information
    type: boolean?
  min_transitions:
    doc: Minimal number of transitions
    type: long?
  max_transitions:
    doc: Maximal number of transitions
    type: long?
  transition_threshold:
    doc: Further transitions need at least x% of the maximum intensity (default 5%)
    type: double?
  min_fragment_mz:
    doc: Minimal m/z of a fragment ion choosen as a transition
    type: double?
  max_fragment_mz:
    doc: Maximal m/z of a fragment ion choosen as a transition
    type: double?
  decoy_generation:
    doc: Decoys will be generated using the fragmentation tree re-rooting approach. This option does only work in combination with the fragment annotation via Sirius.
    type: boolean?
  decoy_generation_method:
    doc: Uses different methods for decoy generation. Basis for the method is the fragmentation-tree re-rooting approach ('original'). This approach can be extended by using 'resolve_overlap', which will resolve overlapping target/decoy fragments by adding -CH2 mass to the overlapping decoy fragments. 'generate_missing_decoys' will add a -CH2 mass shift to the target fragments and use them as decoys if fragmentation-tree re-rooting failed. 'Both' combines the extended methods (resolve_overlap, generate_missing_decoys).
    type: string?
  decoy_resolution_mz_tolerance:
    doc: Mz tolerance for the resolution of overlapping m/z values for targets and decoys of one compound.
    type: double?
  decoy_resolution_mz_tolerance_unit:
    doc: Unit of the decoy_resolution_mz_tolerance
    type: string?
  log:
    doc: Name of log file (created only when specified)
    type: string?
  debug:
    doc: Sets the debug level
    type: long?
  threads:
    doc: Sets the number of threads allowed to be used by the TOPP tool
    type: long?
  no_progress:
    doc: Disables progress logging to command line
    type: boolean?
  force:
    doc: Overrides tool-specific checks
    type: boolean?
  test:
    doc: Enables the test mode (needed for internal use only)
    type: boolean?
outputs:
  out:
    type: File
    outputBinding:
      glob: $(inputs.out)
cwlVersion: v1.2
class: CommandLineTool
baseCommand:
  - AssayGeneratorMetaboSirius
requirements:
  InlineJavascriptRequirement: {}
  InitialWorkDirRequirement:
    listing:
      - entryname: cwl_inputs.json
        entry: $(JSON.stringify(inputs))
arguments:
  - -ini
  - cwl_inputs.json
