set(OpenMS_sources  CACHE INTERNAL "This variable should hold all OpenMS sources at the end of the config step" )

## ATTENTION: The order of includes should be similar to the inclusion hierarchy
include(source/INTERFACES_IMPL/sources.cmake)
include(source/CONCEPT/sources.cmake)
include(source/SYSTEM/sources.cmake)
include(source/MATH/sources.cmake)
include(source/MATH/STATISTICS/sources.cmake)
include(source/MATH/MISC/sources.cmake)
include(source/ML/sources.cmake)
include(source/ML/NNLS/sources.cmake)
include(source/ML/SVM/sources.cmake)
include(source/ML/CLUSTERING/sources.cmake)
include(source/ML/GRIDSEARCH/sources.cmake)
include(source/ML/INTERPOLATION/sources.cmake)
include(source/ML/ROCCURVE/sources.cmake)
include(source/ML/RANSAC/sources.cmake)
include(source/ML/REGRESSION/sources.cmake)
include(source/DATASTRUCTURES/sources.cmake)
include(source/METADATA/sources.cmake)
include(source/METADATA/ID/sources.cmake)
include(source/KERNEL/sources.cmake)
include(source/CHEMISTRY/sources.cmake)
include(source/CHEMISTRY/ISOTOPEDISTRIBUTION/sources.cmake)
include(source/CHEMISTRY/MASSDECOMPOSITION/IMS/sources.cmake)
include(source/CHEMISTRY/MASSDECOMPOSITION/sources.cmake)
include(source/FORMAT/DATAACCESS/sources.cmake)
include(source/FORMAT/HANDLERS/sources.cmake)
include(source/FORMAT/MSNUMPRESS/sources.cmake)
include(source/FORMAT/VALIDATORS/sources.cmake)
include(source/FORMAT/OPTIONS/sources.cmake)
include(source/FORMAT/sources.cmake)
include(source/IONMOBILITY/sources.cmake)
include(source/ANALYSIS/QUANTITATION/sources.cmake)
include(source/ANALYSIS/SEQUENCE/sources.cmake)
include(source/ANALYSIS/MAPMATCHING/sources.cmake)
include(source/ANALYSIS/DECHARGING/sources.cmake)
include(source/ANALYSIS/ID/sources.cmake)
include(source/ANALYSIS/MRM/sources.cmake)
include(source/ANALYSIS/TARGETED/sources.cmake)
include(source/ANALYSIS/TOPDOWN/sources.cmake)
include(source/ANALYSIS/XLMS/sources.cmake)

include(source/PROCESSING/BASELINE/sources.cmake)
include(source/PROCESSING/FILTERING/sources.cmake)
include(source/PROCESSING/RESAMPLING/sources.cmake)
include(source/PROCESSING/MISC/sources.cmake)
include(source/PROCESSING/DEISOTOPING/sources.cmake)
include(source/PROCESSING/CALIBRATION/sources.cmake)
include(source/PROCESSING/FEATURE/sources.cmake)
include(source/PROCESSING/SMOOTHING/sources.cmake)
include(source/PROCESSING/NOISEESTIMATION/sources.cmake)
include(source/PROCESSING/ID/sources.cmake)
include(source/PROCESSING/CENTROIDING/sources.cmake)
include(source/PROCESSING/SPECTRAMERGING/sources.cmake)
include(source/PROCESSING/SCALING/sources.cmake)

include(source/FEATUREFINDER/sources.cmake)
include(source/COMPARISON/sources.cmake)
include(source/QC/sources.cmake)
if(NOT DISABLE_OPENSWATH)
  include(source/ANALYSIS/OPENSWATH/sources.cmake)
  include(source/ANALYSIS/OPENSWATH/DATAACCESS/sources.cmake)
endif(NOT DISABLE_OPENSWATH)
include(source/APPLICATIONS/sources.cmake)

set(OpenMS_sources_h  CACHE INTERNAL "This variable should hold all OpenMS sources at the end of the config step" )

## ATTENTION: The order of includes should be similar to the inclusion hierarchy
include(include/OpenMS/INTERFACES/sources.cmake)
include(include/OpenMS/CONCEPT/sources.cmake)
include(include/OpenMS/SYSTEM/sources.cmake)
include(include/OpenMS/MATH/MISC/sources.cmake)
include(include/OpenMS/ML/INTERPOLATION/sources.cmake)
include(include/OpenMS/ML/NNLS/sources.cmake)
include(include/OpenMS/ML/SVM/sources.cmake)
include(include/OpenMS/ML/RANSAC/sources.cmake)
include(include/OpenMS/ML/REGRESSION/sources.cmake)
include(include/OpenMS/MATH/sources.cmake)
include(include/OpenMS/MATH/STATISTICS/sources.cmake)
include(include/OpenMS/DATASTRUCTURES/sources.cmake)
include(include/OpenMS/DATASTRUCTURES/Utils/sources.cmake)
include(include/OpenMS/METADATA/sources.cmake)
include(include/OpenMS/METADATA/ID/sources.cmake)
include(include/OpenMS/KERNEL/sources.cmake)
include(include/OpenMS/CHEMISTRY/sources.cmake)
include(include/OpenMS/CHEMISTRY/ISOTOPEDISTRIBUTION/sources.cmake)
include(include/OpenMS/CHEMISTRY/MASSDECOMPOSITION/IMS/sources.cmake)
include(include/OpenMS/CHEMISTRY/MASSDECOMPOSITION/sources.cmake)
include(include/OpenMS/FORMAT/sources.cmake)
include(include/OpenMS/FORMAT/DATAACCESS/sources.cmake)
include(include/OpenMS/FORMAT/HANDLERS/sources.cmake)
include(include/OpenMS/FORMAT/MSNUMPRESS/sources.cmake)
include(include/OpenMS/FORMAT/VALIDATORS/sources.cmake)
include(include/OpenMS/FORMAT/OPTIONS/sources.cmake)
include(include/OpenMS/IONMOBILITY/sources.cmake)

include(include/OpenMS/ANALYSIS/DECHARGING/sources.cmake)
include(include/OpenMS/ANALYSIS/ID/sources.cmake)
include(include/OpenMS/ANALYSIS/MAPMATCHING/sources.cmake)
include(include/OpenMS/ANALYSIS/QUANTITATION/sources.cmake)
include(include/OpenMS/ANALYSIS/SEQUENCE/sources.cmake)
include(include/OpenMS/ANALYSIS/MRM/sources.cmake)
include(include/OpenMS/ANALYSIS/TARGETED/sources.cmake)
include(include/OpenMS/ANALYSIS/TOPDOWN/sources.cmake)
include(include/OpenMS/ANALYSIS/XLMS/sources.cmake)

include(include/OpenMS/ML/CLUSTERING/sources.cmake)
include(include/OpenMS/ML/GRIDSEARCH/sources.cmake)
include(include/OpenMS/ML/ROCCURVE/sources.cmake)

include(include/OpenMS/COMPARISON/sources.cmake)

include(include/OpenMS/PROCESSING/BASELINE/sources.cmake)
include(include/OpenMS/PROCESSING/CALIBRATION/sources.cmake)
include(include/OpenMS/PROCESSING/MISC/sources.cmake)
include(include/OpenMS/PROCESSING/DEISOTOPING/sources.cmake)
include(include/OpenMS/PROCESSING/ID/sources.cmake)
include(include/OpenMS/PROCESSING/FEATURE/sources.cmake)
include(include/OpenMS/PROCESSING/NOISEESTIMATION/sources.cmake)
include(include/OpenMS/PROCESSING/SMOOTHING/sources.cmake)
include(include/OpenMS/PROCESSING/FILTERING/sources.cmake)
include(include/OpenMS/PROCESSING/RESAMPLING/sources.cmake)
include(include/OpenMS/PROCESSING/SCALING/sources.cmake)

include(include/OpenMS/FEATUREFINDER/sources.cmake)
include(include/OpenMS/PROCESSING/CENTROIDING/sources.cmake)
include(include/OpenMS/PROCESSING/SPECTRAMERGING/sources.cmake)

include(include/OpenMS/QC/sources.cmake)
if(NOT DISABLE_OPENSWATH)
  include(include/OpenMS/ANALYSIS/OPENSWATH/sources.cmake)
  include(include/OpenMS/ANALYSIS/OPENSWATH/DATAACCESS/sources.cmake)
endif(NOT DISABLE_OPENSWATH)
include(include/OpenMS/APPLICATIONS/sources.cmake)

## add configured config.h&Co to source group
source_group("Header Files\\OpenMS" FILES ${OpenMS_configured_headers})
## merge all headers to sources (for source group view in VS)
list(APPEND OpenMS_sources ${OpenMS_sources_h} ${OpenMS_configured_headers})

# TODO track why the duplicate warnings are thrown for all (!) MOC sources
# Macro problem?
list(REMOVE_DUPLICATES OpenMS_sources)
