### the directory name
set(directory source/APPLICATIONS/TOPP)

### list all filenames of the directory here
set(TOPP_executables
AccurateMassSearch
AssayGeneratorMetabo
AssayGeneratorMetaboSirius
BaselineFilter
ClusterMassTraces
ClusterMassTracesByPrecursor
CometAdapter
ConsensusID
ConsensusMapNormalizer
CVInspector
DatabaseFilter
DatabaseSuitability
DecoyDatabase
Decharger
DeMeanderize
Digestor
DigestorMotif
DTAExtractor
EICExtractor
Epifany
ExternalCalibration
FalseDiscoveryRate
FeatureFinderCentroided
FeatureFinderIdentification
FeatureFinderMetabo
FeatureFinderMetaboIdent
FeatureFinderMultiplex
FeatureLinkerLabeled
FeatureLinkerUnlabeled
FeatureLinkerUnlabeledKD
FeatureLinkerUnlabeledQT
FileConverter
FileFilter
FileInfo
FileMerger
FLASHDeconv
FuzzyDiff
GenericWrapper
GNPSExport
HighResPrecursorMassCorrector
IDConflictResolver
IDDecoyProbability
IDExtractor
IDFileConverter
IDFilter
IDMapper
IDMassAccuracy
IDMerger
IDPosteriorErrorProbability
IDRipper
IDRTCalibration
IDScoreSwitcher
IDSplitter
InternalCalibration
IonMobilityBinning
IsobaricAnalyzer
JSONExporter
LuciphorAdapter
MapAlignerIdentification
MapAlignerPoseClustering
MapAlignerTreeGuided
MapNormalizer
MapRTTransformer
MapStatistics
MaRaClusterAdapter
MascotAdapter
MascotAdapterOnline
MassCalculator
MassTraceExtractor
MetaboliteAdductDecharger
MetaboliteSpectralMatcher
MetaProSIP
MRMMapper
MRMPairFinder
MSGFPlusAdapter
MSFraggerAdapter
MSstatsConverter
MultiplexResolver
MzMLSplitter
MzTabExporter
NoiseFilterGaussian
NoiseFilterSGolay
NovorAdapter
NucleicAcidSearchEngine
OpenMSDatabasesInfo
OpenMSInfo
OpenPepXL
OpenPepXLLF
OpenSwathAnalyzer
OpenSwathAssayGenerator
OpenSwathChromatogramExtractor
OpenSwathConfidenceScoring
OpenSwathDecoyGenerator
OpenSwathFeatureXMLToTSV
OpenSwathRTNormalizer
PeakPickerHiRes
PeakPickerIterative
PeptideIndexer
PercolatorAdapter
PhosphoScoring
ProteinInference
ProteinQuantifier
ProteomicsLFQ
PSMFeatureExtractor
QCCalculator
QCEmbedder
QCExporter
QCExtractor
QCImporter
QCMerger
QCShrinker
QualityControl
RNADigestor
RNAMassCalculator
RNPxlXICFilter
SageAdapter
SeedListGenerator
SemanticValidator
SequenceCoverageCalculator
SimpleSearchEngine
SiriusExport
SpecLibCreator
SpecLibSearcher
SpectraFilterNLargest
SpectraFilterNormalizer
SpectraFilterThresholdMower
SpectraFilterWindowMower
SpectraMerger
SpectraSTSearchAdapter
StaticModification
TICCalculator
TextExporter
TriqlerConverter
XFDR
XTandemAdapter
XMLValidator
)

if(NOT DISABLE_OPENSWATH)
  set(TOPP_executables
    ${TOPP_executables}
    TargetedFileConverter
    OpenSwathDIAPreScoring
    OpenSwathMzMLFileCacher
    OpenSwathWorkflow
    OpenSwathFileSplitter
    OpenSwathRewriteToFeatureXML
    MRMTransitionGroupPicker
  )
endif(NOT DISABLE_OPENSWATH)

## all targets requiring OpenMS_GUI
set(TOPP_executables_with_GUIlib
ExecutePipeline
Resampler
# util category
ImageCreator
INIUpdater
)

### add filenames to Visual Studio solution tree
set(sources_VS)
foreach(i ${TOPP_executables} ${TOPP_executables_with_GUIlib})
	list(APPEND sources_VS "${i}.cpp")
endforeach(i)

source_group("" FILES ${sources_VS})
