/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree;

import com.github.davidmoten.guavamini.Lists;
import com.github.davidmoten.guavamini.Optional;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.guavamini.annotations.VisibleForTesting;
import com.github.davidmoten.rtree.Splitter;
import com.github.davidmoten.rtree.geometry.HasGeometry;
import com.github.davidmoten.rtree.geometry.ListPair;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.github.davidmoten.rtree.internal.Util;
import com.github.davidmoten.rtree.internal.util.Pair;
import java.util.ArrayList;
import java.util.List;

public final class SplitterQuadratic
implements Splitter {
    @Override
    public <T extends HasGeometry> ListPair<T> split(List<T> items, int minSize) {
        Preconditions.checkArgument(items.size() >= 2);
        Pair<T> worstCombination = SplitterQuadratic.worstCombination(items);
        ArrayList<HasGeometry> group1 = Lists.newArrayList((HasGeometry)worstCombination.value1());
        ArrayList<HasGeometry> group2 = Lists.newArrayList((HasGeometry)worstCombination.value2());
        ArrayList<T> remaining = new ArrayList<T>(items);
        remaining.remove(worstCombination.value1());
        remaining.remove(worstCombination.value2());
        int minGroupSize = items.size() / 2;
        while (remaining.size() > 0) {
            this.assignRemaining(group1, group2, remaining, minGroupSize);
        }
        return new ListPair<HasGeometry>(group1, group2);
    }

    private <T extends HasGeometry> void assignRemaining(List<T> group1, List<T> group2, List<T> remaining, int minGroupSize) {
        boolean area1LessThanArea2;
        Rectangle mbr1 = Util.mbr(group1);
        Rectangle mbr2 = Util.mbr(group2);
        T item1 = SplitterQuadratic.getBestCandidateForGroup(remaining, group1, mbr1);
        T item2 = SplitterQuadratic.getBestCandidateForGroup(remaining, group2, mbr2);
        boolean bl = area1LessThanArea2 = item1.geometry().mbr().add(mbr1).area() <= item2.geometry().mbr().add(mbr2).area();
        if (area1LessThanArea2 && group2.size() + remaining.size() - 1 >= minGroupSize || !area1LessThanArea2 && group1.size() + remaining.size() == minGroupSize) {
            group1.add(item1);
            remaining.remove(item1);
        } else {
            group2.add(item2);
            remaining.remove(item2);
        }
    }

    @VisibleForTesting
    static <T extends HasGeometry> T getBestCandidateForGroup(List<T> list, List<T> group, Rectangle groupMbr) {
        Optional<Object> minEntry = Optional.absent();
        Optional<Object> minArea = Optional.absent();
        for (HasGeometry entry : list) {
            float area = groupMbr.add(entry.geometry().mbr()).area();
            if (minArea.isPresent() && !(area < ((Float)minArea.get()).floatValue())) continue;
            minArea = Optional.of(Float.valueOf(area));
            minEntry = Optional.of(entry);
        }
        return (T)((HasGeometry)minEntry.get());
    }

    @VisibleForTesting
    static <T extends HasGeometry> Pair<T> worstCombination(List<T> items) {
        Optional<Object> e1 = Optional.absent();
        Optional<Object> e2 = Optional.absent();
        Optional<Object> maxArea = Optional.absent();
        for (int i = 0; i < items.size(); ++i) {
            for (int j = i + 1; j < items.size(); ++j) {
                HasGeometry entry1 = (HasGeometry)items.get(i);
                HasGeometry entry2 = (HasGeometry)items.get(j);
                float area = entry1.geometry().mbr().add(entry2.geometry().mbr()).area();
                if (maxArea.isPresent() && !(area > ((Float)maxArea.get()).floatValue())) continue;
                e1 = Optional.of(entry1);
                e2 = Optional.of(entry2);
                maxArea = Optional.of(Float.valueOf(area));
            }
        }
        if (e1.isPresent()) {
            return new Pair(e1.get(), e2.get());
        }
        return new Pair<T>(items.get(0), items.get(1));
    }
}

