/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree.fbs;

import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.rtree.Entries;
import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.fbs.generated.Box_;
import com.github.davidmoten.rtree.fbs.generated.Circle_;
import com.github.davidmoten.rtree.fbs.generated.Entry_;
import com.github.davidmoten.rtree.fbs.generated.Geometry_;
import com.github.davidmoten.rtree.fbs.generated.Line_;
import com.github.davidmoten.rtree.fbs.generated.Node_;
import com.github.davidmoten.rtree.fbs.generated.Point_;
import com.github.davidmoten.rtree.geometry.Circle;
import com.github.davidmoten.rtree.geometry.Geometries;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.Line;
import com.github.davidmoten.rtree.geometry.Point;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.github.davidmoten.rtree.internal.Util;
import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import rx.functions.Func1;

final class FlatBuffersHelper {
    private FlatBuffersHelper() {
    }

    static <T, S extends Geometry> int addEntries(List<Entry<T, S>> entries, FlatBufferBuilder builder, Func1<? super T, byte[]> serializer) {
        int[] entries2 = new int[entries.size()];
        for (int i = 0; i < entries.size(); ++i) {
            Geometry c;
            int geomType;
            int geom;
            S g = entries.get(i).geometry();
            if (g instanceof Point) {
                Point p = (Point)g;
                geom = Point_.createPoint_(builder, p.x(), p.y());
                geomType = 0;
            } else if (g instanceof Rectangle) {
                Rectangle b = (Rectangle)g;
                geom = Box_.createBox_(builder, b.x1(), b.y1(), b.x2(), b.y2());
                geomType = 1;
            } else if (g instanceof Circle) {
                c = (Circle)g;
                geom = Circle_.createCircle_(builder, ((Circle)c).x(), ((Circle)c).y(), ((Circle)c).radius());
                geomType = 2;
            } else if (g instanceof Line) {
                c = (Line)g;
                geom = Line_.createLine_(builder, ((Line)c).x1(), ((Line)c).y1(), ((Line)c).x2(), ((Line)c).y2());
                geomType = 3;
            } else {
                throw new RuntimeException("unexpected");
            }
            Geometry_.startGeometry_(builder);
            if (geomType == 1) {
                Geometry_.addBox(builder, geom);
            } else if (geomType == 0) {
                Geometry_.addPoint(builder, geom);
            } else if (geomType == 2) {
                Geometry_.addCircle(builder, geom);
            } else if (geomType == 3) {
                Geometry_.addLine(builder, geom);
            } else {
                throw new RuntimeException("unexpected");
            }
            Geometry_.addType(builder, (byte)geomType);
            int geo = Geometry_.endGeometry_(builder);
            int obj = Entry_.createObjectVector(builder, serializer.call(entries.get(i).value()));
            entries2[i] = Entry_.createEntry_(builder, geo, obj);
        }
        int ents = Node_.createEntriesVector(builder, entries2);
        Rectangle mbb = Util.mbr(entries);
        int b = Box_.createBox_(builder, mbb.x1(), mbb.y1(), mbb.x2(), mbb.y2());
        Node_.startNode_(builder);
        Node_.addMbb(builder, b);
        Node_.addEntries(builder, ents);
        return Node_.endNode_(builder);
    }

    static <T, S extends Geometry> List<Entry<T, S>> createEntries(Node_ node, Func1<byte[], ? extends T> deserializer) {
        int numEntries = node.entriesLength();
        ArrayList<Entry<T, S>> entries = new ArrayList<Entry<T, S>>(numEntries);
        Preconditions.checkArgument(numEntries > 0);
        Entry_ entry = new Entry_();
        Geometry_ geom = new Geometry_();
        for (int i = 0; i < numEntries; ++i) {
            Entry<? extends T, S> ent = FlatBuffersHelper.createEntry(node, deserializer, entry, geom, i);
            entries.add(ent);
        }
        return entries;
    }

    private static <T, S extends Geometry> Entry<T, S> createEntry(Node_ node, Func1<byte[], ? extends T> deserializer, Entry_ entry, Geometry_ geom, int i) {
        node.entries(entry, i);
        entry.geometry(geom);
        S g = FlatBuffersHelper.toGeometry(geom);
        return Entries.entry(FlatBuffersHelper.parseObject(deserializer, entry), g);
    }

    static <T, S extends Geometry> Entry<T, S> createEntry(Node_ node, Func1<byte[], ? extends T> deserializer, int i) {
        return FlatBuffersHelper.createEntry(node, deserializer, new Entry_(), new Geometry_(), i);
    }

    static <T> T parseObject(Func1<byte[], ? extends T> deserializer, Entry_ entry) {
        ByteBuffer bb = entry.objectAsByteBuffer();
        if (bb == null) {
            return null;
        }
        byte[] bytes = Arrays.copyOfRange(bb.array(), bb.position(), bb.limit());
        T t = deserializer.call(bytes);
        return t;
    }

    static <S extends Geometry> S toGeometry(Geometry_ g) {
        Geometry result;
        byte type = g.type();
        if (type == 1) {
            result = FlatBuffersHelper.createBox(g.box());
        } else if (type == 0) {
            Point_ p = g.point();
            result = Geometries.point(p.x(), p.y());
        } else if (type == 2) {
            Circle_ c = g.circle();
            result = Geometries.circle(c.x(), c.y(), c.radius());
        } else if (type == 3) {
            result = FlatBuffersHelper.createLine(g.line());
        } else {
            throw new RuntimeException("unexpected");
        }
        return (S)result;
    }

    static Rectangle createBox(Box_ b) {
        return Geometries.rectangle(b.minX(), b.minY(), b.maxX(), b.maxY());
    }

    static Line createLine(Box_ b) {
        return Geometries.line(b.minX(), b.minY(), b.maxX(), b.maxY());
    }
}

