/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx;

import rx.Observable;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func2;

public final class Maths {
    private Maths() {
    }

    public static Observable<Double> solveWithNewtonsMethod(final Func1<Double, Double> f, final Func1<Double, Double> dfdx, double x0) {
        return Observable.just(1).repeat().scan(x0, new Func2<Double, Integer, Double>(){

            @Override
            public Double call(Double xn, Integer n) {
                return xn - (Double)f.call(xn) / (Double)dfdx.call(xn);
            }
        });
    }

    public static Observable<Double> solveWithNewtonsMethod(final Func1<Double, Double> f, double x0, final double h) {
        Func1<Double, Double> dfdx = new Func1<Double, Double>(){

            @Override
            public Double call(Double x) {
                return ((Double)f.call(x + h) - (Double)f.call(x - h)) / 2.0 / h;
            }
        };
        return Maths.solveWithNewtonsMethod(f, dfdx, x0);
    }

    public static Observable<Long> primes() {
        return Observable.defer(new Func0<Observable<Long>>(){
            final Mutable<Long> n = new Mutable<Long>(0L);

            @Override
            public Observable<Long> call() {
                return Observable.just(1).repeat().map(new Func1<Integer, Long>(){

                    @Override
                    public Long call(Integer t) {
                        Mutable<Long> mutable = n;
                        mutable.value = (Long)mutable.value + 1L;
                        return (Long)n.value;
                    }
                });
            }
        }).filter(new Func1<Long, Boolean>(){

            @Override
            public Boolean call(Long n) {
                int i = 2;
                while ((double)i <= Math.floor(Math.sqrt(n.longValue()))) {
                    if (n % (long)i == 0L) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        });
    }

    private static final class Mutable<T> {
        T value;

        Mutable(T value) {
            this.value = value;
        }
    }
}

