/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx;

import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;

public class SchedulerWithId
extends Scheduler {
    private final Scheduler scheduler;
    private final String id;
    private static final Pattern pattern = Pattern.compile("\\bschedId=\\[[^\\]]+\\]+\\b");

    public SchedulerWithId(Scheduler scheduler, String id) {
        this.scheduler = scheduler;
        this.id = "[" + id + "]";
    }

    @Override
    public Scheduler.Worker createWorker() {
        final Scheduler.Worker worker = this.scheduler.createWorker();
        Scheduler.Worker w = new Scheduler.Worker(){

            @Override
            public void unsubscribe() {
                worker.unsubscribe();
            }

            @Override
            public boolean isUnsubscribed() {
                return worker.isUnsubscribed();
            }

            @Override
            public Subscription schedule(final Action0 action) {
                Action0 a = new Action0(){

                    @Override
                    public void call() {
                        SchedulerWithId.this.setThreadName();
                        action.call();
                    }
                };
                return worker.schedule(a);
            }

            @Override
            public Subscription schedule(final Action0 action, long delayTime, TimeUnit unit) {
                Action0 a = new Action0(){

                    @Override
                    public void call() {
                        SchedulerWithId.this.setThreadName();
                        action.call();
                    }
                };
                return worker.schedule(a, delayTime, unit);
            }
        };
        return w;
    }

    private void setThreadName() {
        String name = Thread.currentThread().getName();
        String newName = SchedulerWithId.updateNameWithId(name, this.id);
        Thread.currentThread().setName(newName);
    }

    private static String updateNameWithId(String name, String id) {
        Matcher matcher;
        String newName = name == null ? id : ((matcher = pattern.matcher(name)).find() ? name.replace(matcher.group(), "schedId=" + id) : name + "|schedId=" + id);
        return newName;
    }
}

