/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx;

import com.github.davidmoten.rx.Functions;
import com.github.davidmoten.rx.Obs;
import com.github.davidmoten.rx.Statistics;
import com.github.davidmoten.rx.internal.operators.OperatorBufferEmissions;
import com.github.davidmoten.rx.internal.operators.OperatorDoOnNth;
import com.github.davidmoten.rx.internal.operators.OperatorFromTransformer;
import com.github.davidmoten.rx.internal.operators.OperatorSampleFirst;
import com.github.davidmoten.rx.internal.operators.OrderedMerge;
import com.github.davidmoten.rx.internal.operators.TransformerDecode;
import com.github.davidmoten.rx.internal.operators.TransformerLimitSubscribers;
import com.github.davidmoten.rx.internal.operators.TransformerStateMachine;
import com.github.davidmoten.rx.internal.operators.TransformerStringSplit;
import com.github.davidmoten.rx.util.BackpressureStrategy;
import com.github.davidmoten.rx.util.MapWithIndex;
import com.github.davidmoten.rx.util.Pair;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action1;
import rx.functions.Action2;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.functions.Func3;
import rx.schedulers.Schedulers;

public final class Transformers {
    public static <T, R> Observable.Operator<R, T> toOperator(Func1<? super Observable<T>, ? extends Observable<R>> function) {
        return OperatorFromTransformer.toOperator(function);
    }

    public static <T extends Number> Observable.Transformer<T, Statistics> collectStats() {
        return new Observable.Transformer<T, Statistics>(){

            @Override
            public Observable<Statistics> call(Observable<T> o) {
                return o.scan(Statistics.create(), Functions.collectStats());
            }
        };
    }

    public static <T, R extends Number> Observable.Transformer<T, Pair<T, Statistics>> collectStats(final Func1<? super T, ? extends R> function) {
        return new Observable.Transformer<T, Pair<T, Statistics>>(){

            @Override
            public Observable<Pair<T, Statistics>> call(Observable<T> source) {
                return source.scan(Pair.create(null, Statistics.create()), new Func2<Pair<T, Statistics>, T, Pair<T, Statistics>>(){

                    @Override
                    public Pair<T, Statistics> call(Pair<T, Statistics> pair, T t) {
                        return Pair.create(t, pair.b().add((Number)function.call(t)));
                    }
                }).skip(1);
            }
        };
    }

    public static <T extends Comparable<? super T>> Observable.Transformer<T, T> sort() {
        return new Observable.Transformer<T, T>(){

            @Override
            public Observable<T> call(Observable<T> o) {
                return o.toSortedList().flatMapIterable(Functions.identity());
            }
        };
    }

    public static <T> Observable.Transformer<T, T> sort(final Comparator<? super T> comparator) {
        return new Observable.Transformer<T, T>(){

            @Override
            public Observable<T> call(Observable<T> o) {
                return o.toSortedList(Functions.toFunc2(comparator)).flatMapIterable(Functions.identity());
            }
        };
    }

    public static <T> Observable.Transformer<T, Set<T>> toSet() {
        return new Observable.Transformer<T, Set<T>>(){

            @Override
            public Observable<Set<T>> call(Observable<T> o) {
                return o.collect(new Func0<Set<T>>(){

                    @Override
                    public Set<T> call() {
                        return new HashSet();
                    }
                }, new Action2<Set<T>, T>(){

                    @Override
                    public void call(Set<T> set, T t) {
                        set.add(t);
                    }
                });
            }
        };
    }

    public static <T> Observable.Transformer<T, MapWithIndex.Indexed<T>> mapWithIndex() {
        return MapWithIndex.instance();
    }

    public static <State, In, Out> Observable.Transformer<In, Out> stateMachine(Func0<State> initialStateFactory, Func3<? super State, ? super In, ? super Subscriber<Out>, ? extends State> transition, Func2<? super State, ? super Subscriber<Out>, Boolean> completion, BackpressureStrategy backpressureStrategy) {
        return TransformerStateMachine.create(initialStateFactory, transition, completion, backpressureStrategy);
    }

    public static <State, In, Out> Observable.Transformer<In, Out> stateMachine(Func0<? extends State> initialStateFactory, Func3<? super State, ? super In, ? super Subscriber<Out>, ? extends State> transition, Func2<? super State, ? super Subscriber<Out>, Boolean> completion) {
        return TransformerStateMachine.create(initialStateFactory, transition, completion, BackpressureStrategy.BUFFER);
    }

    public static <T> Observable.Transformer<T, T> bufferEmissions() {
        return BufferEmissionsHolder.INSTANCE;
    }

    public static final <T> Observable.Transformer<T, T> orderedMergeWith(Observable<? extends T> other, Comparator<? super T> comparator) {
        List<Observable<? extends T>> collection = Arrays.asList(other);
        return Transformers.orderedMergeWith(collection, comparator);
    }

    public static final <T> Observable.Transformer<T, T> orderedMergeWith(final Collection<Observable<? extends T>> others, final Comparator<? super T> comparator) {
        return new Observable.Transformer<T, T>(){

            @Override
            public Observable<T> call(Observable<T> source) {
                ArrayList collection = new ArrayList();
                collection.add(source);
                collection.addAll(others);
                return OrderedMerge.create(collection, comparator, false);
            }
        };
    }

    public static <T> Observable.Transformer<T, List<T>> toListUntilChanged() {
        Func2 equal = HolderEquals.instance();
        return Transformers.toListWhile(equal);
    }

    public static <T> Observable.Transformer<T, List<T>> toListWhile(Func2<? super List<T>, ? super T, Boolean> condition) {
        Func0 initialState = new Func0<List<T>>(){

            @Override
            public List<T> call() {
                return new ArrayList();
            }
        };
        Action2 collect = new Action2<List<T>, T>(){

            @Override
            public void call(List<T> list, T n) {
                list.add(n);
            }
        };
        return Transformers.collectWhile(initialState, collect, condition);
    }

    public static <T, R> Observable.Transformer<T, R> collectWhile(final Func0<R> factory, final Action2<? super R, ? super T> collect, final Func2<? super R, ? super T, Boolean> condition, final Func1<? super R, Boolean> isEmpty) {
        Func3 transition = new Func3<R, T, Observer<R>, R>(){

            @Override
            public R call(R collection, T t, Observer<R> observer) {
                if (((Boolean)condition.call(collection, t)).booleanValue()) {
                    collect.call(collection, t);
                    return collection;
                }
                observer.onNext(collection);
                Object r = factory.call();
                collect.call(r, t);
                return r;
            }
        };
        Func2 completionAction = new Func2<R, Observer<R>, Boolean>(){

            @Override
            public Boolean call(R collection, Observer<R> observer) {
                if (!((Boolean)isEmpty.call(collection)).booleanValue()) {
                    observer.onNext(collection);
                }
                return true;
            }
        };
        return Transformers.stateMachine(factory, transition, completionAction);
    }

    public static <T, R extends Collection<T>> Observable.Transformer<T, R> collectWhile(Func0<R> factory, Action2<? super R, ? super T> collect) {
        return Transformers.collectWhile(factory, collect, HolderEquals.instance());
    }

    public static <T, R extends Iterable<?>> Observable.Transformer<T, R> collectWhile(Func0<R> factory, Action2<? super R, ? super T> collect, Func2<? super R, ? super T, Boolean> condition) {
        Func1 isEmpty = new Func1<R, Boolean>(){

            @Override
            public Boolean call(R collection) {
                return !collection.iterator().hasNext();
            }
        };
        return Transformers.collectWhile(factory, collect, condition, isEmpty);
    }

    public static <T> Observable.Transformer<T, T> doOnNext(final int n, final Action1<? super T> action) {
        return new Observable.Transformer<T, T>(){

            @Override
            public Observable<T> call(Observable<T> o) {
                return o.lift(OperatorDoOnNth.create(action, n));
            }
        };
    }

    public static <T> Observable.Transformer<T, T> doOnFirst(Action1<? super T> action) {
        return Transformers.doOnNext(1, action);
    }

    public static <R, T> Observable.Transformer<T, R> ignoreElementsThen(final Observable<R> next) {
        return new Observable.Transformer<T, R>(){

            @Override
            public Observable<R> call(Observable<T> source) {
                return source.ignoreElements().concatWith(next);
            }
        };
    }

    public static <T> Observable.Transformer<String, String> split(String pattern) {
        return TransformerStringSplit.split(pattern);
    }

    public static Observable.Transformer<byte[], String> decode(CharsetDecoder charsetDecoder) {
        return TransformerDecode.decode(charsetDecoder);
    }

    public static <T> Observable.Transformer<T, T> limitSubscribers(AtomicInteger subscriberCount, int maxSubscribers) {
        return new TransformerLimitSubscribers(subscriberCount, maxSubscribers);
    }

    public static <T> Observable.Transformer<T, T> limitSubscribers(int maxSubscribers) {
        return new TransformerLimitSubscribers(new AtomicInteger(), maxSubscribers);
    }

    public static <T> Observable.Transformer<T, T> cache(final long duration, final TimeUnit unit, final Scheduler.Worker worker) {
        return new Observable.Transformer<T, T>(){

            @Override
            public Observable<T> call(Observable<T> o) {
                return Obs.cache(o, duration, unit, worker);
            }
        };
    }

    public static <T> Observable.Transformer<T, T> sampleFirst(long duration, TimeUnit unit) {
        return Transformers.sampleFirst(duration, unit, Schedulers.computation());
    }

    public static <T> Observable.Transformer<T, T> sampleFirst(final long duration, final TimeUnit unit, final Scheduler scheduler) {
        if (duration <= 0L) {
            throw new IllegalArgumentException("duration must be > 0");
        }
        return new Observable.Transformer<T, T>(){

            @Override
            public Observable<T> call(Observable<T> source) {
                return source.lift(new OperatorSampleFirst(duration, unit, scheduler));
            }
        };
    }

    private static class HolderEquals {
        private static final Func2<Collection<Object>, Object, Boolean> INSTANCE = new Func2<Collection<Object>, Object, Boolean>(){

            @Override
            public Boolean call(Collection<Object> list, Object t) {
                return list.isEmpty() || list.iterator().next().equals(t);
            }
        };

        private HolderEquals() {
        }

        static <T> Func2<Collection<T>, T, Boolean> instance() {
            return INSTANCE;
        }
    }

    private static class BufferEmissionsHolder {
        static Observable.Transformer<Object, Object> INSTANCE = new Observable.Transformer<Object, Object>(){

            @Override
            public Observable<Object> call(Observable<Object> o) {
                return o.lift(new OperatorBufferEmissions());
            }
        };

        private BufferEmissionsHolder() {
        }
    }
}

