/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import com.github.davidmoten.rx.util.Drainer;
import com.github.davidmoten.rx.util.DrainerSyncBiased;
import java.util.concurrent.ConcurrentLinkedQueue;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;

public final class OperatorBufferEmissions<T>
implements Observable.Operator<T, T> {
    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        final Drainer<? super T> drainer = OperatorBufferEmissions.createDrainer(child);
        final ParentSubscriber<? super T> parent = new ParentSubscriber<T>(drainer);
        child.add(parent);
        child.setProducer(new Producer(){

            @Override
            public void request(long n) {
                if (n <= 0L) {
                    return;
                }
                long t = drainer.surplus();
                long r = n - t;
                if (t > 0L) {
                    if (r > 0L) {
                        parent.requestMore(r);
                    }
                } else {
                    if (r < 0L) {
                        r = Long.MAX_VALUE;
                    }
                    parent.requestMore(r);
                }
                drainer.request(n);
            }
        });
        return parent;
    }

    private static <T> Drainer<T> createDrainer(Subscriber<? super T> child) {
        return DrainerSyncBiased.create(new ConcurrentLinkedQueue(), child);
    }

    private static final class ParentSubscriber<T>
    extends Subscriber<T> {
        private final Drainer<T> drainer;

        ParentSubscriber(Drainer<T> drainer) {
            this.drainer = drainer;
        }

        @Override
        public void onStart() {
            this.request(0L);
        }

        void requestMore(long n) {
            if (n > 0L) {
                this.request(n);
            }
        }

        @Override
        public void onCompleted() {
            this.drainer.onCompleted();
        }

        @Override
        public void onError(Throwable e) {
            this.drainer.onError(e);
        }

        @Override
        public void onNext(T t) {
            this.drainer.onNext(t);
        }
    }
}

