/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import com.github.davidmoten.rx.subjects.PublishSubjectSingleSubscriber;
import rx.Notification;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.functions.Func2;
import rx.observers.SerializedSubscriber;

@Deprecated
public class OperatorOrderedMerge<T>
implements Observable.Operator<T, T> {
    private final Observable<? extends T> other;
    private final Func2<? super T, ? super T, Integer> comparator;
    private static final Object EMPTY_SENTINEL = new Object();

    private OperatorOrderedMerge(Observable<? extends T> other, Func2<? super T, ? super T, Integer> comparator) {
        this.other = other;
        this.comparator = comparator;
    }

    public static <T> OperatorOrderedMerge<T> create(Observable<? extends T> other, Func2<? super T, ? super T, Integer> comparator) {
        return new OperatorOrderedMerge<T>(other, comparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        PublishSubjectSingleSubscriber<? super T> subject = PublishSubjectSingleSubscriber.create();
        MergeSubscriber[] subscribers = new MergeSubscriber[2];
        EventSubscriber<? super T> eventSubscriber = new EventSubscriber<T>(child, this.comparator, subscribers);
        SerializedSubscriber<? super T> serializedEventSubscriber = new SerializedSubscriber<T>(eventSubscriber);
        MergeSubscriber mainSubscriber = new MergeSubscriber(serializedEventSubscriber, 0);
        MergeSubscriber otherSubscriber = new MergeSubscriber(serializedEventSubscriber, 1);
        child.add(mainSubscriber);
        OperatorOrderedMerge operatorOrderedMerge = this;
        synchronized (operatorOrderedMerge) {
            subscribers[0] = mainSubscriber;
            subscribers[1] = otherSubscriber;
        }
        child.add(otherSubscriber);
        child.add(serializedEventSubscriber);
        subject.unsafeSubscribe(serializedEventSubscriber);
        this.other.unsafeSubscribe(otherSubscriber);
        return mainSubscriber;
    }

    private static final class EventSubscriber<T>
    extends Subscriber<Event<T>> {
        private final Subscriber<? super T> child;
        private final Func2<? super T, ? super T, Integer> comparator;
        private T buffer = OperatorOrderedMerge.access$000();
        private int bufferSubscriberIndex = -1;
        private int completedCount = 0;
        private final MergeSubscriber<T>[] subscribers;

        public EventSubscriber(Subscriber<? super T> child, Func2<? super T, ? super T, Integer> comparator, MergeSubscriber<T>[] subscribers) {
            this.child = child;
            this.comparator = comparator;
            this.subscribers = subscribers;
        }

        @Override
        public void onCompleted() {
        }

        @Override
        public void onError(Throwable e) {
            this.child.onError(e);
        }

        @Override
        public void onNext(Event<T> event) {
            if (event.notification.hasValue()) {
                Object value = event.notification.getValue();
                if (this.completedCount == 1 && this.buffer == EMPTY_SENTINEL) {
                    this.child.onNext(value);
                    this.subscribers[event.subscriberIndex].requestOne();
                } else if (this.buffer == EMPTY_SENTINEL) {
                    this.buffer = value;
                    this.bufferSubscriberIndex = event.subscriberIndex;
                } else if (this.comparator.call(value, this.buffer) <= 0) {
                    this.child.onNext(value);
                    this.subscribers[event.subscriberIndex].requestOne();
                } else {
                    this.child.onNext(this.buffer);
                    int requestFrom = this.bufferSubscriberIndex;
                    this.buffer = value;
                    this.bufferSubscriberIndex = event.subscriberIndex;
                    this.subscribers[requestFrom].requestOne();
                }
            } else if (event.notification.isOnCompleted()) {
                ++this.completedCount;
                if (this.completedCount == 2) {
                    if (this.buffer != EMPTY_SENTINEL) {
                        this.child.onNext(this.buffer);
                        this.buffer = EMPTY_SENTINEL;
                    }
                    this.child.onCompleted();
                } else {
                    this.other(event.subscriberIndex).requestOne();
                }
            }
        }

        private MergeSubscriber<T> other(int subscriberIndex) {
            return this.subscribers[(subscriberIndex + 1) % 2];
        }
    }

    private static class MergeSubscriber<T>
    extends Subscriber<T> {
        private final Observer<Event<T>> observer;
        private final int index;

        MergeSubscriber(Observer<Event<T>> observer, int index) {
            this.observer = observer;
            this.index = index;
        }

        void requestOne() {
            this.request(1L);
        }

        @Override
        public void onStart() {
            this.request(1L);
        }

        @Override
        public void onCompleted() {
            this.observer.onNext(new Event(this.index, Notification.createOnCompleted()));
        }

        @Override
        public void onError(Throwable e) {
            this.observer.onError(e);
        }

        @Override
        public void onNext(T t) {
            this.observer.onNext(new Event<T>(this.index, Notification.createOnNext(t)));
        }
    }

    private static class Event<T> {
        final int subscriberIndex;
        final Notification<T> notification;

        Event(int subscriberIndex, Notification<T> notification) {
            this.subscriberIndex = subscriberIndex;
            this.notification = notification;
        }
    }
}

