/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import rx.Observable;
import rx.Subscriber;

public final class OperatorUnsubscribeEagerly<T>
implements Observable.Operator<T, T> {
    private OperatorUnsubscribeEagerly() {
    }

    public static final <T> OperatorUnsubscribeEagerly<T> instance() {
        return Singleton.INSTANCE;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        Subscriber parent = new Subscriber<T>(){

            @Override
            public void onCompleted() {
                this.unsubscribe();
                child.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                this.unsubscribe();
                child.onError(e);
            }

            @Override
            public void onNext(T t) {
                child.onNext(t);
            }
        };
        child.add(parent);
        return parent;
    }

    private static final class Singleton {
        private static final OperatorUnsubscribeEagerly<?> INSTANCE = new OperatorUnsubscribeEagerly();

        private Singleton() {
        }
    }
}

