/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.CompositeException;
import rx.exceptions.MissingBackpressureException;
import rx.internal.operators.BackpressureUtils;
import rx.internal.operators.NotificationLite;
import rx.internal.util.RxRingBuffer;
import rx.internal.util.unsafe.MpscLinkedQueue;

public final class OrderedMerge<T>
implements Observable.OnSubscribe<T> {
    final List<Observable<? extends T>> sources;
    final Comparator<? super T> comparator;
    final boolean delayErrors;

    public static <U extends Comparable<? super U>> Observable<U> create(Collection<Observable<? extends U>> sources) {
        return OrderedMerge.create(sources, false);
    }

    public static <U> Observable<U> create(Collection<Observable<? extends U>> sources, Comparator<? super U> comparator) {
        return OrderedMerge.create(sources, comparator, false);
    }

    public static <U extends Comparable<? super U>> Observable<U> create(Collection<Observable<? extends U>> sources, boolean delayErrors) {
        return Observable.create(new OrderedMerge(sources, new Comparator<U>(){

            @Override
            public int compare(U o1, U o2) {
                return o1.compareTo(o2);
            }
        }, delayErrors));
    }

    public static <U> Observable<U> create(Collection<Observable<? extends U>> sources, Comparator<? super U> comparator, boolean delayErrors) {
        return Observable.create(new OrderedMerge<U>(sources, comparator, delayErrors));
    }

    private OrderedMerge(Collection<Observable<? extends T>> sources, Comparator<? super T> comparator, boolean delayErrors) {
        this.sources = sources instanceof List ? (List<Object>)sources : new ArrayList<Observable<? extends T>>(sources);
        this.comparator = comparator;
        this.delayErrors = delayErrors;
    }

    @Override
    public void call(Subscriber<? super T> child) {
        int i;
        SourceSubscriber[] sources = new SourceSubscriber[this.sources.size()];
        MergeProducer<T> mp = new MergeProducer<T>(sources, child, this.comparator, this.delayErrors);
        for (i = 0; i < sources.length; ++i) {
            SourceSubscriber<? super T> s;
            if (child.isUnsubscribed()) {
                return;
            }
            sources[i] = s = new SourceSubscriber<T>(mp);
            child.add(s);
        }
        mp.set(0L);
        child.setProducer(mp);
        i = 0;
        for (Observable<T> source : this.sources) {
            if (child.isUnsubscribed()) {
                return;
            }
            source.unsafeSubscribe(sources[i]);
            ++i;
        }
    }

    static final class SourceSubscriber<T>
    extends Subscriber<T> {
        final RxRingBuffer queue = RxRingBuffer.getSpscInstance();
        final MergeProducer<T> parent;
        volatile boolean done;

        public SourceSubscriber(MergeProducer<T> parent) {
            this.parent = parent;
        }

        @Override
        public void onStart() {
            this.add(this.queue);
            this.request(RxRingBuffer.SIZE);
        }

        public void requestMore(long n) {
            this.request(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t) {
            try {
                this.queue.onNext(this.parent.nl.next(t));
            }
            catch (MissingBackpressureException mbe) {
                try {
                    this.onError(mbe);
                }
                finally {
                    this.unsubscribe();
                }
                return;
            }
            catch (IllegalStateException ex) {
                if (!this.isUnsubscribed()) {
                    try {
                        this.onError(ex);
                    }
                    finally {
                        this.unsubscribe();
                    }
                }
                return;
            }
            this.parent.emit();
        }

        @Override
        public void onError(Throwable e) {
            this.done = true;
            this.parent.error(e);
        }

        @Override
        public void onCompleted() {
            this.done = true;
            this.parent.emit();
        }
    }

    static final class MergeProducer<T>
    extends AtomicLong
    implements Producer {
        private static final long serialVersionUID = -812969080497027108L;
        final NotificationLite<T> nl = NotificationLite.instance();
        final boolean delayErrors;
        final Comparator<? super T> comparator;
        final SourceSubscriber[] sources;
        final Subscriber<? super T> child;
        final Queue<Throwable> errors;
        boolean emitting;
        boolean missed;

        public MergeProducer(SourceSubscriber[] sources, Subscriber<? super T> child, Comparator<? super T> comparator, boolean delayErrors) {
            this.sources = sources;
            this.delayErrors = delayErrors;
            this.errors = new MpscLinkedQueue<Throwable>();
            this.child = child;
            this.comparator = comparator;
        }

        @Override
        public void request(long n) {
            BackpressureUtils.getAndAddRequest(this, n);
            this.emit();
        }

        public void error(Throwable ex) {
            this.errors.offer(ex);
            this.emit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void emit() {
            MergeProducer mergeProducer = this;
            synchronized (mergeProducer) {
                if (this.emitting) {
                    this.missed = true;
                    return;
                }
                this.emitting = true;
            }
            SourceSubscriber[] sources = this.sources;
            int n = sources.length;
            Subscriber<T> child = this.child;
            while (!child.isUnsubscribed()) {
                if (!this.delayErrors && !this.errors.isEmpty()) {
                    child.onError(this.errors.poll());
                    return;
                }
                long r = this.get();
                long e = 0L;
                if (r == 0L) {
                    int doneCount = 0;
                    for (SourceSubscriber s : sources) {
                        if (s == null) {
                            ++doneCount;
                            continue;
                        }
                        if (!s.done || !s.queue.isEmpty()) continue;
                        ++doneCount;
                    }
                    if (doneCount == n) {
                        this.reportErrorOrComplete(child);
                        return;
                    }
                }
                while (r != 0L) {
                    if (child.isUnsubscribed()) {
                        return;
                    }
                    if (!this.delayErrors && !this.errors.isEmpty()) {
                        child.onError(this.errors.poll());
                        return;
                    }
                    boolean fullRow = true;
                    boolean hasAtLeastOne = false;
                    Object minimum = null;
                    int toPoll = -1;
                    int doneCount = 0;
                    for (int i = 0; i < n; ++i) {
                        SourceSubscriber s = sources[i];
                        if (s == null) {
                            ++doneCount;
                            continue;
                        }
                        boolean d = s.done;
                        Object o = s.queue.peek();
                        if (o == null) {
                            if (d) {
                                sources[i] = null;
                                ++doneCount;
                                continue;
                            }
                            fullRow = false;
                            break;
                        }
                        if (hasAtLeastOne) {
                            T v = this.nl.getValue(o);
                            int c = this.comparator.compare(minimum, v);
                            if (c <= 0) continue;
                            minimum = v;
                            toPoll = i;
                            continue;
                        }
                        minimum = this.nl.getValue(o);
                        hasAtLeastOne = true;
                        toPoll = i;
                    }
                    if (doneCount == n) {
                        this.reportErrorOrComplete(child);
                        return;
                    }
                    if (!fullRow) break;
                    if (toPoll >= 0) {
                        SourceSubscriber s = sources[toPoll];
                        s.queue.poll();
                        s.requestMore(1L);
                    }
                    child.onNext(minimum);
                    if (r == Long.MAX_VALUE) continue;
                    --r;
                    ++e;
                }
                if (e != 0L) {
                    this.addAndGet(-e);
                }
                MergeProducer mergeProducer2 = this;
                synchronized (mergeProducer2) {
                    if (!this.missed) {
                        this.emitting = false;
                        return;
                    }
                    this.missed = false;
                }
            }
            return;
        }

        void reportErrorOrComplete(Subscriber<? super T> child) {
            if (this.delayErrors && !this.errors.isEmpty()) {
                if (this.errors.size() == 1) {
                    child.onError(this.errors.poll());
                } else {
                    child.onError(new CompositeException(this.errors));
                }
            } else {
                child.onCompleted();
            }
        }
    }
}

