/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import com.github.davidmoten.rx.util.BackpressureStrategy;
import com.github.davidmoten.util.Preconditions;
import rx.Notification;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.functions.Func3;

public final class TransformerStateMachine<State, In, Out>
implements Observable.Transformer<In, Out> {
    private final Func0<? extends State> initialState;
    private final Func3<? super State, ? super In, ? super Subscriber<Out>, ? extends State> transition;
    private final Func2<? super State, ? super Subscriber<Out>, Boolean> completion;
    private final BackpressureStrategy backpressureStrategy;
    private static final Func1<Notification<?>, Boolean> NOT_UNSUBSCRIBED = new Func1<Notification<?>, Boolean>(){

        @Override
        public Boolean call(Notification<?> t) {
            return !t.isOnError() || t.getThrowable() != UnsubscribedExceptionHolder.INSTANCE;
        }
    };

    private TransformerStateMachine(Func0<? extends State> initialState, Func3<? super State, ? super In, ? super Subscriber<Out>, ? extends State> transition, Func2<? super State, ? super Subscriber<Out>, Boolean> completion, BackpressureStrategy backpressureStrategy) {
        Preconditions.checkNotNull(initialState);
        Preconditions.checkNotNull(transition);
        Preconditions.checkNotNull(completion);
        Preconditions.checkNotNull((Object)backpressureStrategy);
        this.initialState = initialState;
        this.transition = transition;
        this.completion = completion;
        this.backpressureStrategy = backpressureStrategy;
    }

    public static <State, In, Out> Observable.Transformer<In, Out> create(Func0<? extends State> initialState, Func3<? super State, ? super In, ? super Subscriber<Out>, ? extends State> transition, Func2<? super State, ? super Subscriber<Out>, Boolean> completion, BackpressureStrategy backpressureStrategy) {
        return new TransformerStateMachine<State, In, Out>(initialState, transition, completion, backpressureStrategy);
    }

    @Override
    public Observable<Out> call(final Observable<In> source) {
        return Observable.defer(new Func0<Observable<Out>>(){

            @Override
            public Observable<Out> call() {
                Mutable state = new Mutable(TransformerStateMachine.this.initialState.call());
                return source.materialize().flatMap(TransformerStateMachine.execute(TransformerStateMachine.this.transition, TransformerStateMachine.this.completion, state, TransformerStateMachine.this.backpressureStrategy)).materialize().takeWhile(NOT_UNSUBSCRIBED).dematerialize().dematerialize();
            }
        });
    }

    private static <State, Out, In> Func1<Notification<In>, Observable<Notification<Out>>> execute(final Func3<? super State, ? super In, ? super Subscriber<Out>, ? extends State> transition, final Func2<? super State, ? super Subscriber<Out>, Boolean> completion, final Mutable<State> state, final BackpressureStrategy backpressureStrategy) {
        return new Func1<Notification<In>, Observable<Notification<Out>>>(){

            @Override
            public Observable<Notification<Out>> call(final Notification<In> in) {
                Observable o = Observable.create(new Observable.OnSubscribe<Notification<Out>>(){

                    @Override
                    public void call(Subscriber<? super Notification<Out>> subscriber) {
                        NotificationSubscriber w = TransformerStateMachine.wrap(subscriber);
                        if (in.hasValue()) {
                            state.value = transition.call(state.value, in.getValue(), w);
                            if (!subscriber.isUnsubscribed()) {
                                subscriber.onCompleted();
                            } else {
                                subscriber.onError(UnsubscribedExceptionHolder.INSTANCE);
                            }
                        } else if (in.isOnCompleted()) {
                            if (((Boolean)completion.call(state.value, w)).booleanValue() && !subscriber.isUnsubscribed()) {
                                w.onCompleted();
                            }
                        } else if (!subscriber.isUnsubscribed()) {
                            w.onError(in.getThrowable());
                        }
                    }
                });
                return TransformerStateMachine.applyBackpressure(o, backpressureStrategy);
            }
        };
    }

    private static <Out> Observable<Notification<Out>> applyBackpressure(Observable<Notification<Out>> o, BackpressureStrategy backpressureStrategy) {
        if (backpressureStrategy == BackpressureStrategy.BUFFER) {
            return o.onBackpressureBuffer();
        }
        if (backpressureStrategy == BackpressureStrategy.DROP) {
            return o.onBackpressureDrop();
        }
        if (backpressureStrategy == BackpressureStrategy.LATEST) {
            return o.onBackpressureLatest();
        }
        throw new IllegalArgumentException("backpressure strategy not supported: " + (Object)((Object)backpressureStrategy));
    }

    private static <Out> NotificationSubscriber<Out> wrap(Subscriber<? super Notification<Out>> sub) {
        return new NotificationSubscriber(sub);
    }

    private static final class NotificationSubscriber<Out>
    extends Subscriber<Out> {
        private final Subscriber<? super Notification<Out>> sub;

        NotificationSubscriber(Subscriber<? super Notification<Out>> sub) {
            this.sub = sub;
            this.add(sub);
        }

        @Override
        public void onCompleted() {
            this.sub.onNext(Notification.createOnCompleted());
        }

        @Override
        public void onError(Throwable e) {
            this.sub.onNext(Notification.createOnError(e));
        }

        @Override
        public void onNext(Out t) {
            this.sub.onNext(Notification.createOnNext(t));
        }
    }

    private static class UnsubscribedException
    extends RuntimeException {
        private static final long serialVersionUID = 7177818068143224232L;

        private UnsubscribedException() {
        }
    }

    private static final class UnsubscribedExceptionHolder {
        static final UnsubscribedException INSTANCE = new UnsubscribedException();

        private UnsubscribedExceptionHolder() {
        }
    }

    private static final class Mutable<T> {
        T value;

        Mutable(T value) {
            this.value = value;
        }
    }
}

