/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.subjects;

import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Subscriber;
import rx.subjects.Subject;

public final class PublishSubjectSingleSubscriber<T>
extends Subject<T, T> {
    static final String ONLY_ONE_SUBSCRIPTION_IS_ALLOWED = "only one subscription is allowed";
    private final SingleSubscribeOnSubscribe<T> subscriberHolder;

    private PublishSubjectSingleSubscriber(SingleSubscribeOnSubscribe<T> onSubscribe) {
        super(onSubscribe);
        this.subscriberHolder = onSubscribe;
    }

    private PublishSubjectSingleSubscriber() {
        this(new SingleSubscribeOnSubscribe());
    }

    public static <T> PublishSubjectSingleSubscriber<T> create() {
        return new PublishSubjectSingleSubscriber<T>();
    }

    @Override
    public void onCompleted() {
        if (this.subscriberHolder.subscriber.get() != null) {
            this.subscriberHolder.subscriber.get().onCompleted();
        }
    }

    @Override
    public void onError(Throwable e) {
        if (this.subscriberHolder.subscriber.get() != null) {
            this.subscriberHolder.subscriber.get().onError(e);
        }
    }

    @Override
    public void onNext(T t) {
        if (this.subscriberHolder.subscriber.get() != null) {
            this.subscriberHolder.subscriber.get().onNext(t);
        }
    }

    @Override
    public boolean hasObservers() {
        return this.subscriberHolder.subscriber.get() != null;
    }

    private static class SingleSubscribeOnSubscribe<T>
    implements Observable.OnSubscribe<T> {
        final AtomicReference<Subscriber<? super T>> subscriber = new AtomicReference();

        private SingleSubscribeOnSubscribe() {
        }

        @Override
        public void call(Subscriber<? super T> sub) {
            if (!this.subscriber.compareAndSet(null, sub)) {
                throw new RuntimeException(PublishSubjectSingleSubscriber.ONLY_ONE_SUBSCRIPTION_IS_ALLOWED);
            }
        }
    }
}

