/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.testing;

import com.github.davidmoten.util.Optional;
import com.github.davidmoten.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Func1;

public final class TestingHelper {
    private static final Optional<Long> ABSENT = Optional.absent();

    public static <T, R> Builder<T, R> function(Func1<Observable<T>, Observable<R>> function) {
        return new Builder<T, R>().function(function);
    }

    private static <T, R> void runTest(Case<T, R> c, TestType testType) {
        block12: {
            try {
                CountDownLatch sourceUnsubscribeLatch = new CountDownLatch(1);
                MyTestSubscriber sub = TestingHelper.createTestSubscriber(testType, c.unsubscribeAfter);
                c.function.call(c.from.doOnUnsubscribe(TestingHelper.countDown(sourceUnsubscribeLatch))).subscribe(sub);
                if (c.unsubscribeAfter.isPresent()) {
                    TestingHelper.waitForUnsubscribe(sourceUnsubscribeLatch, c.waitForUnusbscribeMs, TimeUnit.MILLISECONDS);
                } else {
                    sub.awaitTerminalEvent(c.waitForTerminalEventMs, TimeUnit.MILLISECONDS);
                    if (c.expectError.isPresent()) {
                        sub.assertError(c.expectError.get());
                        TestingHelper.pause(c.waitForMoreTerminalEventsMs, TimeUnit.MILLISECONDS);
                        if (sub.numOnCompletedEvents() > 0) {
                            throw new UnexpectedOnCompletedException();
                        }
                    } else {
                        sub.assertNoErrors();
                        TestingHelper.pause(c.waitForMoreTerminalEventsMs, TimeUnit.MILLISECONDS);
                        if (sub.numOnCompletedEvents() > 1) {
                            throw new TooManyOnCompletedException();
                        }
                        sub.assertNoErrors();
                    }
                }
                if (c.expected.isPresent()) {
                    sub.assertReceivedOnNext(c.expected.get(), c.ordered);
                }
                if (c.expectSize.isPresent()) {
                    sub.assertReceivedCountIs(c.expectSize.get());
                }
                sub.assertUnsubscribed();
                if (c.checkSourceUnsubscribed) {
                    TestingHelper.waitForUnsubscribe(sourceUnsubscribeLatch, c.waitForUnusbscribeMs, TimeUnit.MILLISECONDS);
                }
                if (c.expectedException.isPresent()) {
                    throw new ExpectedExceptionNotThrownException();
                }
            }
            catch (RuntimeException e) {
                if (c.expectedException.isPresent() && c.expectedException.get().isInstance(e)) break block12;
                throw e;
            }
        }
    }

    private static Action0 countDown(final CountDownLatch latch) {
        return new Action0(){

            @Override
            public void call() {
                latch.countDown();
            }
        };
    }

    private static <T> void waitForUnsubscribe(CountDownLatch latch, long duration, TimeUnit unit) {
        try {
            if (!latch.await(duration, unit)) {
                throw new UnsubscriptionFromSourceTimeoutException();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void pause(long duration, TimeUnit unit) {
        try {
            Thread.sleep(unit.toMillis(duration));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static <T> MyTestSubscriber<T> createTestSubscriber(Optional<Integer> unsubscribeAfter, long onStartRequest, Optional<Long> onNextRequest) {
        return new MyTestSubscriber(unsubscribeAfter, Optional.of(onStartRequest), onNextRequest, ABSENT);
    }

    private static <T> MyTestSubscriber<T> createTestSubscriber(TestType testType, Optional<Integer> unsubscribeAfter) {
        if (testType == TestType.WITHOUT_BACKP) {
            return new MyTestSubscriber(unsubscribeAfter);
        }
        if (testType == TestType.BACKP_INITIAL_REQUEST_MAX) {
            return TestingHelper.createTestSubscriber(unsubscribeAfter, Long.MAX_VALUE, ABSENT);
        }
        if (testType == TestType.BACKP_INITIAL_REQUEST_MAX_THEN_BY_ONE) {
            return TestingHelper.createTestSubscriber(unsubscribeAfter, Long.MAX_VALUE, Optional.of(1L));
        }
        if (testType == TestType.BACKP_ONE_BY_ONE) {
            return TestingHelper.createTestSubscriber(unsubscribeAfter, 1L, Optional.of(1L));
        }
        if (testType == TestType.BACKP_REQUEST_ZERO) {
            return new MyTestSubscriber(unsubscribeAfter, Optional.of(1L), Optional.of(0L), Optional.of(1L));
        }
        if (testType == TestType.BACKP_REQUEST_OVERFLOW) {
            return new MyTestSubscriber(unsubscribeAfter, Optional.of(1L), Optional.of(0x5555555555555554L), Optional.of(0x5555555555555554L));
        }
        if (testType == TestType.BACKP_TWO_BY_TWO) {
            return TestingHelper.createTestSubscriberWithBackpNbyN(unsubscribeAfter, 2L);
        }
        if (testType == TestType.BACKP_FIVE_BY_FIVE) {
            return TestingHelper.createTestSubscriberWithBackpNbyN(unsubscribeAfter, 5L);
        }
        if (testType == TestType.BACKP_FIFTY_BY_FIFTY) {
            return TestingHelper.createTestSubscriberWithBackpNbyN(unsubscribeAfter, 50L);
        }
        if (testType == TestType.BACKP_THOUSAND_BY_THOUSAND) {
            return TestingHelper.createTestSubscriberWithBackpNbyN(unsubscribeAfter, 1000L);
        }
        throw new RuntimeException((Object)((Object)testType) + " not implemented");
    }

    private static <T> MyTestSubscriber<T> createTestSubscriberWithBackpNbyN(Optional<Integer> unsubscribeAfter, long requestSize) {
        return new MyTestSubscriber(unsubscribeAfter, Optional.of(requestSize), ABSENT, Optional.of(requestSize));
    }

    private static <T> boolean equals(Collection<T> a, Collection<T> b, boolean ordered) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return a == null;
        }
        if (a.size() != b.size()) {
            return false;
        }
        if (ordered) {
            return a.equals(b);
        }
        ArrayList<T> list = new ArrayList<T>(a);
        for (T t : b) {
            if (list.remove(t)) continue;
            return false;
        }
        return true;
    }

    public static class AssertionException
    extends RuntimeException {
        private static final long serialVersionUID = -6846674323693517388L;

        public AssertionException(String message) {
            super(message);
        }
    }

    public static class DeliveredMoreThanRequestedException
    extends RuntimeException {
        private static final long serialVersionUID = 1369440545774454215L;

        public DeliveredMoreThanRequestedException() {
            super("more items arrived than requested");
        }
    }

    private static class TestingException
    extends RuntimeException {
        private static final long serialVersionUID = 4467514769366847747L;

        private TestingException() {
        }
    }

    private static class MyTestCase<T, R>
    extends TestCase {
        private final Case<T, R> c;
        private final TestType testType;

        MyTestCase(String name, Case<T, R> c, TestType testType) {
            super(name);
            this.c = c;
            this.testType = testType;
        }

        protected void runTest() throws Throwable {
            TestingHelper.runTest(this.c, this.testType);
        }
    }

    @RunWith(value=Suite.class)
    @Suite.SuiteClasses(value={})
    private static class TestSuiteFromCases<T, R>
    extends TestSuite {
        TestSuiteFromCases(Class<?> cls, List<Case<T, R>> cases) {
            super(cls);
            for (Case<T, R> c : cases) {
                for (TestType testType : TestType.values()) {
                    if (testType == TestType.BACKP_REQUEST_OVERFLOW) continue;
                    this.addTest((Test)new MyTestCase<T, R>(c.name + "_" + testType.name(), c, testType));
                }
            }
        }
    }

    private static enum TestType {
        WITHOUT_BACKP,
        BACKP_INITIAL_REQUEST_MAX,
        BACKP_INITIAL_REQUEST_MAX_THEN_BY_ONE,
        BACKP_ONE_BY_ONE,
        BACKP_TWO_BY_TWO,
        BACKP_REQUEST_ZERO,
        BACKP_FIVE_BY_FIVE,
        BACKP_FIFTY_BY_FIFTY,
        BACKP_THOUSAND_BY_THOUSAND,
        BACKP_REQUEST_OVERFLOW;

    }

    public static class UnexpectedOnNextException
    extends RuntimeException {
        private static final long serialVersionUID = -3656406263739222767L;

        public UnexpectedOnNextException(String message) {
            super(message);
        }
    }

    public static class DownstreamUnsubscriptionDidNotOccurException
    extends RuntimeException {
        private static final long serialVersionUID = 7218646111664183642L;
    }

    public static class TooManyOnCompletedException
    extends RuntimeException {
        private static final long serialVersionUID = -405328882928962333L;
    }

    public static class UnexpectedOnErrorException
    extends RuntimeException {
        private static final long serialVersionUID = -813740137771756205L;
    }

    public static class UnexpectedOnCompletedException
    extends RuntimeException {
        private static final long serialVersionUID = 7164517608988798969L;
    }

    public static class WrongOnNextCountException
    extends RuntimeException {
        private static final long serialVersionUID = 984672575527784559L;
    }

    public static class ExpectedExceptionNotThrownException
    extends RuntimeException {
        private static final long serialVersionUID = -104410457605712970L;
    }

    public static class ExpectedErrorNotReceivedException
    extends RuntimeException {
        private static final long serialVersionUID = -567146145612029349L;
    }

    public static class TerminalEventTimeoutException
    extends RuntimeException {
        private static final long serialVersionUID = -7355281653999339840L;
    }

    private static final class MyTestSubscriber<T>
    extends Subscriber<T> {
        private final List<T> next = new ArrayList<T>();
        private final Optional<Long> onStartRequest;
        private final Optional<Long> onNextRequest;
        private final Optional<Integer> unsubscribeAfter;
        private final CountDownLatch terminalLatch;
        private int completed = 0;
        private int count = 0;
        private int errors = 0;
        private final AtomicLong expected = new AtomicLong();
        private Optional<Throwable> lastError = Optional.absent();
        private Optional<Long> onNextRequest2;

        MyTestSubscriber(Optional<Integer> unsubscribeAfter, Optional<Long> onStartRequest, Optional<Long> onNextRequest, Optional<Long> onNextRequest2) {
            this.unsubscribeAfter = unsubscribeAfter;
            this.onStartRequest = onStartRequest;
            this.onNextRequest = onNextRequest;
            this.onNextRequest2 = onNextRequest2;
            this.terminalLatch = new CountDownLatch(1);
        }

        MyTestSubscriber(Optional<Integer> unsubscribeAfter) {
            this(unsubscribeAfter, ABSENT, ABSENT, ABSENT);
        }

        @Override
        public void onStart() {
            if (!this.onStartRequest.isPresent()) {
                this.expected.set(Long.MAX_VALUE);
            } else {
                this.expected.set(0L);
            }
            if (this.onStartRequest.isPresent()) {
                this.requestMore(this.onStartRequest.get());
            }
        }

        private void requestMore(long n) {
            if (this.expected.get() != Long.MAX_VALUE) {
                if (n > 0L) {
                    this.expected.addAndGet(n);
                }
                this.request(n);
            }
        }

        @Override
        public void onCompleted() {
            ++this.completed;
            this.terminalLatch.countDown();
        }

        @Override
        public void onError(Throwable e) {
            ++this.errors;
            this.lastError = Optional.of(e);
            this.terminalLatch.countDown();
        }

        @Override
        public void onNext(T t) {
            long exp = this.expected.get() != Long.MAX_VALUE ? this.expected.decrementAndGet() : this.expected.get();
            this.next.add(t);
            ++this.count;
            if (exp < 0L) {
                this.onError(new DeliveredMoreThanRequestedException());
            } else if (this.unsubscribeAfter.isPresent() && this.count == this.unsubscribeAfter.get()) {
                this.unsubscribe();
            } else {
                if (this.onNextRequest.isPresent()) {
                    this.requestMore(this.onNextRequest.get());
                }
                if (this.onNextRequest2.isPresent()) {
                    this.requestMore(this.onNextRequest2.get());
                }
            }
        }

        void assertError(Class<?> cls) {
            if (this.errors != 1 || !cls.isInstance(this.lastError.get())) {
                throw new ExpectedErrorNotReceivedException();
            }
        }

        void assertReceivedCountIs(long count) {
            if (count != (long)this.next.size()) {
                throw new WrongOnNextCountException();
            }
        }

        void awaitTerminalEvent(long duration, TimeUnit unit) {
            try {
                if (!this.terminalLatch.await(duration, unit)) {
                    throw new TerminalEventTimeoutException();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        void assertReceivedOnNext(List<T> expected, boolean ordered) {
            if (!TestingHelper.equals(expected, this.next, ordered)) {
                throw new UnexpectedOnNextException("expected=" + expected + ", actual=" + this.next);
            }
        }

        void assertUnsubscribed() {
            if (!this.isUnsubscribed()) {
                throw new DownstreamUnsubscriptionDidNotOccurException();
            }
        }

        int numOnCompletedEvents() {
            return this.completed;
        }

        void assertNoErrors() {
            if (this.errors > 0) {
                this.lastError.get().printStackTrace();
                throw new UnexpectedOnErrorException();
            }
        }
    }

    public static class UnsubscriptionFromSourceTimeoutException
    extends RuntimeException {
        private static final long serialVersionUID = -1142604414390722544L;
    }

    private static class Case<T, R> {
        final String name;
        final Observable<T> from;
        final Optional<List<R>> expected;
        final boolean checkSourceUnsubscribed;
        final Func1<Observable<T>, Observable<R>> function;
        final Optional<Integer> unsubscribeAfter;
        final boolean ordered;
        final Optional<Long> expectSize;
        final Optional<Class<? extends Throwable>> expectError;
        final long waitForUnusbscribeMs;
        final long waitForTerminalEventMs;
        final long waitForMoreTerminalEventsMs;
        final Optional<Class<? extends RuntimeException>> expectedException;

        Case(Observable<T> from, Optional<List<R>> expected, boolean ordered, Optional<Long> expectSize, boolean checkSourceUnsubscribed, Func1<Observable<T>, Observable<R>> function, String name, Optional<Integer> unsubscribeAfter, Optional<Class<? extends Throwable>> expectError, long waitForUnusbscribeMs, long waitForTerminalEventMs, long waitForMoreTerminalEventsMs, Optional<Class<? extends RuntimeException>> expectedException) {
            Preconditions.checkNotNull(from);
            Preconditions.checkNotNull(expected);
            Preconditions.checkNotNull(expectSize);
            Preconditions.checkNotNull(function);
            Preconditions.checkNotNull(name);
            Preconditions.checkNotNull(unsubscribeAfter);
            Preconditions.checkNotNull(expectError);
            Preconditions.checkNotNull(expectedException);
            this.from = from;
            this.expected = expected;
            this.ordered = ordered;
            this.expectSize = expectSize;
            this.checkSourceUnsubscribed = checkSourceUnsubscribed;
            this.function = function;
            this.name = name;
            this.unsubscribeAfter = unsubscribeAfter;
            this.expectError = expectError;
            this.waitForUnusbscribeMs = waitForUnusbscribeMs;
            this.waitForTerminalEventMs = waitForTerminalEventMs;
            this.waitForMoreTerminalEventsMs = waitForMoreTerminalEventsMs;
            this.expectedException = expectedException;
        }
    }

    public static class CaseBuilder<T, R> {
        private final Builder<T, R> builder;
        private String name;
        private Observable<T> from = Observable.empty();
        private boolean checkSourceUnsubscribed = true;
        private Optional<Integer> unsubscribeAfter = Optional.absent();

        private CaseBuilder(Builder<T, R> builder, Observable<T> from, String name) {
            Preconditions.checkNotNull(builder);
            Preconditions.checkNotNull(from);
            Preconditions.checkNotNull(name);
            this.builder = builder;
            this.from = from;
            this.name = name;
        }

        public CaseBuilder<T, R> name(String name) {
            Preconditions.checkNotNull(name, "name cannot be null");
            this.name = name;
            return this;
        }

        public CaseBuilder<T, R> fromEmpty() {
            this.from = Observable.empty();
            return this;
        }

        public CaseBuilder<T, R> from(T ... source) {
            Preconditions.checkNotNull(source, "source cannot be null");
            this.from = Observable.from(source);
            return this;
        }

        public CaseBuilder<T, R> from(Observable<T> source) {
            Preconditions.checkNotNull(source, "source cannot be null");
            this.from = source;
            return this;
        }

        public CaseBuilder<T, R> fromError() {
            this.from = Observable.error(new TestingException());
            return this;
        }

        public CaseBuilder<T, R> fromErrorAfter(T ... source) {
            Preconditions.checkNotNull(source, "source cannot be null");
            this.from = Observable.from(source).concatWith(Observable.error(new TestingException()));
            return this;
        }

        public CaseBuilder<T, R> fromErrorAfter(Observable<T> source) {
            Preconditions.checkNotNull(source, "source cannot be null");
            this.from = source;
            return this;
        }

        public CaseBuilder<T, R> skipUnsubscribedCheck() {
            this.checkSourceUnsubscribed = false;
            return this;
        }

        public Builder<T, R> expectEmpty() {
            return this.expect(Collections.emptyList());
        }

        public Builder<T, R> expectError() {
            return this.expectError(TestingException.class);
        }

        public Builder<T, R> expectError(Class<? extends Throwable> cls) {
            Preconditions.checkNotNull(cls, "cls cannot be null");
            return ((Builder)this.builder).expect(this.from, Optional.absent(), true, ABSENT, this.checkSourceUnsubscribed, this.name, this.unsubscribeAfter, Optional.of(cls), Optional.absent());
        }

        public Builder<T, R> expect(R ... source) {
            Preconditions.checkNotNull(source, "source cannot be null");
            return this.expect(Arrays.asList(source));
        }

        public Builder<T, R> expectSize(long n) {
            return ((Builder)this.builder).expect(this.from, Optional.absent(), true, Optional.of(n), this.checkSourceUnsubscribed, this.name, this.unsubscribeAfter, Optional.absent(), Optional.absent());
        }

        public Builder<T, R> expect(List<R> source) {
            Preconditions.checkNotNull(source, "source cannot be null");
            return this.expect(source, true);
        }

        private Builder<T, R> expect(List<R> items, boolean ordered) {
            return ((Builder)this.builder).expect(this.from, Optional.of(items), ordered, ABSENT, this.checkSourceUnsubscribed, this.name, this.unsubscribeAfter, Optional.absent(), Optional.absent());
        }

        public Builder<T, R> expectAnyOrder(R ... source) {
            Preconditions.checkNotNull(source, "source cannot be null");
            return this.expect(Arrays.asList(source), false);
        }

        public CaseBuilder<T, R> unsubscribeAfter(int n) {
            this.unsubscribeAfter = Optional.of(n);
            return this;
        }

        public Builder<T, R> expectException(Class<? extends RuntimeException> cls) {
            return ((Builder)this.builder).expect(this.from, Optional.absent(), true, ABSENT, this.checkSourceUnsubscribed, this.name, this.unsubscribeAfter, Optional.absent(), Optional.of(cls));
        }
    }

    public static class Builder<T, R> {
        private final List<Case<T, R>> cases = new ArrayList<Case<T, R>>();
        private Func1<Observable<T>, Observable<R>> function;
        private long waitForUnusbscribeMs = 100L;
        private long waitForTerminalEventMs = 10000L;
        private long waitForMoreTerminalEventsMs = 50L;

        private Builder() {
        }

        public Builder<T, R> function(Func1<Observable<T>, Observable<R>> function) {
            Preconditions.checkNotNull(function, "function cannot be null");
            this.function = function;
            return this;
        }

        public Builder<T, R> waitForUnsubscribe(long duration, TimeUnit unit) {
            Preconditions.checkNotNull((Object)unit, "unit cannot be null");
            this.waitForUnusbscribeMs = unit.toMillis(duration);
            return this;
        }

        public Builder<T, R> waitForTerminalEvent(long duration, TimeUnit unit) {
            Preconditions.checkNotNull((Object)unit, "unit cannot be null");
            this.waitForTerminalEventMs = unit.toMillis(duration);
            return this;
        }

        public Builder<T, R> waitForMoreTerminalEvents(long duration, TimeUnit unit) {
            Preconditions.checkNotNull((Object)unit, "unit cannot be null");
            this.waitForMoreTerminalEventsMs = unit.toMillis(duration);
            return this;
        }

        public CaseBuilder<T, R> name(String name) {
            Preconditions.checkNotNull(name, "name cannot be null");
            return new CaseBuilder(this, Observable.empty(), name);
        }

        public TestSuite testSuite(Class<?> cls) {
            Preconditions.checkNotNull(cls, "cls cannot be null");
            return new TestSuiteFromCases<T, R>(cls, new ArrayList<Case<T, R>>(this.cases));
        }

        private Builder<T, R> expect(Observable<T> from, Optional<List<R>> expected, boolean ordered, Optional<Long> expectSize, boolean checkSourceUnsubscribed, String name, Optional<Integer> unsubscribeAfter, Optional<Class<? extends Throwable>> expectError, Optional<Class<? extends RuntimeException>> expectException) {
            this.cases.add(new Case<T, R>(from, expected, ordered, expectSize, checkSourceUnsubscribed, this.function, name, unsubscribeAfter, expectError, this.waitForUnusbscribeMs, this.waitForTerminalEventMs, this.waitForMoreTerminalEventsMs, expectException));
            return this;
        }
    }
}

