/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.util;

import com.github.davidmoten.rx.util.Drainer;
import java.util.Queue;
import rx.Subscriber;
import rx.exceptions.MissingBackpressureException;
import rx.internal.operators.NotificationLite;

public final class DrainerSyncBiased<T>
implements Drainer<T> {
    private final NotificationLite<Object> on = NotificationLite.instance();
    private final Queue<T> queue;
    private final Subscriber<? super T> child;
    private long expected;
    private boolean busy;
    private boolean finished;
    private Throwable error;
    private long counter;
    private long surplus;

    public static <T> DrainerSyncBiased<T> create(Queue<T> queue, Subscriber<? super T> child) {
        return new DrainerSyncBiased<T>(queue, child);
    }

    private DrainerSyncBiased(Queue<T> queue, Subscriber<? super T> child) {
        this.queue = queue;
        this.child = child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void request(long n) {
        if (n <= 0L) {
            return;
        }
        DrainerSyncBiased drainerSyncBiased = this;
        synchronized (drainerSyncBiased) {
            this.expected += n;
            if (this.expected < 0L) {
                this.expected = Long.MAX_VALUE;
            }
            if (this.expected == Long.MAX_VALUE) {
                this.surplus = 0L;
            }
            if (this.busy) {
                ++this.counter;
                return;
            }
            this.busy = true;
        }
        try {
            this.drain();
        }
        finally {
            drainerSyncBiased = this;
            synchronized (drainerSyncBiased) {
                this.busy = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompleted() {
        DrainerSyncBiased drainerSyncBiased = this;
        synchronized (drainerSyncBiased) {
            this.finished = true;
            if (this.busy) {
                ++this.counter;
                return;
            }
            this.busy = true;
        }
        try {
            this.drain();
        }
        finally {
            drainerSyncBiased = this;
            synchronized (drainerSyncBiased) {
                this.busy = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable e) {
        DrainerSyncBiased drainerSyncBiased = this;
        synchronized (drainerSyncBiased) {
            this.error = e;
            this.finished = true;
            if (this.busy) {
                ++this.counter;
                return;
            }
            this.busy = true;
        }
        try {
            this.drain();
        }
        finally {
            drainerSyncBiased = this;
            synchronized (drainerSyncBiased) {
                this.busy = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(T t) {
        if (!this.queue.offer(t)) {
            this.onError(new MissingBackpressureException());
        } else {
            DrainerSyncBiased drainerSyncBiased = this;
            synchronized (drainerSyncBiased) {
                if (this.expected != Long.MAX_VALUE) {
                    ++this.surplus;
                }
            }
            this.drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drain() {
        long r;
        DrainerSyncBiased drainerSyncBiased = this;
        synchronized (drainerSyncBiased) {
            r = this.expected;
        }
        while (true) {
            long emitted = 0L;
            DrainerSyncBiased drainerSyncBiased2 = this;
            synchronized (drainerSyncBiased2) {
                this.counter = 1L;
            }
            while (!this.child.isUnsubscribed()) {
                T o;
                boolean isFinished;
                DrainerSyncBiased drainerSyncBiased3 = this;
                synchronized (drainerSyncBiased3) {
                    isFinished = this.finished;
                }
                if (isFinished) {
                    Throwable error;
                    DrainerSyncBiased drainerSyncBiased4 = this;
                    synchronized (drainerSyncBiased4) {
                        error = this.error;
                    }
                    if (error != null) {
                        this.queue.clear();
                        this.child.onError(error);
                        return;
                    }
                    if (this.queue.isEmpty()) {
                        this.child.onCompleted();
                        return;
                    }
                }
                if (r <= 0L || (o = this.queue.poll()) == null) break;
                --this.surplus;
                this.child.onNext(this.on.getValue(o));
                --r;
                ++emitted;
            }
            if (emitted > 0L) {
                if (r == Long.MAX_VALUE) continue;
                DrainerSyncBiased drainerSyncBiased5 = this;
                synchronized (drainerSyncBiased5) {
                    this.expected -= emitted;
                    r = this.expected;
                }
            }
            DrainerSyncBiased drainerSyncBiased6 = this;
            synchronized (drainerSyncBiased6) {
                if (--this.counter == 0L) {
                    break;
                }
                r = this.expected;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long surplus() {
        DrainerSyncBiased drainerSyncBiased = this;
        synchronized (drainerSyncBiased) {
            return this.surplus;
        }
    }
}

