/*
 * Decompiled with CFR 0.152.
 */
package com4j;

import com4j.ComException;
import com4j.DISPID;
import com4j.EventCookie;
import com4j.IllegalAnnotationException;
import com4j.Native;
import com4j.Task;
import com4j.Variant;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EventProxy<T>
implements EventCookie {
    private final EventInterfaceDescriptor<T> descriptor;
    private final T javaObject;
    long nativeProxy;
    private static final Map<Class, EventInterfaceDescriptor> descriptors = Collections.synchronizedMap(new WeakHashMap());
    private static final int DISP_E_UNKNOWNNAME = -2147352570;
    private static final int DISP_E_MEMBERNOTFOUND = -2147352573;
    private static final int DISP_E_BADPARAMCOUNT = -2147352562;
    private static final Logger logger = Logger.getLogger(EventProxy.class.getName());

    EventProxy(Class<T> intf, T javaObject) {
        this.descriptor = EventProxy.getDescriptor(intf);
        this.javaObject = javaObject;
    }

    @Override
    public void close() {
        if (this.nativeProxy != 0L) {
            new Task<Void>(){

                @Override
                public Void call() {
                    Native.unadvise(EventProxy.this.nativeProxy);
                    return null;
                }
            }.execute();
            this.nativeProxy = 0L;
        }
    }

    int[] getDISPIDs(String[] names) {
        int[] r = new int[names.length];
        for (int i = 0; i < names.length; ++i) {
            r[i] = this.descriptor.getDISPID(names[i]);
        }
        return r;
    }

    Object invoke(int dispId, int flag, Variant[] args) throws Throwable {
        EventMethod m = this.descriptor.get(dispId);
        if (m == null) {
            throw new ComException("Undefined DISPID=" + dispId, -2147352573);
        }
        return m.invoke(this.javaObject, flag, args);
    }

    static String getErrorSource(Throwable t) {
        return t.toString();
    }

    static String getErrorDetail(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private static <T> EventInterfaceDescriptor<T> getDescriptor(Class<T> t) {
        EventInterfaceDescriptor<T> r = descriptors.get(t);
        if (r == null) {
            r = new EventInterfaceDescriptor<T>(t);
            descriptors.put(t, r);
        }
        return r;
    }

    static {
        boolean com4jDebug = false;
        try {
            com4jDebug = System.getProperty("com4j.debug") != null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!com4jDebug) {
            logger.setLevel(Level.OFF);
        }
    }

    private static class EventMethod {
        private final int dispid;
        private final Method method;
        private final Class<?>[] params;

        public EventMethod(Method m) {
            DISPID a = m.getAnnotation(DISPID.class);
            if (a == null) {
                throw new IllegalAnnotationException(m + " needs to have @DISPID");
            }
            this.dispid = a.value();
            this.method = m;
            this.params = m.getParameterTypes();
        }

        public Object invoke(Object o, int flag, Variant[] args) throws Throwable {
            try {
                if (args.length != this.params.length) {
                    throw new ComException("Argument length mismatch. Expected " + this.params.length + " but found " + args.length, -2147352562);
                }
                Object[] oargs = new Object[args.length];
                for (int i = 0; i < args.length; ++i) {
                    oargs[i] = args[i].convertTo(this.params[i]);
                }
                return this.method.invoke(o, oargs);
            }
            catch (InvocationTargetException e) {
                logger.log(Level.WARNING, this.method + " on " + o + " reported an exception", e.getTargetException());
                throw e.getTargetException();
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, "Unable to invoke " + this.method + " on " + o, e);
                throw e;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventInterfaceDescriptor<T> {
        private final Class<T> eventInterface;
        private final Map<String, EventMethod> methodsByName = new HashMap<String, EventMethod>();
        private final Map<Integer, EventMethod> methodsByID = new HashMap<Integer, EventMethod>();

        EventInterfaceDescriptor(Class<T> eventInterface) {
            this.eventInterface = eventInterface;
            for (Method m : eventInterface.getDeclaredMethods()) {
                EventMethod em = new EventMethod(m);
                this.methodsByName.put(m.getName(), em);
                this.methodsByID.put(em.dispid, em);
            }
        }

        public int getDISPID(String name) {
            EventMethod r = this.methodsByName.get(name);
            if (r == null) {
                return -2147352570;
            }
            return r.dispid;
        }

        public EventMethod get(int id) {
            return this.methodsByID.get(id);
        }
    }
}

