/*
 * Decompiled with CFR 0.152.
 */
package com4j;

import com4j.ComException;
import com4j.ComMethod;
import com4j.ErrorInfo;
import com4j.Holder;
import com4j.IErrorInfo;
import com4j.IllegalAnnotationException;
import com4j.Native;
import com4j.VTID;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StandardComMethod
extends ComMethod {
    final int vtIndex;

    StandardComMethod(Method m) {
        super(m);
        VTID vtid = m.getAnnotation(VTID.class);
        if (vtid == null) {
            throw new IllegalAnnotationException("@VTID is missing: " + m.toGenericString());
        }
        this.vtIndex = vtid.value();
    }

    @Override
    Object invoke(long ptr, Object[] args) {
        Object object;
        this.messageParameters(args);
        try {
            Object r = Native.invoke(ptr, this.vtIndex, args, this.paramConvs, this.returnIndex, this.returnIsInOut, this.returnConv.code);
            object = this.returnConv.toJava(this.method.getReturnType(), this.method.getGenericReturnType(), r);
            Object var7_8 = null;
        }
        catch (ComException e) {
            try {
                try {
                    IErrorInfo pErrorInfo = Native.getErrorInfo(ptr, this.method.getDeclaringClass());
                    if (pErrorInfo != null) {
                        e.setErrorInfo(new ErrorInfo(pErrorInfo));
                        pErrorInfo.dispose();
                    }
                }
                catch (ComException x) {
                    // empty catch block
                }
                throw e;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                for (int i = 0; i < args.length; ++i) {
                    if (args[i] instanceof Holder && this.params[i].getNoByRef() != null) {
                        Holder h = (Holder)args[i];
                        Type holderParamType = StandardComMethod.getTypeParameter(this.genericParamTypes[i], 0);
                        h.value = this.params[i].getNoByRef().toJava(StandardComMethod.erasure(holderParamType), holderParamType, h.value);
                        continue;
                    }
                    this.params[i].cleanupNative(args[i]);
                }
                throw throwable;
            }
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof Holder && this.params[i].getNoByRef() != null) {
                Holder h = (Holder)args[i];
                Type holderParamType = StandardComMethod.getTypeParameter(this.genericParamTypes[i], 0);
                h.value = this.params[i].getNoByRef().toJava(StandardComMethod.erasure(holderParamType), holderParamType, h.value);
                continue;
            }
            this.params[i].cleanupNative(args[i]);
        }
        return object;
    }

    private static Type getTypeParameter(Type t, int index) {
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            return pt.getActualTypeArguments()[index];
        }
        return Object.class;
    }

    private static Class<?> erasure(Type t) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            return StandardComMethod.erasure(pt.getRawType());
        }
        if (t instanceof WildcardType) {
            WildcardType wt = (WildcardType)t;
            Type[] ub = wt.getUpperBounds();
            if (ub.length == 0) {
                return Object.class;
            }
            return StandardComMethod.erasure(ub[0]);
        }
        if (t instanceof GenericArrayType) {
            GenericArrayType ga = (GenericArrayType)t;
            return Array.newInstance(StandardComMethod.erasure(ga.getGenericComponentType()), 0).getClass();
        }
        if (t instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)t;
            Type[] ub = tv.getBounds();
            if (ub.length == 0) {
                return Object.class;
            }
            return StandardComMethod.erasure(ub[0]);
        }
        throw new IllegalArgumentException(t.toString());
    }
}

