/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import javolution.context.AbstractContext;
import javolution.lang.Configurable;
import javolution.osgi.internal.OSGiServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComputeContext
extends AbstractContext {
    public static final Configurable<Boolean> DOUBLE_PRECISION_REQUIRED = new Configurable<Boolean>(){

        @Override
        protected Boolean getDefault() {
            return true;
        }
    };

    private static ComputeContext currentComputeContext() {
        ComputeContext ctx = ComputeContext.current(ComputeContext.class);
        if (ctx != null) {
            return ctx;
        }
        return OSGiServices.getComputeContext();
    }

    public static ComputeContext enter() {
        ComputeContext ctx = ComputeContext.currentComputeContext();
        return (ComputeContext)ctx.enterInner();
    }

    public static void load(Program program) {
        ComputeContext.currentComputeContext().loadAndBuild(program);
    }

    public static Buffer newBuffer(java.nio.Buffer init) {
        return ComputeContext.currentComputeContext().createBuffer(init);
    }

    public static Buffer newBuffer(long byteCount) {
        return ComputeContext.currentComputeContext().createBuffer(byteCount);
    }

    public static Kernel newKernel(Class<? extends Program> program, String kernelName) {
        return ComputeContext.currentComputeContext().createKernel(program, kernelName);
    }

    public static void unload(Program program) {
        ComputeContext.currentComputeContext().unloadAndFree(program);
    }

    protected ComputeContext() {
    }

    protected abstract Buffer createBuffer(java.nio.Buffer var1);

    protected abstract Buffer createBuffer(long var1);

    protected abstract Kernel createKernel(Class<? extends Program> var1, String var2);

    protected abstract void loadAndBuild(Program var1);

    protected abstract void unloadAndFree(Program var1);

    public static interface Program {
        public String toOpenCL();
    }

    public static interface Local {
        public void export();
    }

    public static interface Kernel {
        public void execute();

        public void setArguments(Object ... var1);

        public void setGlobalWorkSize(int ... var1);

        public void setLocalWorkSize(int ... var1);
    }

    public static interface Buffer
    extends Local {
        public ByteBuffer asByteBuffer();

        public CharBuffer asCharBuffer();

        public DoubleBuffer asDoubleBuffer();

        public FloatBuffer asFloatBuffer();

        public IntBuffer asIntBuffer();

        public LongBuffer asLongBuffer();

        public ShortBuffer asShortBuffer();

        public long getByteCount();

        public Buffer readOnly();
    }
}

