/*
 * Decompiled with CFR 0.152.
 */
package javolution.context.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javolution.context.LogContext;
import javolution.context.SecurityContext;
import javolution.context.StorageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StorageContextImpl
extends StorageContext {
    @Override
    public <V extends Serializable> V read(StorageContext.Resource<V> resource) throws SecurityException {
        SecurityContext.check(new SecurityContext.Permission<StorageContext.Resource<V>>(StorageContext.Resource.class, "write", resource));
        try {
            File file = new File((File)FILE_STORAGE_LOCATION.get(), resource.uniqueID());
            if (!file.exists()) {
                LogContext.debug("Resource file ", file.getAbsolutePath(), " does not exist.");
                return null;
            }
            LogContext.debug("Read resource file ", file.getAbsolutePath());
            FileInputStream fileIn = new FileInputStream(file);
            ObjectInputStream in = new ObjectInputStream(fileIn);
            Serializable value = (Serializable)in.readObject();
            in.close();
            fileIn.close();
            return (V)value;
        }
        catch (IOException e1) {
            LogContext.error(e1);
        }
        catch (ClassNotFoundException e2) {
            LogContext.error(e2);
        }
        return null;
    }

    @Override
    public <V extends Serializable> void write(StorageContext.Resource<V> resource, V value) throws SecurityException {
        SecurityContext.check(new SecurityContext.Permission<StorageContext.Resource<V>>(StorageContext.Resource.class, "write", resource));
        try {
            File storage = (File)FILE_STORAGE_LOCATION.get();
            storage.mkdirs();
            File file = new File(storage, resource.uniqueID());
            LogContext.debug("Write resource ", file.getAbsolutePath());
            FileOutputStream fileOut = new FileOutputStream(file);
            ObjectOutputStream out = new ObjectOutputStream(fileOut);
            out.writeObject(value);
            out.close();
            fileOut.close();
        }
        catch (IOException error) {
            LogContext.error(error);
        }
    }

    @Override
    protected StorageContext inner() {
        return this;
    }
}

