/*
 * Decompiled with CFR 0.152.
 */
package javolution.lang;

import java.lang.reflect.Field;
import javolution.context.LogContext;
import javolution.context.SecurityContext;
import javolution.osgi.internal.OSGiServices;
import javolution.text.TextContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Configurable<T> {
    public static SecurityContext.Permission<Configurable<?>> RECONFIGURE_PERMISSION = new SecurityContext.Permission<Configurable>(Configurable.class, "reconfigure");
    private String name;
    private final SecurityContext.Permission<Configurable<T>> reconfigurePermission = new SecurityContext.Permission<Configurable>(Configurable.class, "reconfigure", this);
    private volatile T value;

    public Configurable() {
        Object[] listeners;
        String name = this.getName();
        T defaultValue = this.getDefault();
        if (name != null) {
            try {
                String property = System.getProperty(name);
                if (property != null) {
                    defaultValue = this.parse(property);
                    LogContext.info(name, " superseded to ", defaultValue, " (system properties).");
                }
            }
            catch (SecurityException property) {
                // empty catch block
            }
        }
        this.name = name;
        this.value = this.initialized(defaultValue);
        for (Object listener : listeners = OSGiServices.getConfigurableListeners()) {
            ((Listener)listener).configurableInitialized(this, this.value);
        }
    }

    public T get() {
        return this.value;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        Class<?> thisClass = this.getClass();
        Class<?> enclosingClass = thisClass.getEnclosingClass();
        String fieldName = null;
        for (Field field : enclosingClass.getFields()) {
            if (!field.getType().isAssignableFrom(thisClass)) continue;
            if (fieldName != null) {
                throw new UnsupportedOperationException("Multiple configurables static fields in the same classrequires the Configurable.getName() method to be overriden.");
            }
            fieldName = field.getName();
        }
        return fieldName != null ? enclosingClass.getName() + "#" + fieldName : null;
    }

    public SecurityContext.Permission<Configurable<T>> getReconfigurePermission() {
        return this.reconfigurePermission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T reconfigure(T newValue) {
        SecurityContext.check(this.reconfigurePermission);
        Configurable configurable = this;
        synchronized (configurable) {
            Object[] listeners;
            T oldValue = this.value;
            this.value = this.reconfigured(oldValue, newValue);
            for (Object listener : listeners = OSGiServices.getConfigurableListeners()) {
                ((Listener)listener).configurableReconfigured(this, oldValue, this.value);
            }
            return this.value;
        }
    }

    protected abstract T getDefault();

    protected T initialized(T requestedValue) {
        return requestedValue;
    }

    protected T parse(String str) {
        Class<?> type = this.getDefault().getClass();
        return (T)TextContext.getFormat(type).parse(str);
    }

    protected T reconfigured(T oldValue, T requestedValue) {
        return requestedValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Listener {
        public <T> void configurableInitialized(Configurable<T> var1, T var2);

        public <T> void configurableReconfigured(Configurable<T> var1, T var2, T var3);
    }
}

