/*
 * Decompiled with CFR 0.152.
 */
package javolution.osgi.internal;

import javolution.util.FastTable;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public final class LogServiceImpl
extends Thread
implements LogService {
    private final FastTable<LogEvent> eventQueue = new FastTable();

    public LogServiceImpl() {
        super("Logging-Thread");
        this.setDaemon(true);
        this.start();
        Thread hook = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                FastTable fastTable = LogServiceImpl.this.eventQueue;
                synchronized (fastTable) {
                    try {
                        while (!LogServiceImpl.this.eventQueue.isEmpty()) {
                            LogServiceImpl.this.eventQueue.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        });
        Runtime.getRuntime().addShutdownHook(hook);
    }

    public void log(int level, String message) {
        this.log(level, message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(int level, String message, Throwable exception) {
        LogEvent event = new LogEvent();
        event.level = level;
        event.message = message;
        event.exception = exception;
        FastTable<LogEvent> fastTable = this.eventQueue;
        synchronized (fastTable) {
            this.eventQueue.addFirst(event);
            this.eventQueue.notify();
        }
    }

    public void log(ServiceReference sr, int level, String message) {
        throw new UnsupportedOperationException();
    }

    public void log(ServiceReference sr, int level, String message, Throwable exception) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                while (true) {
                    LogEvent event;
                    FastTable<LogEvent> fastTable = this.eventQueue;
                    synchronized (fastTable) {
                        while (this.eventQueue.isEmpty()) {
                            this.eventQueue.wait();
                        }
                        event = this.eventQueue.pollLast();
                        this.eventQueue.notify();
                    }
                    switch (event.level) {
                        case 4: {
                            System.out.println("[DEBUG] " + event.message);
                            break;
                        }
                        case 3: {
                            System.out.println("[INFO] " + event.message);
                            break;
                        }
                        case 2: {
                            System.out.println("[WARNING] " + event.message);
                            break;
                        }
                        case 1: {
                            System.out.println("[ERROR] " + event.message);
                            break;
                        }
                        default: {
                            System.out.println("[UNKNOWN] " + event.message);
                        }
                    }
                    if (event.exception == null) continue;
                    event.exception.printStackTrace(System.out);
                }
            }
            catch (InterruptedException error) {
                error.printStackTrace(System.err);
                continue;
            }
            break;
        }
    }

    private static class LogEvent {
        Throwable exception;
        int level;
        String message;

        private LogEvent() {
        }
    }
}

