/*
 * Decompiled with CFR 0.152.
 */
package javolution.text;

import java.io.IOException;
import java.io.Reader;
import javolution.text.Text;

public class TextReader
extends Reader {
    private Text text;
    private int length;
    private int next = 0;
    private int mark = 0;

    public TextReader(Text text) {
        this.text = text;
        this.length = text.length();
    }

    public int read() throws IOException {
        if (this.next >= this.length) {
            return -1;
        }
        return this.text.charAt(this.next++);
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.next >= this.length) {
            return -1;
        }
        int n = Math.min(this.length - this.next, len);
        this.text.getChars(this.next, this.next + n, cbuf, off);
        this.next += n;
        return n;
    }

    public long skip(long ns) throws IOException {
        if (this.next >= this.length) {
            return 0L;
        }
        long n = Math.min((long)(this.length - this.next), ns);
        n = Math.max((long)(-this.next), n);
        this.next = (int)((long)this.next + n);
        return n;
    }

    public boolean ready() throws IOException {
        if (this.text == null) {
            throw new IOException("TextReader is Closed");
        }
        return true;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readAheadLimit) throws IOException {
        if (readAheadLimit < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        this.mark = this.next;
    }

    public void reset() throws IOException {
        this.next = this.mark;
    }

    public void close() {
        this.text = null;
    }
}

