/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.util.Collection;
import java.util.Set;
import javolution.lang.Realtime;
import javolution.util.FastCollection;
import javolution.util.function.Equalities;
import javolution.util.function.Equality;
import javolution.util.function.Predicate;
import javolution.util.internal.map.FastMapImpl;
import javolution.util.internal.set.AtomicSetImpl;
import javolution.util.internal.set.FilteredSetImpl;
import javolution.util.internal.set.SharedSetImpl;
import javolution.util.internal.set.UnmodifiableSetImpl;
import javolution.util.service.SetService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastSet<E>
extends FastCollection<E>
implements Set<E> {
    private static final long serialVersionUID = 1536L;
    private final SetService<E> service;

    public static <E> FastSet<E> of(E ... elements) {
        FastSet<E> set = new FastSet<E>();
        for (E e : elements) {
            set.add(e);
        }
        return set;
    }

    public static <E> FastSet<E> of(Collection<? extends E> that) {
        FastSet<? extends E> set = new FastSet<E>();
        set.addAll(that);
        return set;
    }

    public FastSet() {
        this(Equalities.STANDARD);
    }

    public FastSet(Equality<? super E> comparator) {
        this.service = new FastMapImpl<E, Object>(comparator, Equalities.IDENTITY).keySet();
    }

    protected FastSet(SetService<E> service) {
        this.service = service;
    }

    @Override
    public FastSet<E> atomic() {
        return new FastSet(new AtomicSetImpl(this.service()));
    }

    @Override
    public FastSet<E> filtered(Predicate<? super E> filter) {
        return new FastSet<E>(new FilteredSetImpl<E>(this.service(), filter));
    }

    @Override
    public FastSet<E> shared() {
        return new FastSet(new SharedSetImpl(this.service()));
    }

    @Override
    public FastSet<E> unmodifiable() {
        return new FastSet(new UnmodifiableSetImpl(this.service()));
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public int size() {
        return this.service.size();
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public void clear() {
        this.service.clear();
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public boolean contains(Object obj) {
        return this.service.contains(obj);
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public boolean remove(Object obj) {
        return this.service.remove(obj);
    }

    @Override
    protected SetService<E> service() {
        return this.service;
    }
}

