/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import javolution.lang.Realtime;
import javolution.util.FastCollection;
import javolution.util.function.Consumer;
import javolution.util.function.Equalities;
import javolution.util.function.Equality;
import javolution.util.function.Function;
import javolution.util.internal.table.AtomicTableImpl;
import javolution.util.internal.table.FastTableImpl;
import javolution.util.internal.table.MappedTableImpl;
import javolution.util.internal.table.QuickSort;
import javolution.util.internal.table.ReversedTableImpl;
import javolution.util.internal.table.SharedTableImpl;
import javolution.util.internal.table.SubTableImpl;
import javolution.util.internal.table.UnmodifiableTableImpl;
import javolution.util.service.TableService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastTable<E>
extends FastCollection<E>
implements List<E>,
Deque<E>,
RandomAccess {
    private static final long serialVersionUID = 1536L;
    private final TableService<E> service;

    public static <E> FastTable<E> of(E ... elements) {
        FastTable<E> table = new FastTable<E>();
        for (E e : elements) {
            table.add(e);
        }
        return table;
    }

    public static <E> FastTable<E> of(Collection<? extends E> that) {
        FastTable<? extends E> table = new FastTable<E>();
        table.addAll(that);
        return table;
    }

    public FastTable() {
        this(Equalities.STANDARD);
    }

    public FastTable(Equality<? super E> comparator) {
        this.service = new FastTableImpl<E>(comparator);
    }

    protected FastTable(TableService<E> service) {
        this.service = service;
    }

    @Override
    public FastTable<E> atomic() {
        return new FastTable<E>(new AtomicTableImpl<E>(this.service));
    }

    @Override
    public FastTable<E> reversed() {
        return new FastTable<E>(new ReversedTableImpl<E>(this.service));
    }

    @Override
    public FastTable<E> shared() {
        return new FastTable<E>(new SharedTableImpl<E>(this.service));
    }

    @Override
    public FastTable<E> unmodifiable() {
        return new FastTable<E>(new UnmodifiableTableImpl<E>(this.service));
    }

    @Override
    public <R> FastTable<R> mapped(Function<? super E, ? extends R> function) {
        return new FastTable<E>(new MappedTableImpl<E, R>(this.service(), function));
    }

    public FastTable<E> subTable(int fromIndex, int toIndex) {
        return new FastTable<E>(new SubTableImpl<E>(this.service, fromIndex, toIndex));
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public boolean isEmpty() {
        return this.service.isEmpty();
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public int size() {
        return this.service.size();
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public void clear() {
        this.service.clear();
    }

    @Override
    @Realtime(limit=Realtime.Limit.LOG_N)
    public void add(int index, E element) {
        this.service.add(index, element);
    }

    @Override
    @Realtime(limit=Realtime.Limit.N_LOG_N)
    public boolean addAll(int index, Collection<? extends E> elements) {
        return this.service.addAll(index, elements);
    }

    @Override
    @Realtime(limit=Realtime.Limit.LOG_N)
    public E remove(int index) {
        return this.service.remove(index);
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public E get(int index) {
        return this.service.get(index);
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public E set(int index, E element) {
        return this.service.set(index, element);
    }

    @Override
    @Realtime(limit=Realtime.Limit.LINEAR)
    public int indexOf(Object element) {
        return this.service.indexOf(element);
    }

    @Override
    @Realtime(limit=Realtime.Limit.LINEAR)
    public int lastIndexOf(Object element) {
        return this.service.lastIndexOf(element);
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public ListIterator<E> listIterator() {
        return this.service.listIterator();
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public ListIterator<E> listIterator(int index) {
        return this.service.listIterator(index);
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public void addFirst(E element) {
        this.service.addFirst(element);
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public void addLast(E element) {
        this.service.addLast(element);
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public E getFirst() {
        return this.service.getFirst();
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public E getLast() {
        return this.service.getLast();
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public E peekFirst() {
        return this.service.peekFirst();
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public E peekLast() {
        return this.service.peekLast();
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public E pollFirst() {
        return this.service.pollFirst();
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public E pollLast() {
        return this.service.pollLast();
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public E removeFirst() {
        return this.service.removeFirst();
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public E removeLast() {
        return this.service.removeLast();
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public boolean offerFirst(E e) {
        return this.service.offerFirst(e);
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public boolean offerLast(E e) {
        return this.service.offerLast(e);
    }

    @Override
    @Realtime(limit=Realtime.Limit.LINEAR)
    public boolean removeFirstOccurrence(Object o) {
        return this.service.removeFirstOccurrence(o);
    }

    @Override
    @Realtime(limit=Realtime.Limit.LINEAR)
    public boolean removeLastOccurrence(Object o) {
        return this.service.removeLastOccurrence(o);
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public boolean offer(E e) {
        return this.service.offer(e);
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public E remove() {
        return this.service.remove();
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public E poll() {
        return this.service.poll();
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public E element() {
        return this.service.element();
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public E peek() {
        return this.service.peek();
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public void push(E e) {
        this.service.push(e);
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public E pop() {
        return this.service.pop();
    }

    @Override
    @Realtime(limit=Realtime.Limit.CONSTANT)
    public Iterator<E> descendingIterator() {
        return this.service.descendingIterator();
    }

    @Realtime(limit=Realtime.Limit.N_SQUARE)
    public void sort() {
        this.update(new Consumer<TableService<E>>(){

            @Override
            public void accept(TableService<E> table) {
                QuickSort qs = new QuickSort(table, table.comparator());
                qs.sort();
            }
        });
    }

    @Override
    @Deprecated
    public FastTable<E> subList(int fromIndex, int toIndex) {
        return this.subTable(fromIndex, toIndex);
    }

    @Override
    protected TableService<E> service() {
        return this.service;
    }
}

