/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.function;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javolution.lang.Parallelizable;
import javolution.lang.Realtime;
import javolution.util.function.Reducer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reducers {
    private Reducers() {
    }

    @Parallelizable
    @Realtime(limit=Realtime.Limit.LINEAR)
    public static <E> Reducer<E> any(Class<? extends E> type) {
        return new AnyReducer<E>(type);
    }

    @Parallelizable(mutexFree=true, comment="Internal use of AtomicReference")
    @Realtime(limit=Realtime.Limit.LINEAR)
    public static <E> Reducer<E> max(Comparator<? super E> comparator) {
        return new MaxReducer<E>(comparator);
    }

    @Parallelizable(mutexFree=true, comment="Internal use of AtomicReference")
    @Realtime(limit=Realtime.Limit.LINEAR)
    public static <E> Reducer<E> min(Comparator<? super E> comparator) {
        return new MinReducer<E>(comparator);
    }

    @Parallelizable
    @Realtime(limit=Realtime.Limit.LINEAR)
    public static Reducer<Boolean> and() {
        return new AndReducer();
    }

    @Parallelizable
    @Realtime(limit=Realtime.Limit.LINEAR)
    public static Reducer<Boolean> or() {
        return new OrReducer();
    }

    @Parallelizable(comment="Internal use of AtomicInteger")
    @Realtime(limit=Realtime.Limit.LINEAR)
    public static Reducer<Integer> sum() {
        return new SumReducer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SumReducer
    implements Reducer<Integer> {
        private final AtomicInteger sum = new AtomicInteger(0);

        private SumReducer() {
        }

        @Override
        public void accept(Collection<Integer> param) {
            Iterator<Integer> it = param.iterator();
            while (it.hasNext()) {
                this.sum.getAndAdd(it.next());
            }
        }

        @Override
        public Integer get() {
            return this.sum.get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OrReducer
    implements Reducer<Boolean> {
        volatile boolean result = false;

        private OrReducer() {
        }

        @Override
        public void accept(Collection<Boolean> param) {
            Iterator<Boolean> it = param.iterator();
            while (!this.result && it.hasNext()) {
                if (it.next().booleanValue()) continue;
                this.result = true;
            }
        }

        @Override
        public Boolean get() {
            return this.result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AndReducer
    implements Reducer<Boolean> {
        volatile boolean result = true;

        private AndReducer() {
        }

        @Override
        public void accept(Collection<Boolean> param) {
            Iterator<Boolean> it = param.iterator();
            while (this.result && it.hasNext()) {
                if (it.next().booleanValue()) continue;
                this.result = false;
            }
        }

        @Override
        public Boolean get() {
            return this.result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MinReducer<E>
    implements Reducer<E> {
        private final Comparator<? super E> cmp;
        private final AtomicReference<E> min = new AtomicReference<Object>(null);

        public MinReducer(Comparator<? super E> cmp) {
            this.cmp = cmp;
        }

        @Override
        public void accept(Collection<E> param) {
            for (E e : param) {
                E read = this.min.get();
                while (!(read != null && this.cmp.compare(e, read) >= 0 || this.min.compareAndSet(read, e))) {
                    read = this.min.get();
                }
            }
        }

        @Override
        public E get() {
            return this.min.get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MaxReducer<E>
    implements Reducer<E> {
        private final Comparator<? super E> cmp;
        private final AtomicReference<E> max = new AtomicReference<Object>(null);

        public MaxReducer(Comparator<? super E> cmp) {
            this.cmp = cmp;
        }

        @Override
        public void accept(Collection<E> param) {
            for (E e : param) {
                E read = this.max.get();
                while (!(read != null && this.cmp.compare(e, read) <= 0 || this.max.compareAndSet(read, e))) {
                    read = this.max.get();
                }
            }
        }

        @Override
        public E get() {
            return this.max.get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnyReducer<E>
    implements Reducer<E> {
        private final Class<? extends E> type;
        private volatile E found;

        public AnyReducer(Class<? extends E> type) {
            this.type = type;
        }

        @Override
        public void accept(Collection<E> param) {
            Iterator<E> it = param.iterator();
            while (it.hasNext() && this.found == null) {
                E e = it.next();
                if (!this.type.isInstance(e)) continue;
                this.found = e;
                break;
            }
        }

        @Override
        public E get() {
            return this.found;
        }
    }
}

