/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.bitset;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javolution.util.Index;
import javolution.util.service.BitSetService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BitSetIteratorImpl
implements Iterator<Index> {
    private final BitSetService that;
    private int nextIndex;
    private int currentIndex = -1;

    public BitSetIteratorImpl(BitSetService that, int index) {
        this.that = that;
        this.nextIndex = that.nextSetBit(index);
    }

    @Override
    public boolean hasNext() {
        return this.nextIndex >= 0;
    }

    @Override
    public Index next() {
        if (this.nextIndex < 0) {
            throw new NoSuchElementException();
        }
        this.currentIndex = this.nextIndex;
        this.nextIndex = this.that.nextSetBit(this.nextIndex + 1);
        return Index.of(this.currentIndex);
    }

    @Override
    public void remove() {
        if (this.currentIndex < 0) {
            throw new IllegalStateException();
        }
        this.that.clear(this.currentIndex);
        this.currentIndex = -1;
    }
}

